/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.context;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/chat/context/ChatCodeDescription;", "", "displayCode", "Lcom/intellij/ml/llm/privacy/PSString;", "internalCode", "attachments", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "path", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Ljava/util/List;Lcom/intellij/ml/llm/privacy/PSString;)V", "getDisplayCode", "()Lcom/intellij/ml/llm/privacy/PSString;", "getInternalCode", "getPath", "getAttachments", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatCodeContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCodeContextProvider.kt\ncom/intellij/ml/llm/core/chat/context/ChatCodeDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n774#2:84\n865#2,2:85\n*S KotlinDebug\n*F\n+ 1 ChatCodeContextProvider.kt\ncom/intellij/ml/llm/core/chat/context/ChatCodeDescription\n*L\n56#1:84\n56#1:85,2\n*E\n"})
public final class ChatCodeDescription {
    @NotNull
    private final PSString displayCode;
    @NotNull
    private final PSString internalCode;
    @Nullable
    private final PSString path;
    @NotNull
    private final List<ChatAttachment> attachments;

    public ChatCodeDescription(@NotNull PSString displayCode, @NotNull PSString internalCode, @NotNull List<? extends ChatAttachment> attachments, @Nullable PSString path) {
        Intrinsics.checkNotNullParameter((Object)displayCode, (String)"displayCode");
        Intrinsics.checkNotNullParameter((Object)internalCode, (String)"internalCode");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        this.displayCode = displayCode;
        this.internalCode = internalCode;
        this.path = path;
        this.attachments = CollectionsKt.toList((Iterable)attachments);
    }

    public /* synthetic */ ChatCodeDescription(PSString pSString, PSString pSString2, List list2, PSString pSString3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            pSString3 = null;
        }
        this(pSString, pSString2, list2, pSString3);
    }

    @NotNull
    public final PSString getDisplayCode() {
        return this.displayCode;
    }

    @NotNull
    public final PSString getInternalCode() {
        return this.internalCode;
    }

    @Nullable
    public final PSString getPath() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChatAttachment> getAttachments(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filter$iv = this.attachments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatAttachment it = (ChatAttachment)element$iv$iv;
            boolean bl = false;
            VirtualFilePointer virtualFilePointer = it.getVirtualFilePointer();
            Object file = virtualFilePointer != null ? virtualFilePointer.getFile() : null;
            if (!(file == null || !PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (VirtualFile)file))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatCodeDescription)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.displayCode, (Object)((ChatCodeDescription)other).displayCode) && Intrinsics.areEqual((Object)this.internalCode, (Object)((ChatCodeDescription)other).internalCode) && Intrinsics.areEqual(this.attachments, ((ChatCodeDescription)other).attachments) && Intrinsics.areEqual((Object)this.path, (Object)((ChatCodeDescription)other).path);
    }

    public int hashCode() {
        int result2 = this.displayCode.hashCode();
        result2 = 31 * result2 + this.internalCode.hashCode();
        result2 = 31 * result2 + ((Object)this.attachments).hashCode();
        PSString pSString = this.path;
        result2 = 31 * result2 + (pSString != null ? pSString.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        return "ChatCodeDescription(displayCode=" + this.displayCode + ", internalCode=" + this.internalCode + ", attachments=" + this.attachments.size() + ", path=" + this.path + ")";
    }
}

