/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui;

import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.FocusedChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.ChatModeSwitcherKt;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.CurrentChatSessionMode;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/ChatModeSwitcher;", "", "<init>", "()V", "switchToAgentById", "", "project", "Lcom/intellij/openapi/project/Project;", "agentId", "", "switchToModeById", "modeId", "switchAwayFromAgent", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nChatModeSwitcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatModeSwitcher.kt\ncom/intellij/ml/llm/core/chat/ui/ChatModeSwitcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n295#2,2:74\n*S KotlinDebug\n*F\n+ 1 ChatModeSwitcher.kt\ncom/intellij/ml/llm/core/chat/ui/ChatModeSwitcher\n*L\n64#1:74,2\n*E\n"})
public final class ChatModeSwitcher {
    @NotNull
    public static final ChatModeSwitcher INSTANCE = new ChatModeSwitcher();

    private ChatModeSwitcher() {
    }

    public final void switchToAgentById(@NotNull Project project, @NotNull String agentId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        this.switchToModeById(project, "agent_" + agentId);
    }

    public final void switchToModeById(@NotNull Project project, @NotNull String modeId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modeId, (String)"modeId");
        ChatSession session = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (session == null) {
            ChatModeSwitcherKt.access$getLogger$p().warn("Cannot switch to mode " + modeId + ": no focused chat session");
            return;
        }
        session.getChatMode().trySetChatModeById(modeId);
        ChatModeSwitcherKt.access$getLogger$p().info("Switched to mode: " + modeId);
    }

    public final void switchAwayFromAgent(@NotNull Project project, @NotNull String agentId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        ChatSession session = FocusedChatSessionHost.Companion.getInstance(project).getFocusedChatSession();
        if (session == null) {
            ChatModeSwitcherKt.access$getLogger$p().warn("Cannot switch away from agent " + agentId + ": no focused chat session");
            return;
        }
        NewChatMode currentMode = (NewChatMode)session.getChatMode().getCurrentChatMode().getValue();
        String currentModeId = currentMode.getId();
        if (Intrinsics.areEqual((Object)currentModeId, (Object)("agent_" + agentId))) {
            NewChatMode targetMode;
            NewChatMode firstAgent;
            NewChatMode newChatMode;
            Object v0;
            List<NewChatMode> availableOptions;
            block5: {
                availableOptions = session.getChatMode().getAvailableOptions();
                Iterable $this$firstOrNull$iv = availableOptions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NewChatMode it = (NewChatMode)element$iv;
                    boolean bl = false;
                    if (!(it.getShouldAppearAsAgent() && !Intrinsics.areEqual((Object)it.getId(), (Object)("agent_" + agentId)))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            if ((newChatMode = (firstAgent = (NewChatMode)v0)) == null) {
                newChatMode = (NewChatMode)CollectionsKt.firstOrNull(availableOptions);
            }
            if ((targetMode = newChatMode) != null) {
                CurrentChatSessionMode.setChatMode$default(session.getChatMode(), targetMode, false, 2, null);
                ChatModeSwitcherKt.access$getLogger$p().info("Switched away from removed agent " + agentId + " to " + targetMode.getId());
            }
        }
    }
}

