/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.ml.llm.core.chat.messages.ChatMessageAuthor;
import com.intellij.ml.llm.core.chat.messages.MarkdownChatMessage;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatMessageView;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantPopupChatMessageKt;
import com.intellij.ml.llm.core.chat.ui.chat.AIChatPanel;
import com.intellij.ml.llm.core.chat.ui.chat.AIChatPanelKt;
import com.intellij.ml.llm.core.chat.ui.chat.selection.AIMessageSelectUtilsKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageImpl;", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageView;", "project", "Lcom/intellij/openapi/project/Project;", "author", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;", "session", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "chatMessage", "Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;", "parentPanel", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIChatPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/core/chat/messages/ChatMessageAuthor;Lcom/intellij/ml/llm/core/chat/session/ChatSession;Lcom/intellij/ml/llm/core/chat/messages/MarkdownChatMessage;Lcom/intellij/ml/llm/core/chat/ui/chat/AIChatPanel;)V", "getBottomPadding", "", "createTitleLabel", "Ljavax/swing/JLabel;", "createToolbar", "Ljavax/swing/JComponent;", "recoverError", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantPopupChatMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantPopupChatMessage.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n23#2:63\n*S KotlinDebug\n*F\n+ 1 AIAssistantPopupChatMessage.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatMessageImpl\n*L\n40#1:63\n*E\n"})
public class AIAssistantChatMessageImpl
extends AIAssistantChatMessageView {
    @NotNull
    private final AIChatPanel parentPanel;

    public AIAssistantChatMessageImpl(@NotNull Project project, @NotNull ChatMessageAuthor author, @NotNull ChatSession session, @NotNull MarkdownChatMessage chatMessage, @NotNull AIChatPanel parentPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)author), (String)"author");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)parentPanel, (String)"parentPanel");
        super(project, author, session, chatMessage, parentPanel);
        this.parentPanel = parentPanel;
    }

    @Override
    public int getBottomPadding() {
        return 5;
    }

    @Override
    @Nullable
    public JLabel createTitleLabel() {
        JLabel jLabel;
        if (this.getAuthor() == ChatMessageAuthor.User) {
            return null;
        }
        JLabel $this$createTitleLabel_u24lambda_u240 = jLabel = new JLabel(AIAssistantPopupChatMessageKt.getMessageTitle(this.getAuthor()));
        boolean bl = false;
        $this$createTitleLabel_u24lambda_u240.setFont((Font)JBFont.h4());
        $this$createTitleLabel_u24lambda_u240.setForeground(AIAssistantColors.INSTANCE.getMessageForeground());
        return jLabel;
    }

    @Override
    @Nullable
    public JComponent createToolbar() {
        String groupName = AIMessageSelectUtilsKt.messageToolbarGroupId(this.getAuthor());
        ActionGroup group = ActionUtil.getActionGroup((String)groupName);
        AIAssistantChatMessageImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AIAssistantChatMessageImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(group != null, (Object)("Cannot find action group for " + groupName));
        if (group != null) {
            ActionToolbarImpl actionToolbarImpl;
            String string = this.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ActionToolbarImpl $this$createToolbar_u24lambda_u240 = actionToolbarImpl = new ActionToolbarImpl(string, group, true, false, false, 24, null);
            boolean bl = false;
            ToolbarLayoutStrategy toolbarLayoutStrategy = ToolbarLayoutStrategy.NOWRAP_STRATEGY;
            Intrinsics.checkNotNullExpressionValue((Object)toolbarLayoutStrategy, (String)"NOWRAP_STRATEGY");
            $this$createToolbar_u24lambda_u240.setLayoutStrategy(toolbarLayoutStrategy);
            $this$createToolbar_u24lambda_u240.getComponent().setOpaque(false);
            $this$createToolbar_u24lambda_u240.getComponent().setBorder((Border)JBUI.Borders.empty());
            $this$createToolbar_u24lambda_u240.setTargetComponent((JComponent)this);
            ActionToolbarImpl toolbar = actionToolbarImpl;
            return toolbar.getComponent();
        }
        return null;
    }

    @Override
    public void recoverError() {
        AIChatPanelKt.recoverFromError(this.parentPanel, this.getMessage());
    }
}

