/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantChatMessageViewModel;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantMessagesViewImpl;
import com.intellij.ml.llm.core.chat.ui.chat.ChatMessageView;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartView;
import com.intellij.ml.llm.core.chat.ui.chat.SearchableView;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u00011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0002J\b\u0010&\u001a\u00020\u0016H\u0002J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0002J\b\u0010*\u001a\u00020\u0016H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0010H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchHandler;", "", "messagesView", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantMessagesViewImpl;", "findModel", "Lcom/intellij/find/FindModel;", "project", "Lcom/intellij/openapi/project/Project;", "scrollBar", "Ljavax/swing/JScrollBar;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantMessagesViewImpl;Lcom/intellij/find/FindModel;Lcom/intellij/openapi/project/Project;Ljavax/swing/JScrollBar;)V", "currentOccurrenceIndex", "", "occurrenceList", "", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchHandler$AIAssistantChatSearchResult;", "exceptionalCharacters", "", "", "scrollingIndentTop", "update", "", "getCurrentIndex", "getOccurrenceCount", "goToNextOccurrence", "goToPreviousOccurrence", "getCurrentOccurrence", "getByIndex", "idx", "getAllOccurrences", "findOccurrencesInString", "Lcom/intellij/find/FindResult;", "str", "", "normalizedOffsetToRawOffset", "rawText", "normalizedOffset", "applyHighlighting", "repaintOccurrences", "oldCurrent", "newCurrent", "removeHighlights", "scrollToOccurrence", "occurrence", "isPointVisible", "", "y", "getOccurrenceYPosition", "AIAssistantChatSearchResult", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantChatSearchHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantChatSearchHandler.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1869#2:172\n1869#2:173\n1563#2:174\n1634#2,3:175\n1870#2:178\n1870#2:179\n1869#2,2:180\n1869#2:182\n1869#2,2:183\n1870#2:185\n*S KotlinDebug\n*F\n+ 1 AIAssistantChatSearchHandler.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchHandler\n*L\n72#1:172\n73#1:173\n75#1:174\n75#1:175,3\n73#1:178\n72#1:179\n121#1:180,2\n134#1:182\n135#1:183,2\n134#1:185\n*E\n"})
public final class AIAssistantChatSearchHandler {
    @NotNull
    private final AIAssistantMessagesViewImpl messagesView;
    @NotNull
    private final FindModel findModel;
    @NotNull
    private final Project project;
    @NotNull
    private final JScrollBar scrollBar;
    private int currentOccurrenceIndex;
    @NotNull
    private List<AIAssistantChatSearchResult> occurrenceList;
    @NotNull
    private final Set<Character> exceptionalCharacters;
    private final int scrollingIndentTop;

    public AIAssistantChatSearchHandler(@NotNull AIAssistantMessagesViewImpl messagesView, @NotNull FindModel findModel, @NotNull Project project, @NotNull JScrollBar scrollBar) {
        Intrinsics.checkNotNullParameter((Object)messagesView, (String)"messagesView");
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scrollBar, (String)"scrollBar");
        this.messagesView = messagesView;
        this.findModel = findModel;
        this.project = project;
        this.scrollBar = scrollBar;
        this.occurrenceList = CollectionsKt.emptyList();
        this.exceptionalCharacters = SetsKt.setOf((Object)Character.valueOf('\u200b'));
        this.scrollingIndentTop = 20;
    }

    public final void update() {
        this.currentOccurrenceIndex = 0;
        this.occurrenceList = this.getAllOccurrences();
        this.removeHighlights();
        this.applyHighlighting();
        if (!((Collection)this.occurrenceList).isEmpty()) {
            this.scrollToOccurrence(this.getCurrentOccurrence());
        }
    }

    public final int getCurrentIndex() {
        return this.currentOccurrenceIndex + 1;
    }

    public final int getOccurrenceCount() {
        return this.occurrenceList.size();
    }

    public final void goToNextOccurrence() {
        AIAssistantChatSearchResult old = this.getCurrentOccurrence();
        if (this.currentOccurrenceIndex >= this.getOccurrenceCount() - 1) {
            this.currentOccurrenceIndex = 0;
        } else {
            int n = this.currentOccurrenceIndex;
            this.currentOccurrenceIndex = n + 1;
        }
        AIAssistantChatSearchResult aIAssistantChatSearchResult = this.getCurrentOccurrence();
        this.repaintOccurrences(old, aIAssistantChatSearchResult);
        this.scrollToOccurrence(aIAssistantChatSearchResult);
    }

    public final void goToPreviousOccurrence() {
        AIAssistantChatSearchResult old = this.getCurrentOccurrence();
        if (this.currentOccurrenceIndex <= 0) {
            this.currentOccurrenceIndex = this.getOccurrenceCount() - 1;
        } else {
            int n = this.currentOccurrenceIndex;
            this.currentOccurrenceIndex = n + -1;
        }
        AIAssistantChatSearchResult aIAssistantChatSearchResult = this.getCurrentOccurrence();
        this.repaintOccurrences(old, aIAssistantChatSearchResult);
        this.scrollToOccurrence(aIAssistantChatSearchResult);
    }

    private final AIAssistantChatSearchResult getCurrentOccurrence() {
        return this.getByIndex(this.currentOccurrenceIndex);
    }

    private final AIAssistantChatSearchResult getByIndex(int idx) {
        if (idx < 0 || idx >= this.getOccurrenceCount()) {
            throw new IndexOutOfBoundsException("There's no search result with index " + idx);
        }
        return this.occurrenceList.get(idx);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AIAssistantChatSearchResult> getAllOccurrences() {
        List occurrences = new ArrayList();
        Iterable $this$forEach$iv = this.messagesView.getMessages$intellij_ml_llm_chat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AIAssistantChatMessageViewModel it = (AIAssistantChatMessageViewModel)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getAllParts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                MessagePartView part = (MessagePartView)element$iv2;
                boolean bl2 = false;
                if (!(part instanceof SearchableView)) continue;
                Iterable iterable = this.findOccurrencesInString(((SearchableView)part).getTextContent());
                List list2 = occurrences;
                boolean $i$f$map = false;
                void var17_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FindResult findResult = (FindResult)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new AIAssistantChatSearchResult(part, (FindResult)it2));
                }
                list2.addAll((List)destination$iv$iv);
            }
        }
        return occurrences;
    }

    private final List<FindResult> findOccurrencesInString(String str) {
        StringBuilder stringBuilder;
        List results = new ArrayList();
        FindManager findManager = FindManager.getInstance((Project)this.project);
        StringBuilder $this$findOccurrencesInString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (this.exceptionalCharacters.contains(Character.valueOf(ch))) continue;
            $this$findOccurrencesInString_u24lambda_u240.append(ch);
        }
        String normalizedText = stringBuilder.toString();
        int currentOffset = 0;
        while (currentOffset < normalizedText.length()) {
            FindResult findRes;
            Intrinsics.checkNotNullExpressionValue((Object)findManager.findString((CharSequence)normalizedText, currentOffset, this.findModel), (String)"findString(...)");
            if (!findRes.isStringFound()) break;
            int start2 = this.normalizedOffsetToRawOffset(str, findRes.getStartOffset());
            int end = this.normalizedOffsetToRawOffset(str, findRes.getEndOffset());
            results.add(new FindResultImpl(start2, end));
            currentOffset = findRes.getEndOffset();
        }
        return results;
    }

    private final int normalizedOffsetToRawOffset(String rawText, int normalizedOffset) {
        int rawOffset;
        int cleanOffset = 0;
        for (rawOffset = 0; rawOffset < rawText.length() && cleanOffset < normalizedOffset; ++rawOffset) {
            if (this.exceptionalCharacters.contains(Character.valueOf(rawText.charAt(rawOffset)))) continue;
            ++cleanOffset;
        }
        return rawOffset;
    }

    private final void applyHighlighting() {
        Iterable $this$forEach$iv = this.occurrenceList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AIAssistantChatSearchResult occurrence = (AIAssistantChatSearchResult)element$iv;
            boolean bl = false;
            if (!(occurrence.getMessagePart() instanceof SearchableView)) continue;
            ((SearchableView)occurrence.getMessagePart()).applyHighlighting(occurrence.getResult(), Intrinsics.areEqual((Object)occurrence, (Object)this.getCurrentOccurrence()));
        }
    }

    private final void repaintOccurrences(AIAssistantChatSearchResult oldCurrent, AIAssistantChatSearchResult newCurrent) {
        if (!(oldCurrent.getMessagePart() instanceof SearchableView) || !(newCurrent.getMessagePart() instanceof SearchableView)) {
            return;
        }
        ((SearchableView)oldCurrent.getMessagePart()).repaintHighlighting(oldCurrent.getResult(), false);
        ((SearchableView)newCurrent.getMessagePart()).repaintHighlighting(newCurrent.getResult(), true);
    }

    private final void removeHighlights() {
        Iterable $this$forEach$iv = this.messagesView.getMessages$intellij_ml_llm_chat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AIAssistantChatMessageViewModel messageView = (AIAssistantChatMessageViewModel)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = messageView.getAllParts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MessagePartView it = (MessagePartView)element$iv2;
                boolean bl2 = false;
                if (!(it instanceof SearchableView)) continue;
                ((SearchableView)it).removeHighlightings();
            }
        }
    }

    private final void scrollToOccurrence(AIAssistantChatSearchResult occurrence) {
        int pos = this.getOccurrenceYPosition(occurrence);
        if (!this.isPointVisible(pos)) {
            SwingUtilities.invokeLater(() -> AIAssistantChatSearchHandler.scrollToOccurrence$lambda$0(this, pos));
        }
    }

    private final boolean isPointVisible(int y) {
        return this.scrollBar.getValue() <= y && y <= this.scrollBar.getHeight() + this.scrollBar.getValue();
    }

    private final int getOccurrenceYPosition(AIAssistantChatSearchResult occurrence) {
        Component component = occurrence.getMessagePart().getComponent();
        int cumulativeY = component.getY();
        if (occurrence.getMessagePart() instanceof SearchableView) {
            cumulativeY += ((SearchableView)occurrence.getMessagePart()).getYOffset(occurrence.getResult());
        }
        while (!Intrinsics.areEqual((Object)component.getParent(), (Object)this.messagesView.getParentComponent$intellij_ml_llm_chat()) && component.getParent() != null) {
            Container container = component.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
            component = container;
            cumulativeY += ((Container)component).getY();
            if (!(component instanceof ChatMessageView)) continue;
            return cumulativeY;
        }
        return cumulativeY;
    }

    private static final void scrollToOccurrence$lambda$0(AIAssistantChatSearchHandler this$0, int $pos) {
        this$0.scrollBar.setValue(Math.max($pos - this$0.scrollingIndentTop, 0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AIAssistantChatSearchHandler$AIAssistantChatSearchResult;", "", "messagePart", "Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "result", "Lcom/intellij/find/FindResult;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;Lcom/intellij/find/FindResult;)V", "getMessagePart", "()Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "getResult", "()Lcom/intellij/find/FindResult;", "intellij.ml.llm.chat"})
    private static final class AIAssistantChatSearchResult {
        @NotNull
        private final MessagePartView messagePart;
        @NotNull
        private final FindResult result;

        public AIAssistantChatSearchResult(@NotNull MessagePartView messagePart, @NotNull FindResult result2) {
            Intrinsics.checkNotNullParameter((Object)messagePart, (String)"messagePart");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            this.messagePart = messagePart;
            this.result = result2;
        }

        @NotNull
        public final MessagePartView getMessagePart() {
            return this.messagePart;
        }

        @NotNull
        public final FindResult getResult() {
            return this.result;
        }
    }
}

