/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.ml.llm.core.chat.ui.chat.AIChatScrollProcessor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000*\u0001\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0017\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AIChatScrollProcessor;", "", "chatScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "chatPanel", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/ui/components/JBScrollPane;Ljavax/swing/JPanel;)V", "lastChatPanelScrollTimestamp", "", "nestedEditorMouseListener", "com/intellij/ml/llm/core/chat/ui/chat/AIChatScrollProcessor$nestedEditorMouseListener$1", "Lcom/intellij/ml/llm/core/chat/ui/chat/AIChatScrollProcessor$nestedEditorMouseListener$1;", "refreshScrollListeners", "", "cleanupListeners", "component", "Ljava/awt/Component;", "cleanupListeners$intellij_ml_llm_chat", "refreshMouseWheelListeners", "pane", "shouldAdd", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIChatScrollProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIChatScrollProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIChatScrollProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,76:1\n13805#2,2:77\n13805#2,2:79\n*S KotlinDebug\n*F\n+ 1 AIChatScrollProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AIChatScrollProcessor\n*L\n50#1:77,2\n59#1:79,2\n*E\n"})
public final class AIChatScrollProcessor {
    @NotNull
    private final JPanel chatPanel;
    private long lastChatPanelScrollTimestamp;
    @NotNull
    private final nestedEditorMouseListener.1 nestedEditorMouseListener;

    public AIChatScrollProcessor(@NotNull JBScrollPane chatScrollPane, @NotNull JPanel chatPanel2) {
        Intrinsics.checkNotNullParameter((Object)chatScrollPane, (String)"chatScrollPane");
        Intrinsics.checkNotNullParameter((Object)chatPanel2, (String)"chatPanel");
        this.chatPanel = chatPanel2;
        this.nestedEditorMouseListener = new MouseWheelListener(this){
            final /* synthetic */ AIChatScrollProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseWheelMoved(MouseWheelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int scrollOwnerTimeout = Registry.Companion.intValue("llm.chat.scroll.mousewheel.timeout");
                if (e.getWhen() - AIChatScrollProcessor.access$getLastChatPanelScrollTimestamp$p(this.this$0) < (long)scrollOwnerTimeout && !e.getComponent().hasFocus()) {
                    this.redirectToChatPanel(e);
                }
                if (!e.isConsumed()) {
                    e.getComponent().removeMouseWheelListener(this);
                    e.getComponent().dispatchEvent(e);
                    e.getComponent().addMouseWheelListener(this);
                }
            }

            public final void redirectToChatPanel(MouseWheelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MouseEvent newEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, AIChatScrollProcessor.access$getChatPanel$p(this.this$0));
                AIChatScrollProcessor.access$getChatPanel$p(this.this$0).dispatchEvent(newEvent);
                if (newEvent.isConsumed()) {
                    e.consume();
                }
            }
        };
        this.refreshScrollListeners();
        chatScrollPane.getVerticalScrollBar().addAdjustmentListener(arg_0 -> AIChatScrollProcessor._init_$lambda$0(this, arg_0));
    }

    @ApiStatus.Internal
    public final void refreshScrollListeners() {
        Component[] componentArray = this.chatPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.refreshMouseWheelListeners(it, true);
        }
    }

    public final void cleanupListeners$intellij_ml_llm_chat(@Nullable Component component) {
        if (!(component instanceof Container)) {
            return;
        }
        Component[] componentArray = ((Container)component).getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.refreshMouseWheelListeners(it, false);
        }
    }

    private final void refreshMouseWheelListeners(Component pane, boolean shouldAdd) {
        UIUtil.forEachComponentInHierarchy((Component)pane, arg_0 -> AIChatScrollProcessor.refreshMouseWheelListeners$lambda$1(arg_0 -> AIChatScrollProcessor.refreshMouseWheelListeners$lambda$0(this, shouldAdd, arg_0), arg_0));
    }

    private static final void _init_$lambda$0(AIChatScrollProcessor this$0, AdjustmentEvent it) {
        this$0.lastChatPanelScrollTimestamp = System.currentTimeMillis();
    }

    private static final Unit refreshMouseWheelListeners$lambda$0(AIChatScrollProcessor this$0, boolean $shouldAdd, Component it) {
        if (it instanceof EditorComponentImpl) {
            ((EditorComponentImpl)it).removeMouseWheelListener((MouseWheelListener)this$0.nestedEditorMouseListener);
            if ($shouldAdd) {
                ((EditorComponentImpl)it).addMouseWheelListener((MouseWheelListener)this$0.nestedEditorMouseListener);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void refreshMouseWheelListeners$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ long access$getLastChatPanelScrollTimestamp$p(AIChatScrollProcessor $this) {
        return $this.lastChatPanelScrollTimestamp;
    }

    public static final /* synthetic */ JPanel access$getChatPanel$p(AIChatScrollProcessor $this) {
        return $this.chatPanel;
    }
}

