/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.ml.llm.core.chat.ui.chat.HtmlMdTransferable;
import com.intellij.ml.llm.core.chat.ui.chat.HtmlToMarkdownConverterKt;
import com.intellij.ml.llm.core.chat.ui.chat.SecureHtmlSanitizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J$\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/AiPartViewTransferHandler;", "Ljavax/swing/TransferHandler;", "<init>", "()V", "createTransferable", "Ljava/awt/datatransfer/Transferable;", "c", "Ljavax/swing/JComponent;", "exportToClipboard", "", "component", "clipboard", "Ljava/awt/datatransfer/Clipboard;", "action", "", "getSourceActions", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nTextPartViewEditorPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPartViewEditorPane.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AiPartViewTransferHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,317:1\n23#2:318\n23#2:319\n*S KotlinDebug\n*F\n+ 1 TextPartViewEditorPane.kt\ncom/intellij/ml/llm/core/chat/ui/chat/AiPartViewTransferHandler\n*L\n212#1:318\n214#1:319\n*E\n"})
final class AiPartViewTransferHandler
extends TransferHandler {
    @Override
    @NotNull
    protected Transferable createTransferable(@Nullable JComponent c) {
        boolean $i$f$thisLogger;
        AiPartViewTransferHandler $this$thisLogger$iv;
        Intrinsics.checkNotNull((Object)c, (String)"null cannot be cast to non-null type javax.swing.JEditorPane");
        JEditorPane editorPane = (JEditorPane)c;
        int selectionStart = editorPane.getSelectionStart();
        int selectionEnd = editorPane.getSelectionEnd();
        Document doc = editorPane.getDocument();
        EditorKit editorKit = editorPane.getEditorKit();
        Intrinsics.checkNotNullExpressionValue((Object)editorKit, (String)"getEditorKit(...)");
        EditorKit kit = editorKit;
        StringWriter writer = new StringWriter();
        try {
            kit.write(writer, doc, selectionStart, selectionEnd - selectionStart);
        }
        catch (BadLocationException e) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AiPartViewTransferHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        catch (IOException e) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AiPartViewTransferHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String htmlText = SecureHtmlSanitizer.INSTANCE.sanitizeInternalResources(string);
        boolean isWholePartSelected = selectionStart == 1 && selectionEnd == editorPane.getDocument().getLength();
        String plainText = isWholePartSelected || Registry.Companion.is("llm.chat.always.copy.with.markdown.formatting") ? HtmlToMarkdownConverterKt.convertHtmlToMarkdown(htmlText) : editorPane.getSelectedText();
        Intrinsics.checkNotNull((Object)plainText);
        return new HtmlMdTransferable(plainText, htmlText);
    }

    @Override
    public void exportToClipboard(@Nullable JComponent component, @Nullable Clipboard clipboard, int action2) {
        if (action2 == 1 && component != null && clipboard != null) {
            clipboard.setContents(this.createTransferable(component), null);
        }
    }

    @Override
    public int getSourceActions(@Nullable JComponent c) {
        return 1;
    }
}

