/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat;

import com.intellij.find.FindResult;
import com.intellij.markdown.utils.MarkdownToHtmlConverterKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantExternalLinksKt;
import com.intellij.ml.llm.core.chat.ui.chat.HyperlinkListenerExt;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartView;
import com.intellij.ml.llm.core.chat.ui.chat.MessagePartViewExtension;
import com.intellij.ml.llm.core.chat.ui.chat.SearchableView;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartViewEditorPane;
import com.intellij.ml.llm.core.chat.ui.chat.TextPartViewUpdater;
import com.intellij.ml.llm.core.chat.ui.chat.parts.MessagePartViewContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J\b\u0010,\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020\u0010H\u0002J\b\u0010/\u001a\u00020 H\u0016J\u0018\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020$2\u0006\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0016J\b\u00105\u001a\u00020$H\u0016J \u00106\u001a\u00020$2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020\u0016H\u0002J\u0010\u0010;\u001a\u0002082\u0006\u00101\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartView;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/ml/llm/core/chat/ui/chat/SearchableView;", "Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "part", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "previous", "context", "Lcom/intellij/ml/llm/core/chat/ui/chat/parts/MessagePartViewContext;", "<init>", "(Lcom/intellij/ml/llm/core/chat/parts/MessagePart;Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;Lcom/intellij/ml/llm/core/chat/ui/chat/parts/MessagePartViewContext;)V", "getPart", "()Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "getPrevious", "()Lcom/intellij/ml/llm/core/chat/ui/chat/MessagePartView;", "editorPane", "Ljavax/swing/JEditorPane;", "highlightTags", "", "Lcom/intellij/find/FindResult;", "", "highlightColor", "Ljava/awt/Color;", "currentHighlightColor", "searchOccurrencePainter", "Ljavax/swing/text/DefaultHighlighter$DefaultHighlightPainter;", "currentSearchOccurrencePainter", "component", "Ljava/awt/Component;", "getComponent", "()Ljava/awt/Component;", "accessibleName", "", "getAccessibleName", "()Ljava/lang/String;", "writeContent", "", "md", "Ljava/io/StringWriter;", "html", "updater", "Lcom/intellij/ml/llm/core/chat/ui/chat/TextPartViewUpdater;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initialize", "dispose", "createComponent", "getTextContent", "applyHighlighting", "result", "isCurrentlySelected", "", "repaintHighlighting", "removeHighlightings", "repaintForeground", "start", "", "end", "foreground", "getYOffset", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nTextPartView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextPartView.kt\ncom/intellij/ml/llm/core/chat/ui/chat/TextPartView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,224:1\n1617#2,9:225\n1869#2:234\n1870#2:236\n1626#2:237\n1#3:235\n37#4,2:238\n*S KotlinDebug\n*F\n+ 1 TextPartView.kt\ncom/intellij/ml/llm/core/chat/ui/chat/TextPartView\n*L\n91#1:225,9\n91#1:234\n91#1:236\n91#1:237\n91#1:235\n92#1:238,2\n*E\n"})
public final class TextPartView
extends UserDataHolderBase
implements SearchableView,
MessagePartView {
    @NotNull
    private final MessagePart part;
    @Nullable
    private final MessagePartView previous;
    @NotNull
    private final MessagePartViewContext context;
    @NotNull
    private final JEditorPane editorPane;
    @NotNull
    private final Map<FindResult, Object> highlightTags;
    @NotNull
    private final Color highlightColor;
    @NotNull
    private final Color currentHighlightColor;
    @NotNull
    private final DefaultHighlighter.DefaultHighlightPainter searchOccurrencePainter;
    @NotNull
    private final DefaultHighlighter.DefaultHighlightPainter currentSearchOccurrencePainter;
    @NotNull
    private final Component component;
    @NotNull
    private final TextPartViewUpdater updater;
    @NotNull
    private final AtomicBoolean initialized;

    public TextPartView(@NotNull MessagePart part, @Nullable MessagePartView previous, @NotNull MessagePartViewContext context) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.part = part;
        this.previous = previous;
        this.context = context;
        this.editorPane = this.createComponent();
        this.highlightTags = new LinkedHashMap();
        this.highlightColor = (Color)new JBColor(new Color(254, 230, 177), new Color(186, 151, 82));
        this.currentHighlightColor = (Color)new JBColor(new Color(236, 143, 76), new Color(236, 143, 76));
        this.searchOccurrencePainter = new DefaultHighlighter.DefaultHighlightPainter(this.highlightColor);
        this.currentSearchOccurrencePainter = new DefaultHighlighter.DefaultHighlightPainter(this.currentHighlightColor);
        this.component = this.editorPane;
        this.updater = new TextPartViewUpdater(this, this.editorPane, this.context.getProject());
        this.initialized = new AtomicBoolean(false);
    }

    @Override
    @NotNull
    public MessagePart getPart() {
        return this.part;
    }

    @Override
    @Nullable
    public MessagePartView getPrevious() {
        return this.previous;
    }

    @Override
    @NotNull
    public Component getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public String getAccessibleName() {
        return LLMBundle.message((String)"chat.message.text.part.accessible.name", (Object[])new Object[0]);
    }

    @Override
    public void writeContent(@NotNull StringWriter md, @NotNull StringWriter html) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        md.append(this.getPart().getTextContent());
        html.append(MarkdownToHtmlConverterKt.convertMarkdownToHtml((String)this.getPart().getTextContent()));
    }

    @Override
    public void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            this.getPart().addTextListener(this.updater);
            this.updater.onTextChanged(this.getPart().getTextContent());
        }
    }

    @Override
    public void dispose() {
        this.getPart().removeTextListener(this.updater);
        this.updater.stop();
    }

    /*
     * WARNING - void declaration
     */
    private final JEditorPane createComponent() {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        TextPartViewEditorPane textPartViewEditorPane;
        TextPartViewEditorPane $this$createComponent_u24lambda_u240 = textPartViewEditorPane = new TextPartViewEditorPane(this, this.context.getProject());
        boolean $i$a$-apply-TextPartView$createComponent$component$22 = false;
        $this$createComponent_u24lambda_u240.setForeground(AIAssistantColors.INSTANCE.getMessageForeground());
        TextPartViewEditorPane component = textPartViewEditorPane;
        MessagePartViewExtension.Context extCtx = new MessagePartViewExtension.Context(this, this.context.getProject());
        Iterable $i$a$-apply-TextPartView$createComponent$component$22 = MessagePartViewExtension.Companion.getEP().getExtensionList();
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HyperlinkListenerExt it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MessagePartViewExtension it = (MessagePartViewExtension)element$iv$iv;
            boolean bl2 = false;
            if (it.getHyperlinkListener(extCtx) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        HyperlinkListenerExt[] extHyperlinkHandlers = thisCollection$iv.toArray(new HyperlinkListenerExt[0]);
        component.addHyperlinkListener(arg_0 -> TextPartView.createComponent$lambda$2(extHyperlinkHandlers, this, arg_0));
        return (JEditorPane)((Object)component);
    }

    @Override
    @NotNull
    public String getTextContent() {
        String string = this.editorPane.getDocument().getText(0, this.editorPane.getDocument().getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    public void applyHighlighting(@NotNull FindResult result2, boolean isCurrentlySelected) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        DefaultHighlighter.DefaultHighlightPainter painter = isCurrentlySelected ? this.currentSearchOccurrencePainter : this.searchOccurrencePainter;
        Object tag = this.editorPane.getHighlighter().addHighlight(result2.getStartOffset(), result2.getEndOffset(), painter);
        this.highlightTags.put(result2, tag);
        int n = result2.getStartOffset();
        int n2 = result2.getEndOffset();
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
        this.repaintForeground(n, n2, color);
    }

    @Override
    public void repaintHighlighting(@NotNull FindResult result2, boolean isCurrentlySelected) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (this.highlightTags.get(result2) == null) {
            throw new IllegalStateException("Repaint called on non-existing search result");
        }
        Highlighter highlighter = this.editorPane.getHighlighter();
        Object object = this.highlightTags.get(result2);
        Intrinsics.checkNotNull((Object)object);
        highlighter.removeHighlight(object);
        this.applyHighlighting(result2, isCurrentlySelected);
    }

    @Override
    public void removeHighlightings() {
        this.editorPane.getHighlighter().removeAllHighlights();
        this.highlightTags.clear();
        int n = this.editorPane.getDocument().getLength();
        Color color = this.editorPane.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
        this.repaintForeground(0, n, color);
    }

    private final void repaintForeground(int start2, int end, Color foreground) {
        Document doc = this.editorPane.getDocument();
        if (doc instanceof StyledDocument) {
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setForeground(attrs, foreground);
            ((StyledDocument)doc).setCharacterAttributes(start2, end - start2, attrs, false);
        }
    }

    @Override
    public int getYOffset(@NotNull FindResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return this.editorPane.modelToView((int)result2.getStartOffset()).y;
    }

    private static final void createComponent$lambda$2(HyperlinkListenerExt[] $extHyperlinkHandlers, TextPartView this$0, HyperlinkEvent it) {
        for (HyperlinkListenerExt handler2 : $extHyperlinkHandlers) {
            Intrinsics.checkNotNull((Object)it);
            if (!handler2.hyperlinkUpdate(it)) continue;
            return;
        }
        Project project = this$0.context.getProject();
        Intrinsics.checkNotNull((Object)it);
        AIAssistantExternalLinksKt.handleExternalLinkEvent(project, it);
    }
}

