/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context;

import com.intellij.ml.llm.context.ContextEntity;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.context.ContextPostProcessor;
import com.intellij.ml.llm.context.ContextRetrievalRequest;
import com.intellij.ml.llm.core.chat.ui.chat.context.ManuallyExcludedContextProcessorKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fJ\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u0017J\u0006\u0010\u0018\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J2\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020 0\u001fj\u0002`!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020 0\u001fj\u0002`!H\u0096@\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/ManuallyExcludedContextProcessor;", "Lcom/intellij/ml/llm/context/ContextPostProcessor;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "excludedContextFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "historicalExcludedContextFlow", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "excludeItem", "", "itemId", "historicallyExcludeItem", "", "item", "includeItem", "isItemExcluded", "wasItemEverExcluded", "getExcludedItemsFlow", "Lkotlinx/coroutines/flow/StateFlow;", "clearExcludedItems", "priority", "", "isApplicable", "request", "Lcom/intellij/ml/llm/context/ContextRetrievalRequest;", "process", "", "Lcom/intellij/ml/llm/context/ContextEntity;", "Lcom/intellij/ml/llm/context/ContextEntities;", "items", "(Lcom/intellij/ml/llm/context/ContextRetrievalRequest;Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processContextAttachment", "contextEntity", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nManuallyExcludedContextProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManuallyExcludedContextProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/ManuallyExcludedContextProcessor\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n230#2,5:79\n230#2,5:84\n230#2,5:89\n1563#3:94\n1634#3,3:95\n1617#3,9:98\n1869#3:107\n1870#3:109\n1626#3:110\n1#4:108\n*S KotlinDebug\n*F\n+ 1 ManuallyExcludedContextProcessor.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/ManuallyExcludedContextProcessor\n*L\n28#1:79,5\n36#1:84,5\n41#1:89,5\n50#1:94\n50#1:95,3\n64#1:98,9\n64#1:107\n64#1:109\n64#1:110\n64#1:108\n*E\n"})
public final class ManuallyExcludedContextProcessor
implements ContextPostProcessor {
    @NotNull
    private final String id;
    @NotNull
    private final MutableStateFlow<Set<String>> excludedContextFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
    @NotNull
    private final MutableStateFlow<Set<ContextAttachment>> historicalExcludedContextFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());

    public ManuallyExcludedContextProcessor() {
        this.id = "manuallyExcludedContextProcessor";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public final boolean excludeItem(@NotNull String itemId) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        if (ManuallyExcludedContextProcessorKt.getDO_NOT_EXCLUDE_CONTEXT_IDS().contains(itemId)) {
            return false;
        }
        boolean wasAdded = false;
        MutableStateFlow<Set<String>> $this$update$iv = this.excludedContextFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
            boolean bl2 = wasAdded = !it.contains(itemId);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Object)itemId))));
        return wasAdded;
    }

    public final void historicallyExcludeItem(@NotNull ContextAttachment item) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        MutableStateFlow<Set<ContextAttachment>> $this$update$iv = this.historicalExcludedContextFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Object)item))));
    }

    public final boolean includeItem(@NotNull String itemId) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        boolean wasRemoved = false;
        MutableStateFlow<Set<String>> $this$update$iv = this.excludedContextFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
            wasRemoved = it.contains(itemId);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.minus((Set)it, (Object)itemId))));
        return wasRemoved;
    }

    public final boolean isItemExcluded(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return ((Set)this.excludedContextFlow.getValue()).contains(itemId);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean wasItemEverExcluded(@NotNull ContextAttachment item) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Iterable $this$map$iv = (Iterable)this.historicalExcludedContextFlow.getValue();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContextAttachment contextAttachment = (ContextAttachment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ContextAttachmentKt.virtualFile((ContextAttachment)it));
        }
        return ((List)destination$iv$iv).contains(ContextAttachmentKt.virtualFile(item));
    }

    @NotNull
    public final StateFlow<Set<String>> getExcludedItemsFlow() {
        return FlowKt.asStateFlow(this.excludedContextFlow);
    }

    public final void clearExcludedItems() {
        this.excludedContextFlow.tryEmit((Object)SetsKt.emptySet());
    }

    public int priority() {
        return 80;
    }

    public boolean isApplicable(@NotNull ContextRetrievalRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object process(@NotNull ContextRetrievalRequest request, @NotNull Iterable<? extends ContextEntity> items, @NotNull Continuation<? super Iterable<? extends ContextEntity>> $completion) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<? extends ContextEntity> $this$mapNotNull$iv = items;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends ContextEntity> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ContextEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ContextEntity p0 = (ContextEntity)element$iv$iv;
            boolean bl2 = false;
            if (this.processContextAttachment(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ContextEntity processContextAttachment(ContextEntity contextEntity) {
        if (!(contextEntity instanceof ContextAttachment)) {
            return contextEntity;
        }
        ContextEntitySource contextEntitySource = contextEntity.getAttachedBy();
        Intrinsics.checkNotNull((Object)contextEntitySource, (String)"null cannot be cast to non-null type com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource");
        if (!((ContextAttachmentSource)contextEntitySource).isAutomaticallyCollected()) {
            this.includeItem(contextEntity.getId());
        }
        if (this.isItemExcluded(contextEntity.getId())) {
            return null;
        }
        return contextEntity;
    }
}

