/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.context.TrimmedContextAttachment;
import com.intellij.ml.llm.core.chat.ui.AIAssistantColors;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatMessageAttachmentViewKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.ContextAttachmentView;
import com.intellij.ml.llm.core.chat.ui.chat.context.ContextItemBorder;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0016H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/MessageAttachmentView;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "attachment", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "bgColor", "Ljava/awt/Color;", "disposable", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;Ljava/awt/Color;Lcom/intellij/openapi/Disposable;Lkotlinx/coroutines/CoroutineScope;)V", "isTrimmedAttachment", "", "attachmentBorder", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/ContextItemBorder;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "isDebugAttachmentUiEnabled", "functionCallAttachmentBgColor", "Lcom/intellij/ui/JBColor;", "autoLoadedAttachmentBgColor", "applyBackground", "getPreferredSize", "Ljava/awt/Dimension;", "getAttachmentName", "", "intellij.ml.llm.chat"})
public final class MessageAttachmentView
extends BorderLayoutPanel {
    @NotNull
    private final ContextAttachment attachment;
    private final boolean isTrimmedAttachment;
    @NotNull
    private final ContextItemBorder attachmentBorder;
    @NotNull
    private final JBColor functionCallAttachmentBgColor;
    @NotNull
    private final JBColor autoLoadedAttachmentBgColor;

    /*
     * WARNING - void declaration
     */
    public MessageAttachmentView(@NotNull ContextAttachment attachment, @Nullable Color bgColor, @NotNull Disposable disposable, @NotNull CoroutineScope scope) {
        String hint;
        MessageAttachmentView messageAttachmentView;
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.attachment = attachment;
        this.isTrimmedAttachment = this.attachment instanceof TrimmedContextAttachment;
        this.attachmentBorder = new ContextItemBorder(this.isTrimmedAttachment);
        this.setBorder(this.attachmentBorder);
        this.setOpaque(false);
        MouseAdapter focusListener2 = new MouseAdapter(this){
            final /* synthetic */ MessageAttachmentView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                MessageAttachmentView.access$getAttachmentBorder$p(this.this$0).setFocused(true);
                this.this$0.repaint();
            }

            public void mouseExited(MouseEvent e) {
                MessageAttachmentView.access$getAttachmentBorder$p(this.this$0).setFocused(false);
                this.this$0.repaint();
            }

            public void mouseMoved(MouseEvent e) {
                if (MessageAttachmentView.access$getAttachmentBorder$p(this.this$0).getFocused()) {
                    return;
                }
                MessageAttachmentView.access$getAttachmentBorder$p(this.this$0).setFocused(true);
                this.this$0.repaint();
            }
        };
        this.addMouseListener(focusListener2);
        this.addMouseListener(new ContextAttachmentView.MessageAttachmentEventHandler(this.attachment.getTooltipText(), this.attachment.getTooltipDescriptionText(), scope));
        if (this.attachment.getIcon() != null) {
            void $this$_init__u24lambda_u241;
            Wrapper wrapper;
            JBLabel elementIcon = new JBLabel();
            ObservableProperty<Icon> observableProperty = this.attachment.getIcon();
            if (observableProperty != null) {
                observableProperty.afterChange(disposable, arg_0 -> MessageAttachmentView._init_$lambda$0(scope, elementIcon, arg_0));
            }
            ObservableProperty<Icon> observableProperty2 = this.attachment.getIcon();
            elementIcon.setIcon(observableProperty2 != null ? (Icon)observableProperty2.get() : null);
            elementIcon.setBackground(bgColor);
            Wrapper wrapper2 = wrapper = new Wrapper((JComponent)elementIcon);
            messageAttachmentView = this;
            boolean bl = false;
            $this$_init__u24lambda_u241.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            messageAttachmentView.addToLeft((Component)wrapper);
        }
        JBLabel label = new JBLabel(AIChatMessageAttachmentViewKt.access$shorten((String)this.attachment.getName().get()));
        Wrapper wrapper = new Wrapper((JComponent)label);
        int leftPadding = this.attachment.getIcon() == null ? 10 : 5;
        wrapper.setBackground(bgColor);
        wrapper.setBorder((Border)JBUI.Borders.empty((int)0, (int)leftPadding, (int)0, (int)7));
        ObservableProperty<String> observableProperty = this.attachment.getHint();
        String string = hint = observableProperty != null ? (String)observableProperty.get() : null;
        if (hint != null && ((CharSequence)hint).length() > 0) {
            JBLabel hintLabel = new JBLabel(hint);
            hintLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
            hintLabel.setForeground(AIAssistantColors.INSTANCE.getHintTextForeground());
            wrapper.add((Component)hintLabel, (Object)"After");
        }
        this.addToCenter((Component)wrapper);
        if (this.isTrimmedAttachment) {
            void $this$_init__u24lambda_u242;
            Wrapper wrapper3;
            JBLabel scissorsIconLabel = new JBLabel(MLLlmIcons.Chat.Context.Scissors);
            scissorsIconLabel.addMouseListener((MouseListener)new ContextAttachmentView.ScissorsEventHandler(scope, false, 2, null));
            scissorsIconLabel.setBackground(bgColor);
            Wrapper wrapper4 = wrapper3 = new Wrapper((JComponent)scissorsIconLabel);
            messageAttachmentView = this;
            boolean bl = false;
            $this$_init__u24lambda_u242.setBorder((Border)JBUI.Borders.emptyRight((int)8));
            messageAttachmentView.addToRight((Component)wrapper3);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                attachment.performAction(true);
            }
        });
        Object[] objectArray = new Object[]{this.attachment.getName().get()};
        this.getAccessibleContext().setAccessibleName(LLMBundle.message((String)"chat.message.context.attachment.accessible.name", (Object[])objectArray));
        this.functionCallAttachmentBgColor = new JBColor(new Color(80, 170, 255, 40), new Color(80, 170, 255, 40));
        this.autoLoadedAttachmentBgColor = new JBColor(new Color(255, 170, 80, 50), new Color(255, 170, 80, 50));
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.isDebugAttachmentUiEnabled() && ApplicationManager.getApplication().isInternal()) {
            if (Intrinsics.areEqual((Object)this.attachment.getAttachedBy(), (Object)ContextAttachmentSource.FunctionCall.INSTANCE)) {
                this.applyBackground(g, this.functionCallAttachmentBgColor);
            } else if (AIChatMessageAttachmentViewKt.access$isAutoloaded(this.attachment.getAttachedBy())) {
                this.applyBackground(g, this.autoLoadedAttachmentBgColor);
            }
        }
    }

    private final boolean isDebugAttachmentUiEnabled() {
        return Registry.Companion.is("llm.chat.context.debug.attachments.ui", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyBackground(Graphics g, JBColor bgColor) {
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)r, (Insets)((Insets)JBUI.insets((int)1)));
        try {
            g2.setColor((Color)bgColor);
            g2.fillRoundRect(r.x, r.y, r.width, r.height, r.height, r.height);
        }
        finally {
            g2.dispose();
        }
    }

    @Nullable
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, AIChatMessageAttachmentViewKt.access$getCONTEXT_ITEM_HEIGHT());
    }

    @NotNull
    public final String getAttachmentName() {
        return (String)this.attachment.getName().get();
    }

    private static final Unit _init_$lambda$0(CoroutineScope $scope, JBLabel $elementIcon, Icon it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($elementIcon, it, null){
            int label;
            final /* synthetic */ JBLabel $elementIcon;
            final /* synthetic */ Icon $it;
            {
                this.$elementIcon = $elementIcon;
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$elementIcon, this.$it, null){
                            int label;
                            final /* synthetic */ JBLabel $elementIcon;
                            final /* synthetic */ Icon $it;
                            {
                                this.$elementIcon = $elementIcon;
                                this.$it = $it;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$elementIcon.setIcon(this.$it);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ContextItemBorder access$getAttachmentBorder$p(MessageAttachmentView $this) {
        return $this.attachmentBorder;
    }
}

