/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.context.attachments;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.CustomSystemPromptAttachment;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.core.chat.promptLibrary.settings.AIAssistantPromptLibrarySettingsChangedListener;
import com.intellij.ml.llm.core.chat.promptLibrary.settings.OpenAiAssistantPromptLibrarySettingsKt;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010$\u001a\u00020%H\u0096@\u00a2\u0006\u0002\u0010&J\b\u0010*\u001a\u00020+H\u0002J\b\u00100\u001a\u00020\u0011H\u0002J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020+H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0014\u0010\u001e\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00066"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CustomSystemPromptContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "innerText", "", "Lorg/jetbrains/annotations/Nls;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "getHint", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "id", "getId", "()Ljava/lang/String;", "icon", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Ljavax/swing/Icon;", "getIcon", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "attachedBy", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource$User;", "getAttachedBy", "()Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentSource$User;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "prompt", "updateHint", "", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getInstructionText", "performAction", "isInMessage", "", "dispose", "Companion", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nCustomSystemPromptContextAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomSystemPromptContextAttachment.kt\ncom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CustomSystemPromptContextAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class CustomSystemPromptContextAttachment
extends ContextAttachmentBase
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String innerText;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<String> hint;
    @NotNull
    private final PSString text;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ContextAttachmentSource.User attachedBy;
    @NotNull
    private final MessageBusConnection connection;
    @NotNull
    private PSString prompt;

    public CustomSystemPromptContextAttachment(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.innerText = LLMBundle.message((String)"context.panel.instructions.item.name", (Object[])new Object[0]);
        this.name = new AtomicProperty((Object)this.innerText);
        this.hint = new AtomicProperty((Object)"");
        this.text = ConstantsKt.getEMPTY();
        this.id = "CHAT_INSTRUCTION_PROMPT";
        this.icon = (ObservableProperty)new AtomicProperty((Object)AllIcons.FileTypes.Text);
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        this.tooltipText = LLMBundle.message((String)"context.panel.instructions.tooltip", (Object[])objectArray);
        this.popupPresentationText = this.innerText;
        this.attachedBy = ContextAttachmentSource.User.INSTANCE;
        this.connection = this.project.getMessageBus().connect();
        this.prompt = ConstantsKt.getEMPTY();
        this.updateHint();
        this.connection.subscribe(AIAssistantPromptLibrarySettingsChangedListener.Companion.getTOPIC(), (Object)new AIAssistantPromptLibrarySettingsChangedListener(){

            @Override
            public void settingsChanged() {
                this.updateHint();
            }
        });
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    public AtomicProperty<String> getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public ContextAttachmentSource.User getAttachedBy() {
        return this.attachedBy;
    }

    @Override
    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new CustomSystemPromptAttachment(this.project, this.getAttachedBy(), ChatAttachment.Kind.Visible);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHint() {
        PSString instructionText = this.getInstructionText();
        if (((CharSequence)instructionText).length() == 0) {
            this.getHint().set((Object)LLMBundle.message((String)"context.panel.instructions.item.empty.hint", (Object[])new Object[0]));
        } else {
            String string;
            String it = (String)instructionText.unwrap();
            boolean bl = false;
            if (it.length() > 20) {
                String string2 = it.substring(0, 17);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = string2 + "...";
            } else {
                void var3_2;
                string = var3_2;
            }
            void promptText = string;
            this.getHint().set((Object)promptText);
        }
        this.prompt = instructionText;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return (ContextEntityPrivacy)ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    private final PSString getInstructionText() {
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(this.project).findPrompt("AIAssistant.General.ProjectPrompt");
        if (aISystemLibraryPrompt == null) {
            return ConstantsKt.getEMPTY();
        }
        AISystemLibraryPrompt prompt2 = aISystemLibraryPrompt;
        return prompt2.getContent();
    }

    @Override
    public void performAction(boolean isInMessage) {
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(this.project).findPrompt("AIAssistant.General.ProjectPrompt");
        if (aISystemLibraryPrompt == null) {
            return;
        }
        AISystemLibraryPrompt usersSystemPrompt = aISystemLibraryPrompt;
        OpenAiAssistantPromptLibrarySettingsKt.openAiAssistantPromptLibraryAndPreselectedInstruction(this.project, usersSystemPrompt);
    }

    public void dispose() {
        this.connection.disconnect();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/CustomSystemPromptContextAttachment$Companion;", "", "<init>", "()V", "hasNonEmptyPrompt", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.chat"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasNonEmptyPrompt(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project).findPrompt("AIAssistant.General.ProjectPrompt");
            return aISystemLibraryPrompt != null && (aISystemLibraryPrompt = aISystemLibraryPrompt.getContent()) != null ? ((CharSequence)((Object)aISystemLibraryPrompt)).length() > 0 : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

