/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.input;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ml.llm.core.chat.ui.chat.AIAssistantDimensions;
import com.intellij.ml.llm.core.chat.ui.chat.input.AIAssistantInput;
import com.intellij.ml.llm.core.ui.XNextThemeHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInputBorder;", "Ljavax/swing/border/Border;", "Lcom/intellij/openapi/ui/ErrorBorderCapable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parent", "Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInput;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInput;)V", "getParent", "()Lcom/intellij/ml/llm/core/chat/ui/chat/input/AIAssistantInput;", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "width", "height", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "", "intellij.ml.llm.chat"})
public final class AIAssistantInputBorder
implements Border,
ErrorBorderCapable {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final AIAssistantInput parent;

    public AIAssistantInputBorder(@NotNull EditorEx editor, @NotNull AIAssistantInput parent) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.editor = editor;
        this.parent = parent;
        this.editor.addFocusListener(new FocusChangeListener(){

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getParent().repaint();
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getParent().repaint();
            }
        });
    }

    @NotNull
    public final AIAssistantInput getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        boolean hasFocus = this.editor.getContentComponent().hasFocus();
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            boolean shouldDrawFancyBorder = this.parent.shouldDrawFancyBorder();
            int arcDiameter = AIAssistantDimensions.INSTANCE.inputBorderRadius() * 2;
            int borderWidth = hasFocus ? JBUIScale.scale((int)2) : JBUIScale.scale((int)1);
            Color color = JBUI.CurrentTheme.Focus.focusColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"focusColor(...)");
            Color focusedColor = color;
            Color nonFocusedColor = DarculaUIUtil.getOutlineColor((boolean)this.editor.getContentComponent().isEnabled(), (boolean)false);
            g2.setColor(c.getParent().getBackground());
            Rectangle s = new Rectangle(x, y, width, height);
            g2.fill(s);
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x + borderWidth, y + borderWidth, width - 2 * borderWidth, height - 2 * borderWidth, arcDiameter, arcDiameter);
            g2.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
            g2.fill(rect);
            if (this.editor.getContentComponent().isEnabled() && this.editor.getContentComponent().isVisible()) {
                if (hasFocus) {
                    if (shouldDrawFancyBorder) {
                        Rectangle borderRect = new Rectangle(x, y, width, height);
                        g2.setPaint(XNextThemeHelper.INSTANCE.getButtonAiXNextDoubleColorBorder().getGradientPaint(borderRect));
                    } else {
                        g2.setColor(this.parent.canBeEnabled() ? focusedColor : nonFocusedColor);
                    }
                } else {
                    g2.setColor(nonFocusedColor);
                }
                g2.setStroke(new BasicStroke(borderWidth));
                g2.draw(rect);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return (Insets)AIAssistantDimensions.INSTANCE.getInputBorderInsets();
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

