/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.chat.modelSelector;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.chat.ui.ChatModelPopupElement;
import com.intellij.ml.llm.core.chat.ui.chat.modelSelector.AIAssistantChatModelSelectorKt;
import com.intellij.ml.llm.core.chat.ui.popup.BaseDetailsComponent;
import com.intellij.ml.llm.core.models.LlmInfoService;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileIDUtils;
import com.intellij.ml.llm.core.statistics.fus.AIAssistantChatEventLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent;", "Lcom/intellij/ml/llm/core/chat/ui/popup/BaseDetailsComponent;", "Lcom/intellij/ml/llm/core/chat/ui/ChatModelPopupElement;", "list", "Ljavax/swing/JList;", "submenu", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ui/popup/WizardPopup;", "<init>", "(Ljavax/swing/JList;Ljava/util/concurrent/atomic/AtomicReference;)V", "extractTooltipData", "listElement", "", "shouldShowTooltip", "", "data", "shouldCreatePopup", "getDisplayName", "", "createTooltipContent", "Ljavax/swing/JComponent;", "onTooltipShown", "", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nModelDetailsComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelDetailsComponent.kt\ncom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n42#2,3:115\n1#3:118\n*S KotlinDebug\n*F\n+ 1 ModelDetailsComponent.kt\ncom/intellij/ml/llm/core/chat/ui/chat/modelSelector/ModelDetailsComponent\n*L\n62#1:115,3\n*E\n"})
public final class ModelDetailsComponent
extends BaseDetailsComponent<ChatModelPopupElement> {
    @NotNull
    private final AtomicReference<WizardPopup> submenu;

    public ModelDetailsComponent(@NotNull JList<? super ChatModelPopupElement> list2, @NotNull AtomicReference<WizardPopup> submenu) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(submenu, (String)"submenu");
        this.submenu = submenu;
        this.install(list2);
    }

    @Override
    @Nullable
    protected ChatModelPopupElement extractTooltipData(@NotNull Object listElement) {
        Intrinsics.checkNotNullParameter((Object)listElement, (String)"listElement");
        return listElement instanceof ChatModelPopupElement ? (ChatModelPopupElement)listElement : null;
    }

    @Override
    protected boolean shouldShowTooltip(@NotNull ChatModelPopupElement data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return data2 instanceof ChatModelPopupElement.Model || data2 instanceof ChatModelPopupElement.AutoModel;
    }

    @Override
    protected boolean shouldCreatePopup() {
        return this.submenu.get() == null;
    }

    @Override
    @NotNull
    protected String getDisplayName(@NotNull ChatModelPopupElement data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ChatModelPopupElement chatModelPopupElement = data2;
        if (chatModelPopupElement instanceof ChatModelPopupElement.Model) {
            return ((ChatModelPopupElement.Model)data2).getModel().getDisplayName();
        }
        if (chatModelPopupElement instanceof ChatModelPopupElement.AutoModel) {
            return LLMBundle.message((String)"chat.model.chooser.auto.tooltip.title", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    @Nullable
    protected JComponent createTooltipContent(@NotNull ChatModelPopupElement data2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List $this$createTooltipContent_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        ChatModelPopupElement chatModelPopupElement = data2;
        if (chatModelPopupElement instanceof ChatModelPopupElement.AutoModel) {
            $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.TextOnly(LLMBundle.message((String)"chat.model.chooser.auto.tooltip.description.text", (Object[])new Object[0])));
        } else if (chatModelPopupElement instanceof ChatModelPopupElement.Model) {
            CharSequence charSequence;
            boolean $i$f$service22 = false;
            Class<LlmInfoService> serviceClass$iv = LlmInfoService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            CharSequence $i$f$service22 = ((LlmInfoService)object).getDescription(((ChatModelPopupElement.Model)data2).getModel().getId());
            if ($i$f$service22.length() == 0) {
                boolean bl2 = false;
                charSequence = ((ChatModelPopupElement.Model)data2).getModel().getDescription();
            } else {
                charSequence = $i$f$service22;
            }
            String modelDescription = (String)charSequence;
            if (((CharSequence)modelDescription).length() > 0) {
                Object html = StringsKt.startsWith$default((String)modelDescription, (String)"<html>", (boolean)false, (int)2, null) ? modelDescription : "<html>" + modelDescription + "</html>";
                $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.JBLabelDescription(new JBLabel(this, (String)html){
                    final /* synthetic */ ModelDetailsComponent this$0;
                    {
                        this.this$0 = $receiver;
                        super($html);
                        this.setAllowAutoWrapping(true);
                        this.setSize(new Dimension(ModelDetailsComponent.access$getMinPopupWidth($receiver), Integer.MAX_VALUE));
                        this.setMaximumSize(new Dimension(ModelDetailsComponent.access$getMinPopupWidth($receiver), Integer.MAX_VALUE));
                        this.setBorder((Border)new JBEmptyBorder(5, 0, 5, 0));
                    }

                    public Dimension getPreferredSize() {
                        View view;
                        Object object = this.getClientProperty("html");
                        View view2 = view = object instanceof View ? (View)object : null;
                        if (view != null) {
                            view.setSize(ModelDetailsComponent.access$getMinPopupWidth(this.this$0), 0.0f);
                            int height = (int)view.getPreferredSpan(1);
                            return new Dimension(ModelDetailsComponent.access$getMinPopupWidth(this.this$0), height + this.getInsets().top + this.getInsets().bottom);
                        }
                        Dimension dimension = super.getPreferredSize();
                        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                        return dimension;
                    }
                }));
            }
            if (AIAssistantChatModelSelectorKt.isThinking(((ChatModelPopupElement.Model)data2).getModel())) {
                Icon icon = MLLlmIcons.Chat.Model.Brain;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Brain");
                $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.thinking.description.text", (Object[])new Object[0])));
            }
            if (AIAssistantChatModelSelectorKt.isFree(((ChatModelPopupElement.Model)data2).getModel())) {
                Icon icon = MLLlmIcons.Chat.Model.Gift;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Gift");
                $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.free.description.text", (Object[])new Object[0])));
            }
            if (AIAssistantChatModelSelectorKt.isExpensive(((ChatModelPopupElement.Model)data2).getModel())) {
                Icon icon = MLLlmIcons.Chat.Model.Ruby;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ruby");
                $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.expensive.description.text", (Object[])new Object[0])));
            }
            if (AIAssistantChatModelSelectorKt.isBeta(((ChatModelPopupElement.Model)data2).getModel())) {
                Icon icon = MLLlmIcons.Chat.Model.Beta;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Beta");
                $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.beta.description.text", (Object[])new Object[0])));
            }
            if (AiaLlmProfileIDUtils.INSTANCE.supportsImages(AiaLlmProfileIDUtils.INSTANCE.fromString(((ChatModelPopupElement.Model)data2).getModel().getId()))) {
                Icon icon = MLLlmIcons.Chat.Model.Image_grey;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Image_grey");
                $this$createTooltipContent_u24lambda_u240.add(new BaseDetailsComponent.DescriptionItem.WithIcon(icon, LLMBundle.message((String)"chat.model.chooser.support.image.text", (Object[])new Object[0])));
            }
        }
        List descriptions2 = CollectionsKt.build((List)list2);
        return this.createDescriptionPanel(descriptions2);
    }

    @Override
    protected void onTooltipShown(@NotNull ChatModelPopupElement data2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ChatModelPopupElement chatModelPopupElement = data2;
        if (chatModelPopupElement instanceof ChatModelPopupElement.Model) {
            string = ((ChatModelPopupElement.Model)data2).getModel().getId();
        } else if (chatModelPopupElement instanceof ChatModelPopupElement.AutoModel) {
            string = ((ChatModelPopupElement.AutoModel)data2).getModel().getId();
        } else {
            return;
        }
        String id = string;
        AIAssistantChatEventLogger.logChatModelSelectorTooltipIsShown(id);
    }

    public static final /* synthetic */ int access$getMinPopupWidth(ModelDetailsComponent $this) {
        return $this.getMinPopupWidth();
    }
}

