/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.ml.llm.core.statistics.fus.FileChangeStats;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.a2ux.api.FileChange;
import org.jetbrains.a2ux.api.FileContent;
import org.jetbrains.a2ux.api.TextFileContent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a8\u0006\b"}, d2={"computeStats", "Lcom/intellij/ml/llm/core/statistics/fus/FileChangeStats;", "Lorg/jetbrains/a2ux/api/FileChange;", "compute", "Lcom/intellij/ml/llm/core/statistics/fus/FileChangeStats$Companion;", "initialContent", "", "newContent", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nFileChangeStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileChangeStats.kt\ncom/intellij/ml/llm/core/statistics/fus/FileChangeStatsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n13#2:129\n13#2:130\n*S KotlinDebug\n*F\n+ 1 FileChangeStats.kt\ncom/intellij/ml/llm/core/statistics/fus/FileChangeStatsKt\n*L\n117#1:129\n125#1:130\n*E\n"})
public final class FileChangeStatsKt {
    @NotNull
    public static final FileChangeStats computeStats(@NotNull FileChange $this$computeStats) {
        FileChangeStats fileChangeStats;
        Intrinsics.checkNotNullParameter((Object)$this$computeStats, (String)"<this>");
        Object object = $this$computeStats.getBeforeContent();
        TextFileContent textFileContent = object instanceof TextFileContent ? (TextFileContent)object : null;
        String initialContent = textFileContent != null ? textFileContent.getText() : null;
        FileContent fileContent = $this$computeStats.getAfterContent();
        TextFileContent textFileContent2 = fileContent instanceof TextFileContent ? (TextFileContent)fileContent : null;
        String newContent = textFileContent2 != null ? textFileContent2.getText() : null;
        object = initialContent;
        if (object == null || object.length() == 0) {
            Object object2 = newContent;
            fileChangeStats = new FileChangeStats(object2 != null && (object2 = StringsKt.lines((CharSequence)((CharSequence)object2))) != null ? object2.size() : 0, 0, 0, 0, 8, null);
        } else {
            object = newContent;
            if (object == null || object.length() == 0) {
                return new FileChangeStats(0, StringsKt.lines((CharSequence)initialContent).size(), 0, 0, 8, null);
            }
            fileChangeStats = FileChangeStatsKt.compute(FileChangeStats.Companion, initialContent, newContent);
        }
        return fileChangeStats;
    }

    @NotNull
    public static final FileChangeStats compute(@NotNull FileChangeStats.Companion $this$compute, @NotNull String initialContent, @NotNull String newContent) {
        Intrinsics.checkNotNullParameter((Object)$this$compute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initialContent, (String)"initialContent");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance(...)");
        ComparisonManager comparisonManager2 = comparisonManager;
        ComparisonPolicy policy = ComparisonPolicy.IGNORE_WHITESPACES;
        DumbProgressIndicator indicator = DumbProgressIndicator.INSTANCE;
        try {
            List list2 = comparisonManager2.compareLines((CharSequence)initialContent, (CharSequence)newContent, policy, (ProgressIndicator)indicator);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"compareLines(...)");
            List lineFragments = list2;
            int added = 0;
            int removed = 0;
            int editedAdded = 0;
            int editedRemoved = 0;
            for (LineFragment fragment : lineFragments) {
                TextDiffType diffType;
                Intrinsics.checkNotNullExpressionValue((Object)DiffUtil.getLineDiffType((LineFragment)fragment), (String)"getLineDiffType(...)");
                if (Intrinsics.areEqual((Object)diffType, (Object)TextDiffType.INSERTED)) {
                    added += fragment.getEndLine2() - fragment.getStartLine2();
                    continue;
                }
                if (Intrinsics.areEqual((Object)diffType, (Object)TextDiffType.DELETED)) {
                    removed += fragment.getEndLine1() - fragment.getStartLine1();
                    continue;
                }
                if (Intrinsics.areEqual((Object)diffType, (Object)TextDiffType.MODIFIED)) {
                    editedRemoved += fragment.getEndLine1() - fragment.getStartLine1();
                    editedAdded += fragment.getEndLine2() - fragment.getStartLine2();
                    continue;
                }
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(FileChange.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("unexpected diff type: " + diffType);
            }
            return new FileChangeStats(added, removed, editedAdded, editedRemoved);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FileChange.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error computing stats for file change " + $this$compute, (Throwable)e);
            return FileChangeStats.Companion.getZero();
        }
    }
}

