/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.intentions.conversion;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.ml.llm.intentions.conversion.converter.PasteCodeConverter;
import com.intellij.ml.llm.intentions.conversion.data.PastePsiFileData;
import com.intellij.ml.llm.intentions.conversion.data.PasteRawTextData;
import com.intellij.ml.llm.intentions.conversion.editor.ConvertTransformationsProvider;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.std.TransferablePrivacyWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JF\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/intentions/conversion/PasteConvertCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "<init>", "()V", "isFeatureEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "processTransferableData", "", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "", "indented", "Lcom/intellij/openapi/util/Ref;", "values", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nPasteConvertCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasteConvertCopyPasteProcessor.kt\ncom/intellij/ml/llm/intentions/conversion/PasteConvertCopyPasteProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,81:1\n1#2:82\n42#3,3:83\n*S KotlinDebug\n*F\n+ 1 PasteConvertCopyPasteProcessor.kt\ncom/intellij/ml/llm/intentions/conversion/PasteConvertCopyPasteProcessor\n*L\n30#1:83,3\n*E\n"})
public final class PasteConvertCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    private final boolean isFeatureEnabled(Project project) {
        ConvertTransformationsProvider convertTransformationsProvider;
        Project project2 = project;
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            convertTransformationsProvider = (ConvertTransformationsProvider)CollectionsKt.firstOrNull((List)ConvertTransformationsProvider.Companion.getEP_NAME().getExtensions((AreaInstance)project));
        } else {
            convertTransformationsProvider = null;
        }
        ConvertTransformationsProvider provider = convertTransformationsProvider;
        boolean $i$f$service = false;
        Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LLMSettingsManager)object).isPasteConvertEnabled() && (AIAssistantUIUtil.INSTANCE.isAssistantActive(project) && AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getCONVERSION_ON_PASTE_PROMPT_ID()) || PluginManagerCore.isUnitTestMode) && (provider == null || provider.isPasteHandlerEnabled());
    }

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        if (this.isFeatureEnabled(file.getProject())) {
            PSString text2 = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)((PsiNamedElement)file)).getText().substring(startOffsets[0], endOffsets[0]);
            list2 = CollectionsKt.listOf((Object)new PastePsiFileData(file, text2));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        try {
            TextBlockTransferableData textBlockTransferableData;
            if (content2.isDataFlavorSupported(PastePsiFileData.Companion.getDATA_FLAVOR())) {
                Object object = content2.getTransferData(PastePsiFileData.Companion.getDATA_FLAVOR());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.codeInsight.editorActions.TextBlockTransferableData");
                textBlockTransferableData = (TextBlockTransferableData)object;
            } else {
                TransferablePrivacyWrapper transferablePrivacyWrapper = SharedExtensionsKtKt.getPrivacySafe((Transferable)content2);
                DataFlavor dataFlavor = DataFlavor.stringFlavor;
                Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"stringFlavor");
                textBlockTransferableData = new PasteRawTextData(transferablePrivacyWrapper.getTransferData(dataFlavor));
            }
            TextBlockTransferableData data2 = textBlockTransferableData;
            return CollectionsKt.listOf((Object)data2);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            return CollectionsKt.emptyList();
        }
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values) {
        PsiFile sourceFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        PsiFile targetFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        TextBlockTransferableData data2 = (TextBlockTransferableData)CollectionsKt.firstOrNull(values);
        PsiFile psiFile = sourceFile = data2 instanceof PastePsiFileData ? ((PastePsiFileData)data2).getPsiFile() : null;
        if (this.isFeatureEnabled(project) && !PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (PsiFile)sourceFile) && !PrivacyPathCheckerKt.isAiIgnoreBlocked((Project)project, (PsiFile)targetFile)) {
            PasteCodeConverter.INSTANCE.processTransferableData(project, editor, bounds, values);
        }
    }
}

