/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlueSettingsParser {
    private static final String RESOURCE_NAME = "GlueSettings.xml";
    private final Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private final Map<String, Integer> glueTypeMappings = new HashMap<String, Integer>();
    private Glue[] glueTypes;
    private final Map<String, Integer> styleMappings = new HashMap<String, Integer>();
    private Element root;

    public GlueSettingsParser() throws ResourceParseException {
        try {
            this.setTypeMappings();
            this.setStyleMappings();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            this.root = factory.newDocumentBuilder().parse(GlueSettingsParser.class.getResourceAsStream(RESOURCE_NAME)).getDocumentElement();
            this.parseGlueTypes();
        }
        catch (Exception e) {
            throw new XMLResourceParseException(RESOURCE_NAME, e);
        }
    }

    private void setStyleMappings() {
        this.styleMappings.put("display", 0);
        this.styleMappings.put("text", 1);
        this.styleMappings.put("script", 2);
        this.styleMappings.put("script_script", 3);
    }

    private void parseGlueTypes() throws ResourceParseException {
        ArrayList<Glue> glueTypesList = new ArrayList<Glue>();
        Element types = (Element)this.root.getElementsByTagName("GlueTypes").item(0);
        int defaultIndex = -1;
        int index = 0;
        if (types != null) {
            NodeList list2 = types.getElementsByTagName("GlueType");
            for (int i = 0; i < list2.getLength(); ++i) {
                Element type = (Element)list2.item(i);
                String name = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", type);
                Glue glue = this.createGlue(type, name);
                if (name.equalsIgnoreCase("default")) {
                    defaultIndex = index;
                }
                glueTypesList.add(glue);
                ++index;
            }
        }
        if (defaultIndex < 0) {
            defaultIndex = index;
            glueTypesList.add(new Glue(0.0f, 0.0f, 0.0f, "default"));
        }
        this.glueTypes = glueTypesList.toArray(new Glue[glueTypesList.size()]);
        if (defaultIndex > 0) {
            Glue tmp = this.glueTypes[defaultIndex];
            this.glueTypes[defaultIndex] = this.glueTypes[0];
            this.glueTypes[0] = tmp;
        }
        for (int i = 0; i < this.glueTypes.length; ++i) {
            this.glueTypeMappings.put(this.glueTypes[i].getName(), i);
        }
    }

    private Glue createGlue(Element type, String name) throws ResourceParseException {
        String[] names = new String[]{"space", "stretch", "shrink"};
        float[] values = new float[names.length];
        for (int i = 0; i < names.length; ++i) {
            double val = 0.0;
            String attrVal = null;
            try {
                attrVal = type.getAttribute(names[i]);
                if (!attrVal.equals("")) {
                    val = Double.parseDouble(attrVal);
                }
            }
            catch (NumberFormatException e) {
                throw new XMLResourceParseException(RESOURCE_NAME, "GlueType", names[i], "has an invalid real value '" + attrVal + "'!");
            }
            values[i] = (float)val;
        }
        return new Glue(values[0], values[1], values[2], name);
    }

    private void setTypeMappings() {
        this.typeMappings.put("ord", 0);
        this.typeMappings.put("op", 1);
        this.typeMappings.put("bin", 2);
        this.typeMappings.put("rel", 3);
        this.typeMappings.put("open", 4);
        this.typeMappings.put("close", 5);
        this.typeMappings.put("punct", 6);
        this.typeMappings.put("inner", 7);
    }

    public Glue[] getGlueTypes() {
        return this.glueTypes;
    }

    public int[][][] createGlueTable() throws ResourceParseException {
        int size = this.typeMappings.size();
        int[][][] table = new int[size][size][this.styleMappings.size()];
        Element glueTable = (Element)this.root.getElementsByTagName("GlueTable").item(0);
        if (glueTable != null) {
            NodeList list2 = glueTable.getElementsByTagName("Glue");
            for (int i = 0; i < list2.getLength(); ++i) {
                Element glue = (Element)list2.item(i);
                String left = GlueSettingsParser.getAttrValueAndCheckIfNotNull("lefttype", glue);
                String right = GlueSettingsParser.getAttrValueAndCheckIfNotNull("righttype", glue);
                String type = GlueSettingsParser.getAttrValueAndCheckIfNotNull("gluetype", glue);
                NodeList listG = glue.getElementsByTagName("Style");
                for (int j = 0; j < listG.getLength(); ++j) {
                    Element style = (Element)listG.item(j);
                    String styleName = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", style);
                    Integer l = this.typeMappings.get(left);
                    Integer r = this.typeMappings.get(right);
                    Integer st = this.styleMappings.get(styleName);
                    Integer val = this.glueTypeMappings.get(type);
                    GlueSettingsParser.checkMapping(l, "Glue", "lefttype", left);
                    GlueSettingsParser.checkMapping(r, "Glue", "righttype", right);
                    GlueSettingsParser.checkMapping(val, "Glue", "gluetype", type);
                    GlueSettingsParser.checkMapping(st, "Style", "name", styleName);
                    table[l.intValue()][r.intValue()][st.intValue()] = val;
                }
            }
        }
        return table;
    }

    private static void checkMapping(Object val, String elementName, String attrName, String attrValue) throws ResourceParseException {
        if (val == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, elementName, attrName, "has an unknown value '" + attrValue + "'!");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, null);
        }
        return attrValue;
    }
}

