/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.toolbar;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.HelpTooltip;
import com.intellij.llmInstaller.ui.welcome.BaseWelcomePanel;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.actions.AINewChatActionMarker;
import com.intellij.ml.llm.core.chat.actions.selection.AIAssistantBaseAction;
import com.intellij.ml.llm.core.chat.actions.toolbar.AIAssistantNewChatActionAltKt;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.ui.AIAssistantContainerPanel;
import com.intellij.ml.llm.core.chat.ui.AIAssistantModelSelectorVmImpl;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.ChatModel;
import com.intellij.ml.llm.core.error.ErrorManager;
import com.intellij.ml.llm.core.providers.LlmLocalModeManager;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/toolbar/AIAssistantNewChatActionAlt;", "Lcom/intellij/ml/llm/core/chat/actions/selection/AIAssistantBaseAction;", "Lcom/intellij/ml/llm/core/chat/actions/AINewChatActionMarker;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "isLocalChatModelOrActivated", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.content"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAIAssistantNewChatActionAlt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantNewChatActionAlt.kt\ncom/intellij/ml/llm/core/chat/actions/toolbar/AIAssistantNewChatActionAlt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,91:1\n42#2,3:92\n*S KotlinDebug\n*F\n+ 1 AIAssistantNewChatActionAlt.kt\ncom/intellij/ml/llm/core/chat/actions/toolbar/AIAssistantNewChatActionAlt\n*L\n74#1:92,3\n*E\n"})
public final class AIAssistantNewChatActionAlt
extends AIAssistantBaseAction
implements AINewChatActionMarker {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        AIAssistantContainerPanel aIAssistantContainerPanel = (AIAssistantContainerPanel)((Object)dataContext2.getData(AIAssistantContainerPanel.Companion.getAIAssistantContainer()));
        if (aIAssistantContainerPanel == null) {
            AIAssistantNewChatActionAltKt.access$getLog$p().warn("Can't find chat list panel");
            return;
        }
        AIAssistantContainerPanel containerPanel = aIAssistantContainerPanel;
        containerPanel.openNewChat();
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        AIAssistantContainerPanel containerPanel;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ChatSession session = (ChatSession)dataContext2.getData(ChatSession.Companion.getCurrentSession());
        AIAssistantContainerPanel aIAssistantContainerPanel = containerPanel = (AIAssistantContainerPanel)((Object)dataContext2.getData(AIAssistantContainerPanel.Companion.getAIAssistantContainer()));
        JComponent content = aIAssistantContainerPanel != null ? aIAssistantContainerPanel.getContent() : null;
        boolean isAssistantActive = AIAssistantUIUtil.INSTANCE.isActiveButMaybeOutOfPrompts(project2);
        boolean isContentNotWelcomePanel = !(content instanceof BaseWelcomePanel);
        e.getPresentation().setVisible(isAssistantActive && isContentNotWelcomePanel);
        Object object = session;
        boolean hasSessionMessages = object != null && (object = object.getMessages()) != null ? !((Collection)object).isEmpty() : false;
        boolean isErrorFree = !ErrorManager.Companion.getInstance().isAssistantInErrorState();
        e.getPresentation().setEnabled((session == null || hasSessionMessages) && this.isLocalChatModelOrActivated(project2) && isErrorFree && containerPanel != null);
        String actionId = ActionManager.getInstance().getId((AnAction)this);
        if (actionId != null) {
            String string = KeymapUtil.getFirstKeyboardShortcutText((String)actionId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
            String firstKeyboardShortcutText = string;
            if (((CharSequence)firstKeyboardShortcutText).length() == 0) {
                e.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, null);
            } else {
                void $this$update_u24lambda_u240;
                HelpTooltip helpTooltip;
                HelpTooltip helpTooltip2 = helpTooltip = new HelpTooltip();
                Key key = ActionButton.CUSTOM_HELP_TOOLTIP;
                Presentation presentation = e.getPresentation();
                boolean bl = false;
                $this$update_u24lambda_u240.setTitle(LLMBundle.message((String)"action.AIAssistant.ToolWindow.NewChatAction.text", (Object[])new Object[0]));
                $this$update_u24lambda_u240.setShortcut(firstKeyboardShortcutText);
                Unit unit = Unit.INSTANCE;
                presentation.putClientProperty(key, (Object)helpTooltip);
            }
        }
    }

    private final boolean isLocalChatModelOrActivated(Project project) {
        boolean isProperLocalMode;
        boolean $i$f$service = false;
        Class<AIAssistantModelSelectorVmImpl> serviceClass$iv = AIAssistantModelSelectorVmImpl.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Object object2 = (ChatModel)((AIAssistantModelSelectorVmImpl)object).getSelectedModel().getValue();
        boolean isLocalModel = object2 != null && (object2 = object2.getId()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"/", (boolean)false, (int)2, null) : false;
        boolean bl = isProperLocalMode = !LlmLocalModeManager.Companion.isLocalModeMisconfigured();
        if (isLocalModel && isProperLocalMode) {
            return true;
        }
        if (AIAssistantUIUtil.INSTANCE.isCodexOAuthAuthenticated() || AIAssistantUIUtil.INSTANCE.isAcpAgentAdded()) {
            return true;
        }
        boolean isActivated = AIAssistantUIUtil.INSTANCE.isAssistantActive(project);
        boolean hasQuota = (Boolean)QuotaManager2.Companion.getInstance().getHasEnoughQuota().getValue();
        return isActivated && hasQuota;
    }
}

