/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector.jetenry;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.ml.models.InlinePromptDetectionJetEnryModelHolder;
import com.jetbrains.mlapi.bundle.ModelPipelineLoader;
import com.jetbrains.mlapi.model.pipeline.ModelPipeline;
import com.jetbrains.mlapi.model.prediction.ClassesProbabilities;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/jetenry/InlinePromptDetectionModelLoader;", "", "<init>", "()V", "modelFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "value", "Lcom/jetbrains/mlapi/model/pipeline/ModelPipeline;", "Lcom/jetbrains/mlapi/model/prediction/ClassesProbabilities;", "model", "getModel", "()Lcom/jetbrains/mlapi/model/pipeline/ModelPipeline;", "loadModel", "", "Companion", "intellij.ml.llm.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nInlinePromptDetectionModelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinePromptDetectionModelLoader.kt\ncom/intellij/ml/llm/inlinePromptDetector/jetenry/InlinePromptDetectionModelLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n*S KotlinDebug\n*F\n+ 1 InlinePromptDetectionModelLoader.kt\ncom/intellij/ml/llm/inlinePromptDetector/jetenry/InlinePromptDetectionModelLoader\n*L\n42#1:45\n*E\n"})
public final class InlinePromptDetectionModelLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CompletableFuture<Void> modelFuture;
    @Nullable
    private ModelPipeline<ClassesProbabilities> model;
    @NotNull
    private static final Logger LOG;

    public InlinePromptDetectionModelLoader() {
        this.loadModel();
    }

    @Nullable
    public final ModelPipeline<ClassesProbabilities> getModel() {
        return this.model;
    }

    private final void loadModel() {
        CompletableFuture<Void> completableFuture = this.modelFuture;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        LOG.info("Loading CatBoost JetEnry prompt detection model");
        ModelPipelineLoader modelPipelineLoader = ModelPipelineLoader.Companion.getDEFAULT();
        InputStream inputStream = InlinePromptDetectionJetEnryModelHolder.getStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getStream(...)");
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        this.modelFuture = ((CompletableFuture)modelPipelineLoader.load(inputStream, executorService).thenAccept(arg_0 -> InlinePromptDetectionModelLoader.loadModel$lambda$1(arg_0 -> InlinePromptDetectionModelLoader.loadModel$lambda$0(this, arg_0), arg_0))).exceptionally(InlinePromptDetectionModelLoader::loadModel$lambda$2);
    }

    private static final Unit loadModel$lambda$0(InlinePromptDetectionModelLoader this$0, ModelPipeline model) {
        LOG.info("Successfully loaded CatBoost JetEnry prompt detection model");
        this$0.model = model.predictingClasses();
        return Unit.INSTANCE;
    }

    private static final void loadModel$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void loadModel$lambda$2(Throwable e) {
        LOG.warn("Failed to load CatBoost JetEnry prompt detection model. Prompt initiating words will be used instead.", e);
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InlinePromptDetectionModelLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/jetenry/InlinePromptDetectionModelLoader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.inlinePromptDetector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

