/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.history_processors;

import com.intellij.ml.llm.matterhorn.AgentArtifactTypes;
import com.intellij.ml.llm.matterhorn.AgentState;
import com.intellij.ml.llm.matterhorn.ArtifactRequestExecutor;
import com.intellij.ml.llm.matterhorn.ArtifactResponse;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.history_processors.Last5ObservationsResponse;
import com.intellij.ml.llm.matterhorn.llm.MatterhornAssistantChatMessageWithToolUses;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatElement;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatKt;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessageKind;
import com.intellij.ml.llm.matterhorn.llm.MatterhornUserChatMessageWithToolResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/matterhorn/history_processors/Last5ObservationsHistoryProcessor;", "Lcom/intellij/ml/llm/matterhorn/ArtifactRequestExecutor;", "Lcom/intellij/ml/llm/matterhorn/AgentState;", "Lcom/intellij/ml/llm/matterhorn/history_processors/Last5ObservationsResponse;", "<init>", "()V", "MAX_FULL_USER_MSGS", "", "produceArtifact", "Lcom/intellij/ml/llm/matterhorn/ArtifactResponse;", "input", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "(Lcom/intellij/ml/llm/matterhorn/AgentState;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ej-core"})
public final class Last5ObservationsHistoryProcessor
implements ArtifactRequestExecutor<AgentState, Last5ObservationsResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int MAX_FULL_USER_MSGS;

    public Last5ObservationsHistoryProcessor() {
        this.MAX_FULL_USER_MSGS = 5;
    }

    @Override
    @Nullable
    public Object produceArtifact(@NotNull AgentState input, @NotNull ExecutionContext context2, @NotNull Continuation<? super ArtifactResponse<Last5ObservationsResponse>> $completion) {
        boolean bl = Intrinsics.areEqual(context2.getRequest().getArtifact().getType(), AgentArtifactTypes.INSTANCE.getLast5ObservationsArtifactType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (input.getObservations().isEmpty()) {
            return new ArtifactResponse(new Last5ObservationsResponse(CollectionsKt.emptyList(), CollectionsKt.emptyList()), null, 2, null);
        }
        Pair<List<MatterhornChatElement>, List<MatterhornChatElement>> pair = Companion.shortenUserMessages(input.getObservations(), this.MAX_FULL_USER_MSGS);
        List processedMessages = (List)pair.component1();
        List collapsedMessages = (List)pair.component2();
        return new ArtifactResponse(new Last5ObservationsResponse(processedMessages, collapsedMessages), null, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/matterhorn/history_processors/Last5ObservationsHistoryProcessor$Companion;", "", "<init>", "()V", "shortenUserMessages", "Lkotlin/Pair;", "", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatElement;", "inputMessages", "numFullUserMsgs", "", "ej-core"})
    @SourceDebugExtension(value={"SMAP\nLast5ObservationsHistoryProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Last5ObservationsHistoryProcessor.kt\ncom/intellij/ml/llm/matterhorn/history_processors/Last5ObservationsHistoryProcessor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,73:1\n1734#2,3:74\n1782#2,4:77\n1104#3,3:81\n*S KotlinDebug\n*F\n+ 1 Last5ObservationsHistoryProcessor.kt\ncom/intellij/ml/llm/matterhorn/history_processors/Last5ObservationsHistoryProcessor$Companion\n*L\n46#1:74,3\n51#1:77,4\n63#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<List<MatterhornChatElement>, List<MatterhornChatElement>> shortenUserMessages(@NotNull List<? extends MatterhornChatElement> inputMessages, int numFullUserMsgs) {
            int n;
            boolean $this$all$iv22;
            block14: {
                Intrinsics.checkNotNullParameter(inputMessages, (String)"inputMessages");
                Iterable $this$all$iv22 = inputMessages;
                boolean $i$f$all = false;
                if ($this$all$iv22 instanceof Collection && ((Collection)$this$all$iv22).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv22) {
                        MatterhornChatElement it = (MatterhornChatElement)element$iv;
                        boolean bl = false;
                        if (!(it instanceof MatterhornAssistantChatMessageWithToolUses) && !(it instanceof MatterhornUserChatMessageWithToolResults)) continue;
                        v0 = false;
                        break block14;
                    }
                    v0 = $this$all$iv22 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv22) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            boolean bl = $this$all$iv22 = ((MatterhornChatElement)CollectionsKt.last(inputMessages)).getKind() == MatterhornChatMessageKind.User;
            if (_Assertions.ENABLED && !$this$all$iv22) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            List messages = new ArrayList();
            List collapsedUserMessages = new ArrayList();
            Iterable $this$count$iv = inputMessages;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var8_19;
                boolean bl2 = false;
                for (Object element$iv : $this$count$iv) {
                    MatterhornChatElement it = (MatterhornChatElement)element$iv;
                    boolean bl22 = false;
                    if (!(it.getKind() == MatterhornChatMessageKind.User) || ++var8_19 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var8_19;
            }
            int userMessagesCnt = n;
            int userMsgIdx = 0;
            for (MatterhornChatElement matterhornChatElement : inputMessages) {
                int count$iv;
                if (matterhornChatElement.getKind() != MatterhornChatMessageKind.User) {
                    ((Collection)messages).add(matterhornChatElement);
                    continue;
                }
                if (userMessagesCnt - numFullUserMsgs < ++userMsgIdx) {
                    ((Collection)messages).add(matterhornChatElement);
                    continue;
                }
                if (matterhornChatElement instanceof MatterhornChatMessage) {
                    CharSequence $this$count$iv2 = ((MatterhornChatMessage)matterhornChatElement).getContent();
                    boolean $i$f$count2 = false;
                    count$iv = 0;
                    for (int i = 0; i < $this$count$iv2.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$count$iv2.charAt(i);
                        boolean bl3 = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                } else {
                    throw new InternalError();
                }
                int count = count$iv;
                ((Collection)messages).add(MatterhornChatKt.toUserMessage("Old output omitted (" + count + " lines)"));
                ((Collection)collapsedUserMessages).add(matterhornChatElement);
            }
            return new Pair((Object)messages, (Object)collapsedUserMessages);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

