/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.external.artifacts;

import com.intellij.ml.llm.embeddings.external.artifacts.DownloadableArtifact;
import com.intellij.ml.llm.embeddings.external.artifacts.LocalArtifactsManager;
import com.intellij.openapi.util.SystemInfoRt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/embeddings/external/artifacts/NativeServerArtifact;", "Lcom/intellij/ml/llm/embeddings/external/artifacts/DownloadableArtifact;", "<init>", "()V", "BINARY_NAME", "", "CDN_LINK_BASE", "archiveName", "getArchiveName", "()Ljava/lang/String;", "downloadLink", "getDownloadLink", "destination", "Ljava/nio/file/Path;", "getDestination", "()Ljava/nio/file/Path;", "getBinaryPath", "checkPresent", "", "equals", "other", "", "hashCode", "", "toString", "intellij.ml.llm.embeddings"})
public final class NativeServerArtifact
implements DownloadableArtifact {
    @NotNull
    public static final NativeServerArtifact INSTANCE = new NativeServerArtifact();
    @NotNull
    private static final String BINARY_NAME = "embeddings-server";
    @NotNull
    private static final String CDN_LINK_BASE = "https://download.jetbrains.com/resources/ml/full-line/servers";
    @NotNull
    private static final String archiveName = "embeddings-server.zip";
    @NotNull
    private static final String downloadLink;
    @NotNull
    private static final Path destination;

    private NativeServerArtifact() {
    }

    @Override
    @NotNull
    public String getArchiveName() {
        return archiveName;
    }

    @Override
    @NotNull
    public String getDownloadLink() {
        return downloadLink;
    }

    @Override
    @NotNull
    public Path getDestination() {
        return destination;
    }

    @NotNull
    public final Path getBinaryPath() {
        Path path;
        if (SystemInfoRt.isMac) {
            Path path2 = this.getDestination().resolve("embeddings-server.app");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path path3 = path2.resolve("Contents");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path path4 = path3.resolve("MacOS");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Path path5 = path4.resolve(BINARY_NAME);
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        } else if (SystemInfoRt.isWindows) {
            Path path6 = this.getDestination().resolve("embeddings-server.exe");
            path = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        } else {
            Path path7 = this.getDestination().resolve(BINARY_NAME);
            path = path7;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkPresent() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(this.getDestination(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(this.getBinaryPath(), Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        return true;
    }

    @NotNull
    public String toString() {
        return "NativeServerArtifact";
    }

    public int hashCode() {
        return -26947600;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NativeServerArtifact)) {
            return false;
        }
        NativeServerArtifact cfr_ignored_0 = (NativeServerArtifact)other;
        return true;
    }

    static {
        Object[] objectArray = new String[]{CDN_LINK_BASE, LocalArtifactsManager.Companion.getSERVER_VERSION$intellij_ml_llm_embeddings(), LocalArtifactsManager.Companion.getOsId(), LocalArtifactsManager.Companion.getArchitectureId(), INSTANCE.getArchiveName()};
        downloadLink = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        destination = LocalArtifactsManager.Companion.getServerRoot$intellij_ml_llm_embeddings();
    }
}

