/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer;

import com.intellij.ml.llm.embeddings.indexer.BaseFileBasedEmbeddingIndex;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexesKt;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingKey;
import com.intellij.ml.llm.embeddings.indexer.FileBasedEmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.FilesEmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.FilesInContentPropertyPusherKt;
import com.intellij.ml.llm.embeddings.indexer.entities.IndexableFileName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/FileNameEmbeddingIndex;", "Lcom/intellij/ml/llm/embeddings/indexer/BaseFileBasedEmbeddingIndex;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/IndexableFileName;", "<init>", "()V", "embeddingIndexId", "Lcom/intellij/ml/llm/embeddings/indexer/FileBasedEmbeddingIndexId;", "getEmbeddingIndexId", "()Lcom/intellij/ml/llm/embeddings/indexer/FileBasedEmbeddingIndexId;", "getName", "Lcom/intellij/util/indexing/ID;", "Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingKey;", "getVersion", "", "index", "Lkotlin/sequences/Sequence;", "context", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "dependsOnFileContent", "", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "intellij.ml.llm.embeddings"})
public final class FileNameEmbeddingIndex
extends BaseFileBasedEmbeddingIndex<IndexableFileName> {
    @NotNull
    private final FileBasedEmbeddingIndexId<IndexableFileName> embeddingIndexId = FilesEmbeddingIndexId.INSTANCE;

    @Override
    @NotNull
    public FileBasedEmbeddingIndexId<IndexableFileName> getEmbeddingIndexId() {
        return this.embeddingIndexId;
    }

    @NotNull
    public ID<EmbeddingKey, IndexableFileName> getName() {
        return EmbeddingIndexesKt.getFILE_NAME_EMBEDDING_INDEX_NAME();
    }

    public int getVersion() {
        return 4;
    }

    @Override
    @NotNull
    public Sequence<IndexableFileName> index(@NotNull FileContent context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VirtualFile virtualFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return SequencesKt.sequenceOf((Object)new IndexableFileName(virtualFile));
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return arg_0 -> FileNameEmbeddingIndex.getInputFilter$lambda$0(this, arg_0);
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    @NotNull
    public DataExternalizer<IndexableFileName> getValueExternalizer() {
        return (DataExternalizer)new DataExternalizer<IndexableFileName>(){

            public void save(DataOutput out, IndexableFileName value) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                out.writeUTF(value.getName());
            }

            public IndexableFileName read(DataInput src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                String string = src.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                return new IndexableFileName(string, null, 2, null);
            }
        };
    }

    private static final boolean getInputFilter$lambda$0(FileNameEmbeddingIndex this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EmbeddingIndexId.isEnabled$default(this$0.getEmbeddingIndexId(), null, 1, null) && FilesInContentPropertyPusherKt.isInContent(it);
    }
}

