/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer.entities.provider;

import com.intellij.ml.llm.embeddings.indexer.entities.IndexableTextChunk;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a.\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"MAX_CHUNK_SIZE_CHARS", "", "splitIntoChunksByNewlines", "", "Lcom/intellij/ml/llm/embeddings/indexer/entities/IndexableTextChunk;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "maxChunkSize", "createChunk", "relativePath", "", "startOffset", "endOffsetExclusive", "intellij.ml.llm.embeddings"})
public final class TextSplitUtilsKt {
    private static final int MAX_CHUNK_SIZE_CHARS = 1200;

    @NotNull
    public static final List<IndexableTextChunk> splitIntoChunksByNewlines(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text2, int maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile projectRoot = virtualFile2;
        String string = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectRoot);
        if (string == null) {
            String string2 = virtualFile.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        String relativePath = string;
        List chunks = new ArrayList();
        int currentStartOffset = 0;
        int currentEndOffsetExclusive = 0;
        Iterator iterator2 = StringsKt.lines((CharSequence)text2).iterator();
        while (iterator2.hasNext()) {
            int currentChunkLength = currentEndOffsetExclusive - currentStartOffset;
            String line = (String)iterator2.next();
            int charsToAdd = line.length() + (currentChunkLength > 0 ? 1 : 0);
            if (currentChunkLength + charsToAdd > maxChunkSize && currentChunkLength > 0) {
                chunks.add(TextSplitUtilsKt.createChunk(virtualFile, relativePath, currentStartOffset, currentEndOffsetExclusive));
                currentStartOffset = currentEndOffsetExclusive + 1;
            }
            currentEndOffsetExclusive += charsToAdd;
        }
        if (currentEndOffsetExclusive > currentStartOffset) {
            chunks.add(TextSplitUtilsKt.createChunk(virtualFile, relativePath, currentStartOffset, currentEndOffsetExclusive));
        }
        return chunks;
    }

    public static /* synthetic */ List splitIntoChunksByNewlines$default(Project project, VirtualFile virtualFile, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 1200;
        }
        return TextSplitUtilsKt.splitIntoChunksByNewlines(project, virtualFile, charSequence, n);
    }

    private static final IndexableTextChunk createChunk(VirtualFile virtualFile, String relativePath, int startOffset, int endOffsetExclusive) {
        return new IndexableTextChunk(relativePath + ":" + startOffset + ":" + endOffsetExclusive, new TextRange(startOffset, endOffsetExclusive), virtualFile);
    }
}

