/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.memory.contexts.AutoAllocatorContext;
import io.kinference.ndarray.arrays.memory.storage.FloatGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.FloatPointerKt;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.primitives.types.DataType;
import io.kinference.utils.inlines.InlineInt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0004J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001aH\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u0000J,\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u000b2\b\b\u0002\u0010\"\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000bJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\u0016\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\"\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006-"}, d2={"Lio/kinference/ndarray/arrays/tiled/FloatTiledArray;", "", "blocks", "", "", "<init>", "([[F)V", "getBlocks", "()[[F", "[[F", "size", "", "getSize", "()I", "blockSize", "getBlockSize", "blocksNum", "getBlocksNum", "pointer", "Lio/kinference/ndarray/arrays/pointers/FloatPointer;", "startIndex", "toArray", "indexFor", "Lkotlin/Pair;", "i", "get", "", "set", "", "value", "copyOf", "copyInto", "dest", "destOffset", "srcStart", "srcEnd", "plus", "other", "copyOfRange", "fromIndex", "toIndex", "fill", "from", "to", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nFloatTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatTiledArray.kt\nio/kinference/ndarray/arrays/tiled/FloatTiledArray\n+ 2 FloatPointer.kt\nio/kinference/ndarray/arrays/pointers/FloatPointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1217#2:189\n1219#2,30:191\n1217#2:221\n1219#2,30:223\n1#3:190\n1#3:222\n*S KotlinDebug\n*F\n+ 1 FloatTiledArray.kt\nio/kinference/ndarray/arrays/tiled/FloatTiledArray\n*L\n147#1:189\n147#1:191,30\n153#1:221\n153#1:223,30\n147#1:190\n153#1:222\n*E\n"})
public final class FloatTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[][] blocks;
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private static final DataType type = DataType.FLOAT;

    public FloatTiledArray(@NotNull float[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])this.blocks).length == 0 ? 0 : ((float[])ArraysKt.first((Object[])((Object[])this.blocks))).length;
        this.blocksNum = ((Object[])this.blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    @NotNull
    public final float[][] getBlocks() {
        return this.blocks;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final FloatPointer pointer(int startIndex) {
        return new FloatPointer(this, startIndex);
    }

    public static /* synthetic */ FloatPointer pointer$default(FloatTiledArray floatTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return floatTiledArray.pointer(n);
    }

    @NotNull
    public final float[] toArray() {
        if (this.size == 0) {
            return new float[0];
        }
        float[] array = new float[this.size];
        int offset = 0;
        float[][] fArray = this.blocks;
        int n = ((Object[])fArray).length;
        for (int i = 0; i < n; ++i) {
            float[] block = fArray[i];
            ArraysKt.copyInto$default((float[])block, (float[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final float get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, float value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final FloatTiledArray copyOf() {
        int n = 0;
        int n2 = this.blocksNum;
        float[][] fArrayArray = new float[n2][];
        while (n < n2) {
            int n3 = n++;
            fArrayArray[n3] = new float[this.blockSize];
        }
        float[][] copyBlocks = fArrayArray;
        n2 = this.blocksNum;
        for (int blockNum = 0; blockNum < n2; ++blockNum) {
            float[] thisBlock = this.blocks[blockNum];
            float[] destBlock = copyBlocks[blockNum];
            ArraysKt.copyInto$default((float[])thisBlock, (float[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return new FloatTiledArray(copyBlocks);
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull FloatTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        FloatPointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        FloatPointer thisPtr = new FloatPointer(this, srcStart);
        FloatPointer floatPointer = destPtr = new FloatPointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!FloatPointerKt.isCompatibleBySize((FloatPointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-FloatPointerKt$accept$9$iv22 = false;
            String $i$a$-require-FloatPointerKt$accept$9$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$accept$9$iv22.toString());
        }
        if (FloatPointerKt.isCompatibleWith((FloatPointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            float[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                float[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    float cfr_ignored_0 = dstBlock$iv[index$iv];
                    float f = srcBlock$iv[index$iv];
                    int n2 = index$iv++;
                    float[] fArray = dstBlock$iv;
                    boolean bl = false;
                    void var20_26 = src;
                    fArray[n2] = var20_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                float src = thisPtr.getAndIncrement();
                void var18_23 = $this$accept$iv;
                boolean bl = false;
                float f = src;
                var18_23.set(f);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(FloatTiledArray floatTiledArray, FloatTiledArray floatTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = floatTiledArray.size;
        }
        floatTiledArray.copyInto(floatTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FloatTiledArray plus(@NotNull FloatTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        FloatPointer thisPtr = new FloatPointer(this, 0, 2, null);
        FloatPointer destPtr = new FloatPointer(other, 0, 2, null);
        FloatPointer floatPointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!FloatPointerKt.isCompatibleBySize((FloatPointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-FloatPointerKt$accept$9$iv22 = false;
            String $i$a$-require-FloatPointerKt$accept$9$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$accept$9$iv22.toString());
        }
        if (FloatPointerKt.isCompatibleWith((FloatPointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            float[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                float[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    float f = srcBlock$iv[index$iv];
                    float f2 = dstBlock$iv[index$iv];
                    int n2 = index$iv++;
                    float[] fArray = dstBlock$iv;
                    boolean bl = false;
                    void var18_25 = src + dst;
                    fArray[n2] = var18_25;
                }
            }
        } else {
            while (end$iv > 0) {
                float dst = destPtr.getAndIncrement();
                float src = $this$accept$iv.get();
                void var16_22 = $this$accept$iv;
                boolean bl = false;
                float f = src + dst;
                var16_22.set(f);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final float[] copyOfRange(int fromIndex, int toIndex) {
        float[] array = new float[toIndex - fromIndex];
        FloatPointer pointer = new FloatPointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(float value, int from, int to) {
        if (from == to) {
            return;
        }
        FloatPointer pointer = new FloatPointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            float[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((float[])block, (float)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(FloatTiledArray floatTiledArray, float f, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = floatTiledArray.size;
        }
        floatTiledArray.fill(f, n, n2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086B\u00a2\u0006\u0002\u0010\fJ*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086B\u00a2\u0006\u0002\u0010\u0014J*\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0086B\u00a2\u0006\u0002\u0010\u001bJ2\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/kinference/ndarray/arrays/tiled/FloatTiledArray$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "invoke", "Lio/kinference/ndarray/arrays/tiled/FloatTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "init", "Lkotlin/Function1;", "Lio/kinference/utils/inlines/InlineInt;", "", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shape", "", "([ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([ILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "array", "", "size", "", "blockSize", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(IILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nFloatTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatTiledArray.kt\nio/kinference/ndarray/arrays/tiled/FloatTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataType getType() {
            return type;
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Continuation<? super FloatTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Function1<? super InlineInt, Float> init, @NotNull Continuation<? super FloatTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, init, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Continuation<? super FloatTiledArray> $completion) {
            return this.invoke(new Strides(shape), $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Function1<? super InlineInt, Float> init, @NotNull Continuation<? super FloatTiledArray> $completion) {
            return this.invoke(new Strides(shape), init, $completion);
        }

        @NotNull
        public final FloatTiledArray invoke(@NotNull Strides strides, @NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            int countBlocks = array.length / blockSize;
            int n = 0;
            float[][] fArrayArray = new float[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                fArrayArray[n2] = new float[blockSize];
            }
            float[][] blocksArray = fArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((float[])array, (float[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new FloatTiledArray(blocksArray);
        }

        @Nullable
        public final Object invoke(int size, int blockSize, @NotNull Continuation<? super FloatTiledArray> $completion) {
            Object object;
            block6: {
                int blocksNum;
                block5: {
                    if (blockSize != 0 && !(size % blockSize == 0)) {
                        boolean $i$a$-require-FloatTiledArray$Companion$invoke$82 = false;
                        String $i$a$-require-FloatTiledArray$Companion$invoke$82 = "Size must divide blockSize";
                        throw new IllegalArgumentException($i$a$-require-FloatTiledArray$Companion$invoke$82.toString());
                    }
                    blocksNum = blockSize == 0 ? 0 : size / blockSize;
                    object = (AutoAllocatorContext)$completion.getContext().get((CoroutineContext.Key)AutoAllocatorContext.Key);
                    if (object == null) break block5;
                    float[][] fArray = FloatGetBlockFunctionsExtensionKt.getFloatBlock(object, blocksNum, blockSize);
                    object = fArray;
                    if (fArray != null) break block6;
                }
                int n = 0;
                float[][] fArrayArray = new float[blocksNum][];
                while (n < blocksNum) {
                    int n2 = n++;
                    fArrayArray[n2] = new float[blockSize];
                }
                object = fArrayArray;
            }
            Object blocks = object;
            return new FloatTiledArray((float[][])blocks);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object invoke(int var1_1, int var2_2, @NotNull Function1<? super InlineInt, Float> var3_3, @NotNull Continuation<? super FloatTiledArray> $completion) {
            if (!($completion instanceof invoke.8)) ** GOTO lbl-1000
            var13_5 = $completion;
            if ((var13_5.label & -2147483648) != 0) {
                var13_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    int I$0;
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(0, 0, null, (Continuation<? super FloatTiledArray>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = init;
                    $continuation.I$0 = blockSize;
                    $continuation.label = 1;
                    v0 = FloatTiledArray.Companion.invoke((int)size, blockSize, (Continuation<? super FloatTiledArray>)$continuation);
                    if (v0 == var14_7) {
                        return var14_7;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    blockSize = $continuation.I$0;
                    init = (Function1)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    tiledArray = (FloatTiledArray)v0;
                    count = 0;
                    var7_10 = tiledArray.getBlocks();
                    var9_12 = ((Object[])var7_10).length;
                    for (var8_11 = 0; var8_11 < var9_12; ++var8_11) {
                        block = var7_10[var8_11];
                        for (idx = 0; idx < blockSize; ++idx) {
                            block[idx] = ((Number)init.invoke((Object)InlineInt.box-impl(InlineInt.constructor-impl(count++)))).floatValue();
                        }
                    }
                    return tiledArray;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final FloatTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Float> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-FloatTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-FloatTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-FloatTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            float[][] fArrayArray = new float[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                fArrayArray[n2] = new float[blockSize];
            }
            float[][] blocks = fArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                float[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).floatValue();
                }
            }
            return new FloatTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

