/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.memory.contexts.AutoAllocatorContext;
import io.kinference.ndarray.arrays.memory.storage.LongGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.pointers.LongPointerKt;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import io.kinference.primitives.types.DataType;
import io.kinference.utils.inlines.InlineInt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0004J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001aH\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u0000J,\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u000b2\b\b\u0002\u0010\"\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000bJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000J\u0016\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\"\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006-"}, d2={"Lio/kinference/ndarray/arrays/tiled/LongTiledArray;", "", "blocks", "", "", "<init>", "([[J)V", "getBlocks", "()[[J", "[[J", "size", "", "getSize", "()I", "blockSize", "getBlockSize", "blocksNum", "getBlocksNum", "pointer", "Lio/kinference/ndarray/arrays/pointers/LongPointer;", "startIndex", "toArray", "indexFor", "Lkotlin/Pair;", "i", "get", "", "set", "", "value", "copyOf", "copyInto", "dest", "destOffset", "srcStart", "srcEnd", "plus", "other", "copyOfRange", "fromIndex", "toIndex", "fill", "from", "to", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nLongTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongTiledArray.kt\nio/kinference/ndarray/arrays/tiled/LongTiledArray\n+ 2 LongPointer.kt\nio/kinference/ndarray/arrays/pointers/LongPointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1052#2:189\n1054#2,30:191\n1052#2:221\n1054#2,30:223\n1#3:190\n1#3:222\n*S KotlinDebug\n*F\n+ 1 LongTiledArray.kt\nio/kinference/ndarray/arrays/tiled/LongTiledArray\n*L\n147#1:189\n147#1:191,30\n153#1:221\n153#1:223,30\n147#1:190\n153#1:222\n*E\n"})
public final class LongTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[][] blocks;
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private static final DataType type = DataType.LONG;

    public LongTiledArray(@NotNull long[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])this.blocks).length == 0 ? 0 : ((long[])ArraysKt.first((Object[])((Object[])this.blocks))).length;
        this.blocksNum = ((Object[])this.blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    @NotNull
    public final long[][] getBlocks() {
        return this.blocks;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final LongPointer pointer(int startIndex) {
        return new LongPointer(this, startIndex);
    }

    public static /* synthetic */ LongPointer pointer$default(LongTiledArray longTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return longTiledArray.pointer(n);
    }

    @NotNull
    public final long[] toArray() {
        if (this.size == 0) {
            return new long[0];
        }
        long[] array = new long[this.size];
        int offset = 0;
        long[][] lArray = this.blocks;
        int n = ((Object[])lArray).length;
        for (int i = 0; i < n; ++i) {
            long[] block = lArray[i];
            ArraysKt.copyInto$default((long[])block, (long[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final long get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, long value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final LongTiledArray copyOf() {
        int n = 0;
        int n2 = this.blocksNum;
        long[][] lArrayArray = new long[n2][];
        while (n < n2) {
            int n3 = n++;
            lArrayArray[n3] = new long[this.blockSize];
        }
        long[][] copyBlocks = lArrayArray;
        n2 = this.blocksNum;
        for (int blockNum = 0; blockNum < n2; ++blockNum) {
            long[] thisBlock = this.blocks[blockNum];
            long[] destBlock = copyBlocks[blockNum];
            ArraysKt.copyInto$default((long[])thisBlock, (long[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return new LongTiledArray(copyBlocks);
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull LongTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        LongPointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        LongPointer thisPtr = new LongPointer(this, srcStart);
        LongPointer longPointer = destPtr = new LongPointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!LongPointerKt.isCompatibleBySize((LongPointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-LongPointerKt$accept$4$iv22 = false;
            String $i$a$-require-LongPointerKt$accept$4$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-LongPointerKt$accept$4$iv22.toString());
        }
        if (LongPointerKt.isCompatibleWith((LongPointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            long[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                long[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    long cfr_ignored_0 = dstBlock$iv[index$iv];
                    long l = srcBlock$iv[index$iv];
                    int n2 = index$iv++;
                    long[] lArray = dstBlock$iv;
                    boolean bl = false;
                    void var22_26 = src;
                    lArray[n2] = var22_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                long src = thisPtr.getAndIncrement();
                void var19_23 = $this$accept$iv;
                boolean bl = false;
                long l = src;
                var19_23.set(l);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(LongTiledArray longTiledArray, LongTiledArray longTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = longTiledArray.size;
        }
        longTiledArray.copyInto(longTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LongTiledArray plus(@NotNull LongTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LongPointer thisPtr = new LongPointer(this, 0, 2, null);
        LongPointer destPtr = new LongPointer(other, 0, 2, null);
        LongPointer longPointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!LongPointerKt.isCompatibleBySize((LongPointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-LongPointerKt$accept$4$iv22 = false;
            String $i$a$-require-LongPointerKt$accept$4$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-LongPointerKt$accept$4$iv22.toString());
        }
        if (LongPointerKt.isCompatibleWith((LongPointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            long[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                long[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    long l = srcBlock$iv[index$iv];
                    long l2 = dstBlock$iv[index$iv];
                    int n2 = index$iv++;
                    long[] lArray = dstBlock$iv;
                    boolean bl = false;
                    void var21_25 = src + dst;
                    lArray[n2] = var21_25;
                }
            }
        } else {
            while (end$iv > 0) {
                long dst = destPtr.getAndIncrement();
                long src = $this$accept$iv.get();
                void var18_22 = $this$accept$iv;
                boolean bl = false;
                long l = src + dst;
                var18_22.set(l);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final long[] copyOfRange(int fromIndex, int toIndex) {
        long[] array = new long[toIndex - fromIndex];
        LongPointer pointer = new LongPointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(long value, int from, int to) {
        if (from == to) {
            return;
        }
        LongPointer pointer = new LongPointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            long[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((long[])block, (long)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(LongTiledArray longTiledArray, long l, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = longTiledArray.size;
        }
        longTiledArray.fill(l, n, n2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086B\u00a2\u0006\u0002\u0010\fJ*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086B\u00a2\u0006\u0002\u0010\u0014J*\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0086B\u00a2\u0006\u0002\u0010\u001bJ2\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/kinference/ndarray/arrays/tiled/LongTiledArray$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "invoke", "Lio/kinference/ndarray/arrays/tiled/LongTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "init", "Lkotlin/Function1;", "Lio/kinference/utils/inlines/InlineInt;", "", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shape", "", "([ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([ILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "array", "", "size", "", "blockSize", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(IILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nLongTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongTiledArray.kt\nio/kinference/ndarray/arrays/tiled/LongTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataType getType() {
            return type;
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Continuation<? super LongTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Function1<? super InlineInt, Long> init, @NotNull Continuation<? super LongTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, init, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Continuation<? super LongTiledArray> $completion) {
            return this.invoke(new Strides(shape), $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Function1<? super InlineInt, Long> init, @NotNull Continuation<? super LongTiledArray> $completion) {
            return this.invoke(new Strides(shape), init, $completion);
        }

        @NotNull
        public final LongTiledArray invoke(@NotNull Strides strides, @NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            int countBlocks = array.length / blockSize;
            int n = 0;
            long[][] lArrayArray = new long[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                lArrayArray[n2] = new long[blockSize];
            }
            long[][] blocksArray = lArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((long[])array, (long[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new LongTiledArray(blocksArray);
        }

        @Nullable
        public final Object invoke(int size, int blockSize, @NotNull Continuation<? super LongTiledArray> $completion) {
            Object object;
            block6: {
                int blocksNum;
                block5: {
                    if (blockSize != 0 && !(size % blockSize == 0)) {
                        boolean $i$a$-require-LongTiledArray$Companion$invoke$82 = false;
                        String $i$a$-require-LongTiledArray$Companion$invoke$82 = "Size must divide blockSize";
                        throw new IllegalArgumentException($i$a$-require-LongTiledArray$Companion$invoke$82.toString());
                    }
                    blocksNum = blockSize == 0 ? 0 : size / blockSize;
                    object = (AutoAllocatorContext)$completion.getContext().get((CoroutineContext.Key)AutoAllocatorContext.Key);
                    if (object == null) break block5;
                    long[][] lArray = LongGetBlockFunctionsExtensionKt.getLongBlock(object, blocksNum, blockSize);
                    object = lArray;
                    if (lArray != null) break block6;
                }
                int n = 0;
                long[][] lArrayArray = new long[blocksNum][];
                while (n < blocksNum) {
                    int n2 = n++;
                    lArrayArray[n2] = new long[blockSize];
                }
                object = lArrayArray;
            }
            Object blocks = object;
            return new LongTiledArray((long[][])blocks);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object invoke(int var1_1, int var2_2, @NotNull Function1<? super InlineInt, Long> var3_3, @NotNull Continuation<? super LongTiledArray> $completion) {
            if (!($completion instanceof invoke.8)) ** GOTO lbl-1000
            var13_5 = $completion;
            if ((var13_5.label & -2147483648) != 0) {
                var13_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    int I$0;
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(0, 0, null, (Continuation<? super LongTiledArray>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = init;
                    $continuation.I$0 = blockSize;
                    $continuation.label = 1;
                    v0 = LongTiledArray.Companion.invoke((int)size, blockSize, (Continuation<? super LongTiledArray>)$continuation);
                    if (v0 == var14_7) {
                        return var14_7;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    blockSize = $continuation.I$0;
                    init = (Function1)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    tiledArray = (LongTiledArray)v0;
                    count = 0;
                    var7_10 = tiledArray.getBlocks();
                    var9_12 = ((Object[])var7_10).length;
                    for (var8_11 = 0; var8_11 < var9_12; ++var8_11) {
                        block = var7_10[var8_11];
                        for (idx = 0; idx < blockSize; ++idx) {
                            block[idx] = ((Number)init.invoke((Object)InlineInt.box-impl(InlineInt.constructor-impl(count++)))).longValue();
                        }
                    }
                    return tiledArray;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final LongTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Long> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-LongTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-LongTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-LongTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            long[][] lArrayArray = new long[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                lArrayArray[n2] = new long[blockSize];
            }
            long[][] blocks = lArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                long[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).longValue();
                }
            }
            return new LongTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

