/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.gelu;

import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArrayCore;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.ndarray.extensions.gelu.BiasGeluDoubleKt;
import io.kinference.ndarray.extensions.gelu.BiasGeluFloatKt;
import io.kinference.primitives.types.DataType;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"biasGelu", "Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;", "input", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "bias", "(Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dest", "(Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ndarray-core"})
public final class BiasGeluKt {
    @Nullable
    public static final Object biasGelu(@NotNull NumberNDArrayCore input, @NotNull NumberNDArrayCore bias, @NotNull Continuation<? super MutableNumberNDArrayCore> $completion) {
        MutableNumberNDArrayCore mutableNumberNDArrayCore;
        if (!(input.getType() == bias.getType())) {
            boolean $i$a$-require-BiasGeluKt$biasGelu$42 = false;
            String $i$a$-require-BiasGeluKt$biasGelu$42 = "Input and Bias types should be equal, actual input type is " + input.getType() + ", actual bias type is " + bias.getType();
            throw new IllegalArgumentException($i$a$-require-BiasGeluKt$biasGelu$42.toString());
        }
        if (!(input.getType() == DataType.FLOAT || input.getType() == DataType.DOUBLE)) {
            boolean bl = false;
            String string = "BiasGelu operation supported only for FLOAT and DOUBLE tensors, actual types is " + input.getType();
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[input.getType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                FloatNDArray floatNDArray = (FloatNDArray)input;
                Intrinsics.checkNotNull((Object)bias, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                Object object = BiasGeluFloatKt.computeGeluFloat(floatNDArray, (FloatNDArray)bias, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                DoubleNDArray doubleNDArray = (DoubleNDArray)input;
                Intrinsics.checkNotNull((Object)bias, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                Object object = BiasGeluDoubleKt.computeGeluDouble(doubleNDArray, (DoubleNDArray)bias, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            default: {
                throw new IllegalStateException(("BiasGelu operation supported only for FLOAT and DOUBLE tensors, actual types is " + input.getType()).toString());
            }
        }
        return mutableNumberNDArrayCore;
    }

    @Nullable
    public static final Object biasGelu(@NotNull NumberNDArrayCore input, @NotNull NumberNDArrayCore bias, @NotNull MutableNumberNDArrayCore dest, @NotNull Continuation<? super MutableNumberNDArrayCore> $completion) {
        MutableNumberNDArrayCore mutableNumberNDArrayCore;
        if (!(input.getType() == bias.getType())) {
            boolean $i$a$-require-BiasGeluKt$biasGelu$72 = false;
            String $i$a$-require-BiasGeluKt$biasGelu$72 = "Input and Bias types should be equal, actual input type is " + input.getType() + ", actual bias type is " + bias.getType();
            throw new IllegalArgumentException($i$a$-require-BiasGeluKt$biasGelu$72.toString());
        }
        if (!(input.getType() == DataType.FLOAT || input.getType() == DataType.DOUBLE)) {
            boolean bl = false;
            String string = "BiasGelu operation supported only for FLOAT and DOUBLE tensors, actual types is " + input.getType();
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[input.getType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                FloatNDArray floatNDArray = (FloatNDArray)input;
                Intrinsics.checkNotNull((Object)bias, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                FloatNDArray floatNDArray2 = (FloatNDArray)bias;
                Intrinsics.checkNotNull((Object)dest, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableFloatNDArray");
                Object object = BiasGeluFloatKt.computeGeluFloat(floatNDArray, floatNDArray2, (MutableFloatNDArray)dest, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                DoubleNDArray doubleNDArray = (DoubleNDArray)input;
                Intrinsics.checkNotNull((Object)bias, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                DoubleNDArray doubleNDArray2 = (DoubleNDArray)bias;
                Intrinsics.checkNotNull((Object)dest, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableDoubleNDArray");
                Object object = BiasGeluDoubleKt.computeGeluDouble(doubleNDArray, doubleNDArray2, (MutableDoubleNDArray)dest, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            default: {
                throw new IllegalStateException(("BiasGelu operation supported only for FLOAT and DOUBLE tensors, actual types is " + input.getType()).toString());
            }
        }
        return mutableNumberNDArrayCore;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.FLOAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DOUBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

