/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.sign;

import io.kinference.ndarray.arrays.PrimitiveNDArray;
import io.kinference.ndarray.extensions.PrimitiveElementWiseKt;
import io.kinference.ndarray.extensions.constants.PrimitiveConstants;
import io.kinference.ndarray.stubs.PrimitiveTypeStubsKt;
import io.kinference.primitives.annotations.FilterPrimitives;
import io.kinference.primitives.annotations.GenerateNameFromPrimitives;
import io.kinference.primitives.annotations.GeneratePrimitives;
import io.kinference.primitives.annotations.SpecifyPrimitives;
import io.kinference.primitives.types.DataType;
import io.kinference.primitives.types.PrimitiveType;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GeneratePrimitives(types={DataType.NUMBER})
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0003\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0081@\u00a2\u0006\u0002\u0010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0081@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"signNotNaNPrimitive", "Lio/kinference/primitives/types/PrimitiveType;", "x", "signIntegerPrimitive", "Lio/kinference/ndarray/arrays/PrimitiveNDArray;", "array", "(Lio/kinference/ndarray/arrays/PrimitiveNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "signFPPrimitive", "ndarray-core"})
public final class SignPrimitiveKt {
    @GenerateNameFromPrimitives
    private static final PrimitiveType signNotNaNPrimitive(PrimitiveType x) {
        PrimitiveType primitiveType;
        if (x.compareTo(PrimitiveConstants.INSTANCE.getZERO()) > 0) {
            primitiveType = PrimitiveConstants.INSTANCE.getONE();
        } else if (Intrinsics.areEqual((Object)x, (Object)PrimitiveConstants.INSTANCE.getZERO())) {
            primitiveType = PrimitiveConstants.INSTANCE.getZERO();
        } else if (x.compareTo(PrimitiveConstants.INSTANCE.getZERO()) < 0) {
            primitiveType = PrimitiveConstants.INSTANCE.getMINUS_ONE();
        } else {
            throw new IllegalStateException("This branch should be unreachable".toString());
        }
        return primitiveType;
    }

    @GenerateNameFromPrimitives
    @FilterPrimitives(exclude={DataType.FLOAT, DataType.DOUBLE})
    @Nullable
    public static final Object signIntegerPrimitive(@NotNull PrimitiveNDArray array, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveElementWiseKt.applyElementWise(array, (Function1<? super PrimitiveType, ? extends PrimitiveType>)((Function1)SignPrimitiveKt::signIntegerPrimitive$lambda$0), $completion);
    }

    @GenerateNameFromPrimitives
    @SpecifyPrimitives(include={DataType.FLOAT, DataType.DOUBLE})
    @Nullable
    public static final Object signFPPrimitive(@NotNull PrimitiveNDArray array, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveElementWiseKt.applyElementWise(array, (Function1<? super PrimitiveType, ? extends PrimitiveType>)((Function1)SignPrimitiveKt::signFPPrimitive$lambda$1), $completion);
    }

    private static final PrimitiveType signIntegerPrimitive$lambda$0(PrimitiveType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SignPrimitiveKt.signNotNaNPrimitive(it);
    }

    private static final PrimitiveType signFPPrimitive$lambda$1(PrimitiveType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PrimitiveTypeStubsKt.isNaN(it) ? PrimitiveConstants.INSTANCE.getZERO() : SignPrimitiveKt.signNotNaNPrimitive(it);
    }
}

