/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.CustomPropertyDefinitionProvider;
import com.github.victools.jsonschema.generator.InstanceAttributeOverride;
import com.github.victools.jsonschema.generator.InstanceAttributeOverrideV2;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorTypeConfigPart;
import com.github.victools.jsonschema.generator.StatefulConfig;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaGeneratorConfigPart<M extends MemberScope<?, ?>>
extends SchemaGeneratorTypeConfigPart<M> {
    private final List<CustomPropertyDefinitionProvider<M>> customDefinitionProviders = new ArrayList<CustomPropertyDefinitionProvider<M>>();
    private final List<InstanceAttributeOverrideV2<M>> instanceAttributeOverrides = new ArrayList<InstanceAttributeOverrideV2<M>>();
    private final List<Predicate<M>> ignoreChecks = new ArrayList<Predicate<M>>();
    private final List<Predicate<M>> requiredChecks = new ArrayList<Predicate<M>>();
    private final List<Predicate<M>> readOnlyChecks = new ArrayList<Predicate<M>>();
    private final List<Predicate<M>> writeOnlyChecks = new ArrayList<Predicate<M>>();
    private final List<ConfigFunction<M, Boolean>> nullableChecks = new ArrayList<ConfigFunction<M, Boolean>>();
    private final List<ConfigFunction<M, List<String>>> dependentRequiresResolvers = new ArrayList<ConfigFunction<M, List<String>>>();
    private final List<ConfigFunction<M, List<ResolvedType>>> targetTypeOverridesResolvers = new ArrayList<ConfigFunction<M, List<ResolvedType>>>();
    private final List<ConfigFunction<M, String>> propertyNameOverrideResolvers = new ArrayList<ConfigFunction<M, String>>();

    public SchemaGeneratorConfigPart<M> withCustomDefinitionProvider(CustomPropertyDefinitionProvider<M> definitionProvider) {
        this.customDefinitionProviders.add(definitionProvider);
        return this;
    }

    public List<CustomPropertyDefinitionProvider<M>> getCustomDefinitionProviders() {
        return Collections.unmodifiableList(this.customDefinitionProviders);
    }

    @Deprecated
    public SchemaGeneratorConfigPart<M> withInstanceAttributeOverride(InstanceAttributeOverride<M> override) {
        return this.withInstanceAttributeOverride((InstanceAttributeOverrideV2<M>)override);
    }

    public SchemaGeneratorConfigPart<M> withInstanceAttributeOverride(InstanceAttributeOverrideV2<M> override) {
        this.instanceAttributeOverrides.add(override);
        return this;
    }

    public List<InstanceAttributeOverrideV2<M>> getInstanceAttributeOverrides() {
        return Collections.unmodifiableList(this.instanceAttributeOverrides);
    }

    public SchemaGeneratorConfigPart<M> withIgnoreCheck(Predicate<M> check2) {
        this.ignoreChecks.add(check2);
        return this;
    }

    public boolean shouldIgnore(M member) {
        return this.ignoreChecks.stream().anyMatch(check2 -> check2.test(member));
    }

    public SchemaGeneratorConfigPart<M> withRequiredCheck(Predicate<M> check2) {
        this.requiredChecks.add(check2);
        return this;
    }

    public boolean isRequired(M member) {
        return this.requiredChecks.stream().anyMatch(check2 -> check2.test(member));
    }

    public SchemaGeneratorConfigPart<M> withReadOnlyCheck(Predicate<M> check2) {
        this.readOnlyChecks.add(check2);
        return this;
    }

    public boolean isReadOnly(M member) {
        return this.readOnlyChecks.stream().anyMatch(check2 -> check2.test(member));
    }

    public SchemaGeneratorConfigPart<M> withWriteOnlyCheck(Predicate<M> check2) {
        this.writeOnlyChecks.add(check2);
        return this;
    }

    public boolean isWriteOnly(M member) {
        return this.writeOnlyChecks.stream().anyMatch(check2 -> check2.test(member));
    }

    public SchemaGeneratorConfigPart<M> withNullableCheck(ConfigFunction<M, Boolean> check2) {
        this.nullableChecks.add(check2);
        return this;
    }

    public Boolean isNullable(M member) {
        Set result = this.nullableChecks.stream().map(check2 -> (Boolean)check2.apply(member)).filter(Objects::nonNull).collect(Collectors.toSet());
        return result.isEmpty() ? null : Boolean.valueOf(result.stream().anyMatch(value -> value));
    }

    public SchemaGeneratorConfigPart<M> withDependentRequiresResolver(ConfigFunction<M, List<String>> resolver) {
        this.dependentRequiresResolvers.add(resolver);
        return this;
    }

    public List<String> resolveDependentRequires(M member) {
        return this.dependentRequiresResolvers.stream().map(resolver -> (List)resolver.apply(member)).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Deprecated
    public SchemaGeneratorConfigPart<M> withTargetTypeOverrideResolver(ConfigFunction<M, ResolvedType> resolver) {
        this.targetTypeOverridesResolvers.add(member -> Optional.ofNullable((ResolvedType)resolver.apply(member)).map(Collections::singletonList).orElse(null));
        return this;
    }

    public SchemaGeneratorConfigPart<M> withTargetTypeOverridesResolver(ConfigFunction<M, List<ResolvedType>> resolver) {
        this.targetTypeOverridesResolvers.add(resolver);
        return this;
    }

    public List<ResolvedType> resolveTargetTypeOverrides(M member) {
        return (List)SchemaGeneratorConfigPart.getFirstDefinedValue(this.targetTypeOverridesResolvers, member);
    }

    public SchemaGeneratorConfigPart<M> withPropertyNameOverrideResolver(ConfigFunction<M, String> resolver) {
        this.propertyNameOverrideResolvers.add(resolver);
        return this;
    }

    public String resolvePropertyNameOverride(M member) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.propertyNameOverrideResolvers, member);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withTitleResolver(ConfigFunction<M, String> resolver) {
        return (SchemaGeneratorConfigPart)super.withTitleResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withDescriptionResolver(ConfigFunction<M, String> resolver) {
        return (SchemaGeneratorConfigPart)super.withDescriptionResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withDefaultResolver(ConfigFunction<M, Object> resolver) {
        return (SchemaGeneratorConfigPart)super.withDefaultResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withEnumResolver(ConfigFunction<M, Collection<?>> resolver) {
        return (SchemaGeneratorConfigPart)super.withEnumResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withAdditionalPropertiesResolver(ConfigFunction<M, Type> resolver) {
        return (SchemaGeneratorConfigPart)super.withAdditionalPropertiesResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withAdditionalPropertiesResolver(BiFunction<M, SchemaGenerationContext, JsonNode> resolver) {
        return (SchemaGeneratorConfigPart)super.withAdditionalPropertiesResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withPatternPropertiesResolver(ConfigFunction<M, Map<String, Type>> resolver) {
        return (SchemaGeneratorConfigPart)super.withPatternPropertiesResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withPatternPropertiesResolver(BiFunction<M, SchemaGenerationContext, Map<String, JsonNode>> resolver) {
        return (SchemaGeneratorConfigPart)super.withPatternPropertiesResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withStringMinLengthResolver(ConfigFunction<M, Integer> resolver) {
        return (SchemaGeneratorConfigPart)super.withStringMinLengthResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withStringMaxLengthResolver(ConfigFunction<M, Integer> resolver) {
        return (SchemaGeneratorConfigPart)super.withStringMaxLengthResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withStringFormatResolver(ConfigFunction<M, String> resolver) {
        return (SchemaGeneratorConfigPart)super.withStringFormatResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withStringPatternResolver(ConfigFunction<M, String> resolver) {
        return (SchemaGeneratorConfigPart)super.withStringPatternResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withNumberInclusiveMinimumResolver(ConfigFunction<M, BigDecimal> resolver) {
        return (SchemaGeneratorConfigPart)super.withNumberInclusiveMinimumResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withNumberExclusiveMinimumResolver(ConfigFunction<M, BigDecimal> resolver) {
        return (SchemaGeneratorConfigPart)super.withNumberExclusiveMinimumResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withNumberInclusiveMaximumResolver(ConfigFunction<M, BigDecimal> resolver) {
        return (SchemaGeneratorConfigPart)super.withNumberInclusiveMaximumResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withNumberExclusiveMaximumResolver(ConfigFunction<M, BigDecimal> resolver) {
        return (SchemaGeneratorConfigPart)super.withNumberExclusiveMaximumResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withNumberMultipleOfResolver(ConfigFunction<M, BigDecimal> resolver) {
        return (SchemaGeneratorConfigPart)super.withNumberMultipleOfResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withArrayMinItemsResolver(ConfigFunction<M, Integer> resolver) {
        return (SchemaGeneratorConfigPart)super.withArrayMinItemsResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withArrayMaxItemsResolver(ConfigFunction<M, Integer> resolver) {
        return (SchemaGeneratorConfigPart)super.withArrayMaxItemsResolver(resolver);
    }

    @Override
    public SchemaGeneratorConfigPart<M> withArrayUniqueItemsResolver(ConfigFunction<M, Boolean> resolver) {
        return (SchemaGeneratorConfigPart)super.withArrayUniqueItemsResolver(resolver);
    }

    @Override
    public void resetAfterSchemaGenerationFinished() {
        super.resetAfterSchemaGenerationFinished();
        Stream.of(this.customDefinitionProviders, this.instanceAttributeOverrides, this.nullableChecks, this.dependentRequiresResolvers, this.targetTypeOverridesResolvers, this.propertyNameOverrideResolvers).flatMap(Collection::stream).forEach(StatefulConfig::resetAfterSchemaGenerationFinished);
    }
}

