/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui;

import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.codeWithMe.ClientId;
import com.intellij.llmInstaller.UtilsKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.activation.presentation.AiaScreenManager;
import com.intellij.ml.llm.activation.presentation.navigation.AiaNavDestination;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiProJbaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.JbaiActivation;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.core.AIAssistantAllowedLevelService;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIAssistantKillSwitch;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.ExpiryTimeDisplayData;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.core.chat.ui.QuotaExpiryData;
import com.intellij.ml.llm.core.chat.ui.QuotaRefillData;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeData;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeDisplayData;
import com.intellij.ml.llm.core.chat.ui.RefillTimeDisplayData;
import com.intellij.ml.llm.core.chat.ui.RemainedQuotasInfo;
import com.intellij.ml.llm.core.chat.ui.UnknownQuotaTimeData;
import com.intellij.ml.llm.core.error.ErrorManager;
import com.intellij.ml.llm.core.error.ErrorState;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.ml.llm.core.quota.QuotaRefillInfo;
import com.intellij.ml.llm.core.settings.LLMConfigurable;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsManager;
import com.intellij.ml.llm.core.settings.LLMSettingsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ApplicationKt;
import com.intellij.util.IconUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u0012J\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0012J\u0006\u0010)\u001a\u00020\u0012J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010/\u001a\u00020\u0012J\u0006\u00100\u001a\u00020\u0012J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0010\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106J\r\u00107\u001a\u0004\u0018\u000102\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0012J\u000e\u0010;\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0015\u0010<\u001a\u00070\u0007\u00a2\u0006\u0002\b=2\b\u0010>\u001a\u0004\u0018\u00010?J\u0016\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BJ\u0010\u0010D\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010BJ\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010M\u001a\u000202J\u000b\u0010N\u001a\u00070\u0007\u00a2\u0006\u0002\bOJ\n\u0010P\u001a\u0004\u0018\u00010QH\u0007J\u0012\u0010R\u001a\u00020\u00072\b\u0010S\u001a\u0004\u0018\u00010QH\u0007J\u0017\u0010T\u001a\u0004\u0018\u0001022\u0006\u0010U\u001a\u00020?H\u0002\u00a2\u0006\u0002\u0010VJ\b\u0010`\u001a\u00020aH\u0002J\u0006\u0010b\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010W\u001a\u0004\u0018\u00010X8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\"\u0010]\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b^\u0010\u0014\"\u0004\b_\u0010\u0016R\u0010\u0010c\u001a\u00020\u00078\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0011\u0010d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u0010\u0010f\u001a\u00020\u00078\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0011\u0010g\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bg\u0010e\u00a8\u0006h"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/AIAssistantUIUtil;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "AI_ASSISTANT_SNIPPET_FILE_BASE_NAME", "", "AI_ASSISTANT_INPUT_FILE_NAME_PREFIX", "EDITOR_EX_PROPERTY", "MANAGE_ACCOUNT_HREF", "AVAILABLE_SUBSCRIPTION_WITH_ORGANIZATION_HREF", "ADD_PERSONAL_TOP_UP_CREDITS_HREF", "ABOUT_TOP_UP_CREDITS_HREF", "AI_HUB_GROUP", "AI_HUB_REFRESH_LICENSE_ACTION", "DO_NOT_UPDATE_FONT", "testChinaRegion", "", "getTestChinaRegion", "()Ljava/lang/Boolean;", "setTestChinaRegion", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "creditsFormatter", "Ljava/text/DecimalFormat;", "isAIAssistantChatSnippet", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAIAssistantInputFile", "isAIAssistantFile", "isAIAssistantActivationIncomplete", "openLlmSettingsDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "isAssistantActive", "hasAvailableLlmProfileId", "promptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "hasAvailableChatProfileId", "isChinaRegion", "getAssistantActiveState", "Lkotlinx/coroutines/flow/StateFlow;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "isActiveButMaybeOutOfPrompts", "isCodexOAuthAuthenticated", "isAcpAgentAdded", "getEndsInQuotaDays", "", "getRemainedTariffQuotasInfo", "Lcom/intellij/ml/llm/core/chat/ui/RemainedQuotasInfo;", "quota", "Lcom/intellij/ml/llm/core/quota/QuotaInfo$SuccessfulQuotaInfo;", "getLicenseEndsInDays", "()Ljava/lang/Integer;", "setAIEnabled", "turnedOn", "showLicensePickerView", "getRefillInDays", "Lorg/jetbrains/annotations/Nls;", "quotaRefill", "Lkotlinx/datetime/Instant;", "percentage", "value", "Ljava/math/BigDecimal;", "maximum", "quotaToCreditString", "getScaledAIAssistantIcon", "Ljavax/swing/Icon;", "scaleFactor", "", "getMessageDialogIcon", "component", "Ljavax/swing/JComponent;", "isAuthedAndAllowed", "getToolwindowScaledFontSize", "getSendingRequestBackgroundTitle", "Lcom/intellij/openapi/util/NlsSafe;", "getQuotaTimeData", "Lcom/intellij/ml/llm/core/chat/ui/QuotaTimeData;", "formatQuotaInfoLabel", "quotaTimeData", "getRemainedHours", "instant", "(Lkotlinx/datetime/Instant;)Ljava/lang/Integer;", "testLicenseType", "Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "getTestLicenseType$intellij_ml_llm_core", "()Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "setTestLicenseType$intellij_ml_llm_core", "(Lcom/intellij/ml/llm/core/chat/ui/LicenseType;)V", "testLicensePersonal", "getTestLicensePersonal", "setTestLicensePersonal", "getQuotaTimeDisplayData", "Lcom/intellij/ml/llm/core/chat/ui/QuotaTimeDisplayData;", "isAskAIModeEnabled", "LLM_SUPPORT_18910_KEY", "isSupportLlm18910", "()Z", "LLM_SUPPORT_18911_KEY", "isSupportLlm18911", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIAssistantUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantUIUtil.kt\ncom/intellij/ml/llm/core/chat/ui/AIAssistantUIUtil\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,618:1\n42#2,3:619\n42#2,3:622\n42#2,3:625\n42#2,3:634\n30#3,2:628\n30#3,2:630\n30#3,2:632\n1#4:637\n13#5:638\n*S KotlinDebug\n*F\n+ 1 AIAssistantUIUtil.kt\ncom/intellij/ml/llm/core/chat/ui/AIAssistantUIUtil\n*L\n129#1:619,3\n137#1:622,3\n145#1:625,3\n288#1:634,3\n157#1:628,2\n234#1:630,2\n284#1:632,2\n79#1:638\n*E\n"})
public final class AIAssistantUIUtil {
    @NotNull
    public static final AIAssistantUIUtil INSTANCE = new AIAssistantUIUtil();
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String AI_ASSISTANT_SNIPPET_FILE_BASE_NAME = "AIAssistantSnippet";
    @NotNull
    public static final String AI_ASSISTANT_INPUT_FILE_NAME_PREFIX = "AIAssistantInput";
    @NotNull
    public static final String EDITOR_EX_PROPERTY = "EditorEx";
    @NotNull
    public static final String MANAGE_ACCOUNT_HREF = "https://jb.gg/aimanage";
    @NotNull
    public static final String AVAILABLE_SUBSCRIPTION_WITH_ORGANIZATION_HREF = "https://jb.gg/available-subscription-options-with-organizational-jetbrains-account";
    @NotNull
    public static final String ADD_PERSONAL_TOP_UP_CREDITS_HREF = "https://jetbrains.com/shop/buy?item=P:N:AIGC";
    @NotNull
    public static final String ABOUT_TOP_UP_CREDITS_HREF = "https://www.jetbrains.com/help/ai-assistant/licensing-and-subscriptions.html#top-up-ai-credits-faq";
    @NotNull
    public static final String AI_HUB_GROUP = "AIHub.Installed";
    @NotNull
    public static final String AI_HUB_REFRESH_LICENSE_ACTION = "AIHub.RefreshLicense";
    @NotNull
    public static final String DO_NOT_UPDATE_FONT = "AIAssistant.DoNotUpdateFont";
    @ApiStatus.Internal
    @VisibleForTesting
    @Nullable
    private static Boolean testChinaRegion;
    @NotNull
    private static final DecimalFormat creditsFormatter;
    @ApiStatus.Internal
    @Nullable
    private static LicenseType testLicenseType;
    @ApiStatus.Internal
    @VisibleForTesting
    @Nullable
    private static Boolean testLicensePersonal;
    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static final String LLM_SUPPORT_18910_KEY = "llm.support.llm.18910";
    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static final String LLM_SUPPORT_18911_KEY = "llm.support.llm.18911";

    private AIAssistantUIUtil() {
    }

    @Nullable
    public final Boolean getTestChinaRegion() {
        return testChinaRegion;
    }

    public final void setTestChinaRegion(@Nullable Boolean bl) {
        testChinaRegion = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAIAssistantChatSnippet(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof LightVirtualFile)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)AI_ASSISTANT_SNIPPET_FILE_BASE_NAME, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAIAssistantInputFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof LightVirtualFile)) return false;
        String string = ((LightVirtualFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)AI_ASSISTANT_INPUT_FILE_NAME_PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isAIAssistantFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isAIAssistantChatSnippet(file) || this.isAIAssistantInputFile(file);
    }

    public final boolean isAIAssistantActivationIncomplete() {
        AiaActivation activation2 = AiaActivationManager.Companion.currentActivation();
        return Outcome.isIncomplete-impl((Object)activation2.getOutcome-X8CKn68());
    }

    public final void openLlmSettingsDialog(@Nullable Project project) {
        ShowSettingsUtil.getInstance().showSettingsDialog(project, LLMConfigurable.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAssistantActive(@Nullable Project project) {
        if (!this.isAuthedAndAllowed(project)) return false;
        if ((Boolean)QuotaManager2.Companion.getInstance().getHasEnoughQuota().getValue() == false) return false;
        if (ErrorManager.Companion.getInstance().isAssistantInErrorState()) return false;
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (!((LlmProfileService)object).areRulesAndProfilesLoaded()) return false;
        return true;
    }

    public final boolean hasAvailableLlmProfileId(@NotNull LLMPromptID promptId) {
        Intrinsics.checkNotNullParameter((Object)promptId, (String)"promptId");
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LlmProfileService)object).getLlmProfileIdIfLoaded(promptId) != null;
    }

    public final boolean hasAvailableChatProfileId() {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean $i$f$service = false;
        Class<LlmProfileService> serviceClass$iv = LlmProfileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((LlmProfileService)object).getChatLlmProfileIdIfLoaded() != null;
    }

    public final boolean isChinaRegion() {
        Boolean bl = testChinaRegion;
        return bl != null ? bl : UtilsKt.isChinaRegion();
    }

    @NotNull
    public final StateFlow<Boolean> getAssistantActiveState(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AIAssistantAllowedLevelService> serviceClass$iv = AIAssistantAllowedLevelService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return FlowKt.stateIn((Flow)FlowKt.combine((Flow)((Flow)AiaActivationManager.Companion.getInstance().getActivationState()), (Flow)((Flow)((AIAssistantAllowedLevelService)object).getLevel()), (Flow)((Flow)QuotaManager2.Companion.getInstance().getQuotaInfo()), (Flow)((Flow)ErrorManager.Companion.getInstance().getErrorState()), (Function5)((Function5)new Function5<AiaActivation, AIAssistantKillSwitch.Level, QuotaInfo, ErrorState, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;
            /* synthetic */ Object L$3;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                AiaActivation aiaActivation = (AiaActivation)this.L$0;
                AIAssistantKillSwitch.Level level = (AIAssistantKillSwitch.Level)((Object)this.L$1);
                QuotaInfo quotaInfo = (QuotaInfo)this.L$2;
                ErrorState errorState = (ErrorState)((Object)this.L$3);
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void errorState2;
                        void quotaState;
                        void allowState;
                        void authState;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((Outcome.isComplete-impl((Object)authState.getOutcome-X8CKn68()) && allowState == AIAssistantKillSwitch.Level.Allowed && quotaState instanceof QuotaInfo.Available && errorState2 == ErrorState.None ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(AiaActivation p1, AIAssistantKillSwitch.Level p2, QuotaInfo p3, ErrorState p4, Continuation<? super Boolean> p5) {
                var var6_6 = new /* invalid duplicate definition of identical inner class */;
                var6_6.L$0 = p1;
                var6_6.L$1 = p2;
                var6_6.L$2 = p3;
                var6_6.L$3 = p4;
                return var6_6.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)false);
    }

    public final boolean isActiveButMaybeOutOfPrompts(@Nullable Project project) {
        return this.isAuthedAndAllowed(project);
    }

    public final boolean isCodexOAuthAuthenticated() {
        return Outcome.isComplete-impl((Object)AiaActivationManager.Companion.currentThirdPartyOAuthActivation().getOutcome-X8CKn68());
    }

    public final boolean isAcpAgentAdded() {
        return Outcome.isComplete-impl((Object)AiaActivationManager.Companion.currentAcpActivation().getOutcome-X8CKn68());
    }

    public final int getEndsInQuotaDays() {
        return this.getQuotaTimeDisplayData().getEndsInHours() / 24;
    }

    @NotNull
    public final RemainedQuotasInfo getRemainedTariffQuotasInfo() {
        return this.getRemainedTariffQuotasInfo((QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue());
    }

    @NotNull
    public final RemainedQuotasInfo getRemainedTariffQuotasInfo(@Nullable QuotaInfo.SuccessfulQuotaInfo quota) {
        QuotaTimeDisplayData quotaTimeDisplayData = this.getQuotaTimeDisplayData();
        int totalEndsInHours = quotaTimeDisplayData.getEndsInHours();
        int endsInDays = totalEndsInHours / 24;
        int endsInHours = totalEndsInHours % 24;
        Double available = null;
        Double maximum = null;
        if (this.isSupportLlm18910() && AIAssistantUIUtilKt.getLicenseType() != LicenseType.ENTERPRISE) {
            Double d;
            var8_8 = quota;
            if (var8_8 instanceof QuotaInfo.Available) {
                Object object = ((QuotaInfo.Available)quota).getTariffQuota();
                d = object != null && (object = ((QuotaInfo.QuotaDetails)object).getAvailable()) != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
            } else if (var8_8 instanceof QuotaInfo.Reached) {
                d = 0.0;
            } else {
                if (var8_8 == null) {
                    return new RemainedQuotasInfo(0, 0, 100);
                }
                throw new NoWhenBranchMatchedException();
            }
            available = d;
            Object object = quota.getTariffQuota();
            maximum = object != null && (object = ((QuotaInfo.QuotaDetails)object).getMaximum()) != null ? Double.valueOf(((BigDecimal)object).doubleValue()) : null;
        } else {
            double d;
            var8_8 = quota;
            if (var8_8 instanceof QuotaInfo.Available) {
                d = Math.max(0.0, ((QuotaInfo.Available)quota).getMaximum().doubleValue() - ((QuotaInfo.Available)quota).getCurrent().doubleValue());
            } else if (var8_8 instanceof QuotaInfo.Reached) {
                d = 0.0;
            } else {
                if (var8_8 == null) {
                    return new RemainedQuotasInfo(0, 0, 100);
                }
                throw new NoWhenBranchMatchedException();
            }
            available = d;
            maximum = quota.getMaximum().doubleValue();
        }
        if (available == null || maximum == null || Intrinsics.areEqual((Double)maximum, (double)0.0)) {
            return new RemainedQuotasInfo(endsInDays, endsInHours, 0);
        }
        int remainedPercents = (int)Math.ceil((double)100 * available / maximum);
        return new RemainedQuotasInfo(endsInDays, endsInHours, remainedPercents);
    }

    @Nullable
    public final Integer getLicenseEndsInDays() {
        JbaiActivation jbaiActivation = AiaActivationManager.Companion.currentJbaiActivation();
        AiProJbaActivation aiProJbaActivation = jbaiActivation instanceof AiProJbaActivation ? (AiProJbaActivation)jbaiActivation : null;
        if (aiProJbaActivation == null || (aiProJbaActivation = aiProJbaActivation.getActiveLicense()) == null) {
            return null;
        }
        AiProJbaActivation activeLicense = aiProJbaActivation;
        Integer n = this.getRemainedHours(activeLicense.getExpiresOn().plus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS)));
        if (n == null) {
            return 0;
        }
        int remainedHours = n;
        return remainedHours / 24 + 1;
    }

    public final void setAIEnabled(@NotNull Project project, boolean turnedOn) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LLMProjectSettingsManager.Companion.getInstance(project).setTurnedOn(turnedOn);
        LLMProjectSettingsManager.Companion.fireSettingsChanged(project);
    }

    public final void showLicensePickerView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AiaScreenManager> serviceClass$iv = AiaScreenManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        AiaScreenManager screenManager = (AiaScreenManager)object;
        screenManager.navigateTo(AiaNavDestination.AiaNavAipLicensePicker);
    }

    @NotNull
    public final String getRefillInDays(@Nullable Instant quotaRefill2) {
        if (quotaRefill2 == null) {
            log.info("quotaRefill is null");
            return LLMBundle.message("panel.chat.out.of.prompts.unknown", new Object[0]);
        }
        long remainedDays = Duration.getInWholeDays-impl((long)quotaRefill2.minus-5sfh64U(Clock.System.INSTANCE.now()));
        return String.valueOf(Math.max(0L, remainedDays));
    }

    public final int percentage(@NotNull BigDecimal value, @NotNull BigDecimal maximum) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)maximum, (String)"maximum");
        if (Intrinsics.areEqual((Object)maximum, (Object)BigDecimal.ZERO)) {
            return 100;
        }
        BigDecimal bigDecimal = value.multiply(new BigDecimal(100));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        BigDecimal bigDecimal2 = bigDecimal.divide(maximum, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"divide(...)");
        BigDecimal result2 = bigDecimal2;
        return RangesKt.coerceIn((int)result2.intValue(), (int)0, (int)100);
    }

    @NotNull
    public final String quotaToCreditString(@Nullable BigDecimal quota) {
        String string;
        BigDecimal bigDecimal = quota;
        if (bigDecimal == null) {
            string = "-";
        } else if (Intrinsics.areEqual((Object)bigDecimal, (Object)BigDecimal.ZERO)) {
            string = "0";
        } else {
            BigDecimal bigDecimal2 = quota.multiply(new BigDecimal(100));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"multiply(...)");
            BigDecimal bigDecimal3 = bigDecimal2;
            BigDecimal bigDecimal4 = bigDecimal3.divide(new BigDecimal(100000), RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"divide(...)");
            BigDecimal credits = bigDecimal4;
            String result2 = creditsFormatter.format(credits.movePointLeft(2));
            if (Intrinsics.areEqual((Object)result2, (Object)"0.00")) {
                string = "0.01";
            } else {
                Intrinsics.checkNotNull((Object)result2);
                string = result2;
            }
        }
        return string;
    }

    @NotNull
    public final Icon getScaledAIAssistantIcon(float scaleFactor) {
        return IconUtil.scale((Icon)AIAssistantBranding.Logo16Colored, null, (float)JBUIScale.scale((float)(scaleFactor / (float)AIAssistantBranding.Logo16Colored.getIconWidth())));
    }

    @NotNull
    public final Icon getMessageDialogIcon(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return IconUtil.scale((Icon)AIAssistantBranding.Logo16Colored, (Component)component, (float)JBUIScale.scale((float)(28.0f / (float)AIAssistantBranding.Logo16Colored.getIconWidth())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAuthedAndAllowed(@Nullable Project project) {
        if (!Outcome.isComplete-impl((Object)AiaActivationManager.Companion.currentActivation().getOutcome-X8CKn68())) return false;
        if (project == null) return false;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AIAssistantAllowedLevelService> serviceClass$iv = AIAssistantAllowedLevelService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((AIAssistantAllowedLevelService)object).getLevel().getValue() != AIAssistantKillSwitch.Level.Allowed) return false;
        return true;
    }

    public final int getToolwindowScaledFontSize() {
        boolean $i$f$service = false;
        Class<LLMSettingsManager> serviceClass$iv = LLMSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return MathKt.roundToInt((float)(JBFont.label().getSize2D() * ((LLMSettingsManager)object).getToolwindowFontScale()));
    }

    @NotNull
    public final String getSendingRequestBackgroundTitle() {
        return LLMBundle.message("sending.request.background.process.title", new Object[0]);
    }

    @ApiStatus.Internal
    @Nullable
    public final QuotaTimeData getQuotaTimeData() {
        QuotaInfo.SuccessfulQuotaInfo quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        QuotaRefillInfo.Known refill = (QuotaRefillInfo.Known)QuotaManager2.Companion.getInstance().getLastAvailableNextRefill().getValue();
        QuotaRefillInfo.Known known = refill;
        if (known != null && (known = known.getNext()) != null) {
            QuotaRefillInfo.Known it = known;
            boolean bl = false;
            log.info("returning next refill " + (Instant)it);
            return new QuotaRefillData(refill.getNext());
        }
        QuotaInfo.SuccessfulQuotaInfo successfulQuotaInfo = quota;
        if (successfulQuotaInfo != null && (successfulQuotaInfo = successfulQuotaInfo.getUntil()) != null) {
            QuotaInfo.SuccessfulQuotaInfo it = successfulQuotaInfo;
            boolean bl = false;
            log.info("returning quota " + (Instant)it + ", because refill: " + refill);
            return new QuotaExpiryData((Instant)it);
        }
        log.warn("quota and refill values are returned as null by platform, refill: " + refill + ", quota: " + quota);
        return null;
    }

    @Nls
    @NotNull
    public final String formatQuotaInfoLabel(@Nullable QuotaTimeData quotaTimeData) {
        String string;
        if (quotaTimeData == null) {
            return LLMBundle.message("ai.hub.quota.info.not.available", new Object[0]);
        }
        Date endsInQuotaDate = Date.from(ConvertersKt.toJavaInstant((Instant)quotaTimeData.getEndsIn()));
        String string2 = DateFormatUtil.formatDateTime((Date)endsInQuotaDate);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDateTime(...)");
        String endsInQuotaString = string2;
        QuotaTimeData quotaTimeData2 = quotaTimeData;
        if (quotaTimeData2 instanceof QuotaRefillData) {
            Object[] objectArray = new Object[]{endsInQuotaString};
            string = LLMBundle.message("ai.hub.quota.renew", objectArray);
        } else if (quotaTimeData2 instanceof QuotaExpiryData) {
            Object[] objectArray = new Object[]{endsInQuotaString};
            string = LLMBundle.message("ai.hub.quota.expires", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Integer getRemainedHours(Instant instant) {
        long delta = instant.minus-5sfh64U(Clock.System.INSTANCE.now());
        return Duration.isNegative-impl((long)delta) ? null : Integer.valueOf((int)Duration.getInWholeHours-impl((long)delta));
    }

    @Nullable
    public final LicenseType getTestLicenseType$intellij_ml_llm_core() {
        return testLicenseType;
    }

    public final void setTestLicenseType$intellij_ml_llm_core(@Nullable LicenseType licenseType) {
        testLicenseType = licenseType;
    }

    @Nullable
    public final Boolean getTestLicensePersonal() {
        return testLicensePersonal;
    }

    public final void setTestLicensePersonal(@Nullable Boolean bl) {
        testLicensePersonal = bl;
    }

    private final QuotaTimeDisplayData getQuotaTimeDisplayData() {
        QuotaTimeDisplayData quotaTimeDisplayData;
        QuotaTimeData quotaTimeData = this.getQuotaTimeData();
        if (quotaTimeData == null) {
            UnknownQuotaTimeData unknownQuotaTimeData;
            UnknownQuotaTimeData it = unknownQuotaTimeData = new UnknownQuotaTimeData();
            boolean bl = false;
            log.warn("getQuotaUiLabelData returning unknown");
            return unknownQuotaTimeData;
        }
        QuotaTimeData labelData = quotaTimeData;
        Integer n = this.getRemainedHours(labelData.getEndsIn());
        if (n == null) {
            UnknownQuotaTimeData unknownQuotaTimeData;
            UnknownQuotaTimeData it = unknownQuotaTimeData = new UnknownQuotaTimeData();
            boolean bl = false;
            log.warn("getQuotaUiLabelData returning unknown");
            return unknownQuotaTimeData;
        }
        int remainedHours = n;
        int endsIn = remainedHours + 1;
        QuotaTimeData quotaTimeData2 = labelData;
        if (quotaTimeData2 instanceof QuotaRefillData) {
            RefillTimeDisplayData refillTimeDisplayData;
            RefillTimeDisplayData it = refillTimeDisplayData = new RefillTimeDisplayData(endsIn);
            boolean bl = false;
            log.info("getQuotaUiLabelData returning refill");
            quotaTimeDisplayData = refillTimeDisplayData;
        } else if (quotaTimeData2 instanceof QuotaExpiryData) {
            ExpiryTimeDisplayData expiryTimeDisplayData;
            ExpiryTimeDisplayData it = expiryTimeDisplayData = new ExpiryTimeDisplayData(endsIn);
            boolean bl = false;
            log.info("getQuotaUiLabelData returning quota");
            quotaTimeDisplayData = expiryTimeDisplayData;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return quotaTimeDisplayData;
    }

    public final boolean isAskAIModeEnabled() {
        return Registry.Companion.is("llm.chat.askai.enabled");
    }

    public final boolean isSupportLlm18910() {
        return Registry.Companion.is(LLM_SUPPORT_18910_KEY, false);
    }

    public final boolean isSupportLlm18911() {
        return this.isSupportLlm18910() && Registry.Companion.is(LLM_SUPPORT_18911_KEY, false);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AIAssistantUIUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        creditsFormatter = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    }
}

