/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.ui.errorReport;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.activation.util.PrettyKt;
import com.intellij.ml.llm.core.chat.services.AIAssistantServiceScope;
import com.intellij.ml.llm.core.chat.ui.errorReport.ChatErrorReportDialog;
import com.intellij.ml.llm.core.chat.ui.errorReport.ChatErrorReportDialogKt;
import com.intellij.ml.llm.core.chat.ui.errorReport.IdeInfo;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Urls;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0017\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u0016H\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/errorReport/ChatErrorReportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "error", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Throwable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getError", "()Ljava/lang/Throwable;", "stackTrace", "", "ideInfo", "Lcom/intellij/ml/llm/core/chat/ui/errorReport/IdeInfo;", "dialogContent", "getPreferredSize", "Ljava/awt/Dimension;", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "submitBugReport", "", "Companion", "intellij.ml.llm.core"})
public final class ChatErrorReportDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Throwable error;
    @NotNull
    private final String stackTrace;
    @NotNull
    private final IdeInfo ideInfo;
    @NlsSafe
    @NotNull
    private final String dialogContent;
    @NotNull
    private static final Dimension preferredDialogSize = new Dimension(1200, 600);

    public ChatErrorReportDialog(@NotNull Project project, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super(project, false);
        this.project = project;
        this.error = error;
        this.stackTrace = ExceptionsKt.stackTraceToString((Throwable)this.error);
        this.ideInfo = ChatErrorReportDialogKt.access$getIdeInfo();
        this.dialogContent = this.stackTrace + "\n\n" + CollectionsKt.joinToString$default((Iterable)this.ideInfo.getLocalized(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray = new Object[1];
        String string = this.error.getLocalizedMessage();
        if (string == null && (string = this.error.getMessage()) == null) {
            string = PrettyKt.getClassPrettyName((Object)this.error);
        }
        objectArray[0] = string;
        this.setTitle(LLMBundle.message("chat.error.dialog.title", objectArray));
        this.init();
        this.pack();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Throwable getError() {
        return this.error;
    }

    @NotNull
    public Dimension getPreferredSize() {
        return preferredDialogSize;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u240_u240;
        JBTextArea jBTextArea;
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setFont((Font)JBFont.medium());
        JBTextArea jBTextArea2 = jBTextArea = new JBTextArea(this.dialogContent);
        JPanel jPanel2 = $this$createCenterPanel_u24lambda_u240;
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u240_u240.setEditable(false);
        jPanel2.add((Component)jBTextArea);
        Component component = jPanel;
        JPanel $this$createCenterPanel_u24lambda_u241 = jPanel = new JBScrollPane(component);
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u241.setPreferredSize(preferredDialogSize);
        $this$createCenterPanel_u24lambda_u241.getVerticalScrollBar().setValue(0);
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction[] dialogWrapperActionArray;
        String string = LLMBundle.message("chat.error.dialog.button.copy", new Object[0]);
        DialogWrapper.DialogWrapperAction copyAction2 = new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ ChatErrorReportDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                try {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(ChatErrorReportDialog.access$getDialogContent$p(this.this$0)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        String string2 = LLMBundle.message("chat.error.dialog.button.submit", new Object[0]);
        DialogWrapper.DialogWrapperAction reportAction2 = new DialogWrapper.DialogWrapperAction(this, string2){
            final /* synthetic */ ChatErrorReportDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                this.this$0.close(0);
                ChatErrorReportDialog.access$submitBugReport(this.this$0);
            }
        };
        String string3 = LLMBundle.message("chat.error.dialog.button.close", new Object[0]);
        DialogWrapper.DialogWrapperExitAction closeAction2 = new DialogWrapper.DialogWrapperExitAction(this, string3){
            {
                this.putValue("DefaultAction", true);
            }
        };
        boolean isBugReportRegistryEnabled = Registry.Companion.is("llm.chat.error.details.submit.bug.action.enabled", true);
        if (isBugReportRegistryEnabled) {
            var6_6 = new DialogWrapper.DialogWrapperAction[]{copyAction2, reportAction2, closeAction2};
            dialogWrapperActionArray = var6_6;
        } else {
            var6_6 = new DialogWrapper.DialogWrapperAction[]{copyAction2, closeAction2};
            dialogWrapperActionArray = var6_6;
        }
        DialogWrapper.DialogWrapperAction[] actions = dialogWrapperActionArray;
        return (Action[])actions;
    }

    private final void submitBugReport() {
        BuildersKt.launch$default((CoroutineScope)AIAssistantServiceScope.Companion.getScope(this.project), (CoroutineContext)((CoroutineContext)new CoroutineName("Submitting AI Assistant bug report")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChatErrorReportDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.this$0.getProject(), (String)LLMBundle.message("chat.error.submission.process.title", new Object[0]), (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            boolean Z$0;
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ ChatErrorReportDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                block11: {
                                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, null){
                                                int label;
                                                final /* synthetic */ ChatErrorReportDialog this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            String string = IdeBundle.message((String)"reportProblemAction.upload.logs.title", (Object[])new Object[0]);
                                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                                            Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
                                                            String string2 = IdeBundle.message((String)"reportProblemAction.upload.logs.message", (Object[])objectArray);
                                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                                            return Boxing.boxBoolean((boolean)MessageDialogBuilder.Companion.yesNo(string, string2).ask(this.this$0.getProject()));
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v0 == var6_2) {
                                                return var6_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            if (!(shouldUploadLogs = ((Boolean)v0).booleanValue())) break;
                                            this.Z$0 = shouldUploadLogs;
                                            this.label = 2;
                                            v1 = ChatErrorReportDialogKt.access$uploadLogs(this.this$0.getProject(), ChatErrorReportDialog.access$getStackTrace$p(this.this$0), (Continuation)this);
                                            if (v1 == var6_2) {
                                                return var6_2;
                                            }
                                            ** GOTO lbl24
                                        }
                                        case 2: {
                                            shouldUploadLogs = this.Z$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl24:
                                            // 2 sources

                                            v2 = (String)v1;
                                            break block11;
                                        }
                                    }
                                    v2 = null;
                                }
                                logsUrl = v2;
                                var5_7 = (String)CollectionsKt.first((List)StringsKt.lines((CharSequence)ChatErrorReportDialog.access$getStackTrace$p(this.this$0)));
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)logsUrl);
                                this.L$1 = var5_7;
                                this.Z$0 = shouldUploadLogs;
                                this.label = 3;
                                v3 = submitBugReport.1.invokeSuspend$getIssueDescription(this.this$0.getProject(), logsUrl, (Continuation<? super String>)((Continuation)this));
                                if (v3 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl44
                                {
                                    case 3: {
                                        shouldUploadLogs = this.Z$0;
                                        var5_7 = (String)this.L$1;
                                        logsUrl = (String)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
lbl44:
                                        // 2 sources

                                        youTrackIssueTemplateUrl = submitBugReport.1.invokeSuspend$getYouTrackIssueTemplateUrl(var5_7, (String)v3);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)logsUrl);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)youTrackIssueTemplateUrl);
                                        this.Z$0 = shouldUploadLogs;
                                        this.label = 4;
                                        v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(youTrackIssueTemplateUrl, this.this$0, null){
                                            int label;
                                            final /* synthetic */ String $youTrackIssueTemplateUrl;
                                            final /* synthetic */ ChatErrorReportDialog this$0;
                                            {
                                                this.$youTrackIssueTemplateUrl = $youTrackIssueTemplateUrl;
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        BrowserUtil.browse((String)this.$youTrackIssueTemplateUrl, (Project)this.this$0.getProject());
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v4 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl59
                                    }
                                    case 4: {
                                        shouldUploadLogs = this.Z$0;
                                        youTrackIssueTemplateUrl = (String)this.L$1;
                                        logsUrl = (String)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
lbl59:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final String invokeSuspend$getYouTrackIssueTemplateUrl(String summary2, String description) {
                                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"project", (Object)"LLM"), TuplesKt.to((Object)"clearDraft", (Object)"true"), TuplesKt.to((Object)"summary", (Object)summary2), TuplesKt.to((Object)"description", (Object)description), TuplesKt.to((Object)"c", (Object)("Affected versions: " + ApplicationInfo.getInstance().getFullVersion() + " (" + ApplicationInfo.getInstance().getBuild().withoutProductCode() + ")"))};
                                String string = Urls.newFromEncoded((String)"https://youtrack.jetbrains.com/newissue").addParameters(MapsKt.mapOf((Pair[])pairArray)).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"c", (Object)"Type: Exception"))).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"c", (Object)"tag: Something went wrong reported"))).toExternalForm();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
                                return string;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            private static final Object invokeSuspend$getIssueDescription(Project project, String logsUrl, Continuation<? super String> $completion) {
                                if (!($completion instanceof submitBugReport.getIssueDescription.1)) ** GOTO lbl-1000
                                var8_3 = $completion;
                                if ((var8_3.label & -2147483648) != 0) {
                                    var8_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl($completion){
                                        Object L$0;
                                        Object L$1;
                                        Object L$2;
                                        Object L$3;
                                        /* synthetic */ Object result;
                                        int label;

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return submitBugReport.1.access$invokeSuspend$getIssueDescription(null, null, (Continuation)this);
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var6_7 = description = new StringBuilder("### Steps to reproduce:\n1. \n\n### Desired outcome:\n\n\n### Details:");
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                                        $continuation.L$1 = logsUrl;
                                        $continuation.L$2 = description;
                                        $continuation.L$3 = var6_7;
                                        $continuation.label = 1;
                                        v0 = SendFeedbackAction.Companion.getDescription(project, (Continuation)$continuation);
                                        if (v0 == var9_5) {
                                            return var9_5;
                                        }
                                        ** GOTO lbl29
                                    }
                                    case 1: {
                                        var6_7 = (StringBuilder)$continuation.L$3;
                                        description = (StringBuilder)$continuation.L$2;
                                        logsUrl = (String)$continuation.L$1;
                                        project = (Project)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl29:
                                        // 2 sources

                                        var6_7.append((String)v0);
                                        v1 = logsUrl;
                                        if (v1 != null) {
                                            it = v1;
                                            $i$a$-let-ChatErrorReportDialog$submitBugReport$1$1$getIssueDescription$2 = false;
                                            description.append("\nAuto-uploaded logs URL (accessible to JetBrains employees only): " + it);
                                        }
                                        v2 = description.toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
                                        return v2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            static /* synthetic */ Object invokeSuspend$getIssueDescription$default(Project project, String string, Continuation continuation, int n, Object object) {
                                if ((n & 2) != 0) {
                                    string = null;
                                }
                                return submitBugReport.1.invokeSuspend$getIssueDescription(project, string, (Continuation<? super String>)continuation);
                            }

                            public static final /* synthetic */ Object access$invokeSuspend$getIssueDescription(Project project, String logsUrl, Continuation $completion) {
                                return submitBugReport.1.invokeSuspend$getIssueDescription(project, logsUrl, (Continuation<? super String>)$completion);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ String access$getDialogContent$p(ChatErrorReportDialog $this) {
        return $this.dialogContent;
    }

    public static final /* synthetic */ void access$submitBugReport(ChatErrorReportDialog $this) {
        $this.submitBugReport();
    }

    public static final /* synthetic */ String access$getStackTrace$p(ChatErrorReportDialog $this) {
        return $this.stackTrace;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/chat/ui/errorReport/ChatErrorReportDialog$Companion;", "", "<init>", "()V", "preferredDialogSize", "Ljava/awt/Dimension;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

