/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.clients.telemetry;

import ai.grazie.model.llm.data.stream.LLMStreamFinishMetaData;
import ai.grazie.utils.mpp.money.Credit;
import ai.grazie.utils.mpp.money.Money;
import com.intellij.ml.llm.core.clients.telemetry.AiaSpanAttributeKey;
import com.intellij.ml.llm.core.models.api.AiaLlmStreamData;
import com.intellij.ml.llm.core.models.api.AiaLlmStreamFunctionCall;
import com.intellij.ml.llm.core.models.api.AiaLlmStreamText;
import com.intellij.ml.llm.core.models.api.AiaLlmStreamTokensData;
import com.intellij.ml.llm.grazie.GrazieLLMStreamStreamData;
import io.opentelemetry.api.trace.Span;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u0012*\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\"\u0010\u0019\u001a\u00020\u0012*\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u0012*\u00020\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J.\u0010\u001d\u001a\u00020\u0012*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/core/clients/telemetry/AiaChatRequestAttributeBuilder;", "", "<init>", "()V", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toolCalls", "", "Lcom/intellij/ml/llm/core/models/api/AiaLlmStreamFunctionCall;", "inputTokens", "", "outputTokens", "grazieCredit", "Lai/grazie/utils/mpp/money/Credit;", "finishMetadata", "Lai/grazie/model/llm/data/stream/LLMStreamFinishMetaData;", "add", "", "streamingChunk", "Lcom/intellij/ml/llm/core/models/api/AiaLlmStreamData;", "buildAndSetAttributes", "span", "Lio/opentelemetry/api/trace/Span;", "setTokenUsageAttributes", "setOutputSpanAttributes", "", "", "setFinishMetadata", "setToolAttribute", "index", "name", "arguments", "callId", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAiaChatRequestStreamingWrappers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiaChatRequestStreamingWrappers.kt\ncom/intellij/ml/llm/core/clients/telemetry/AiaChatRequestAttributeBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1878#2,2:149\n1880#2:152\n1#3:151\n*S KotlinDebug\n*F\n+ 1 AiaChatRequestStreamingWrappers.kt\ncom/intellij/ml/llm/core/clients/telemetry/AiaChatRequestAttributeBuilder\n*L\n111#1:149,2\n111#1:152\n*E\n"})
final class AiaChatRequestAttributeBuilder {
    @NotNull
    private final StringBuilder text = new StringBuilder();
    @NotNull
    private final List<AiaLlmStreamFunctionCall> toolCalls = new ArrayList();
    private int inputTokens;
    private int outputTokens;
    @NotNull
    private Credit grazieCredit = Credit.Companion.getZERO();
    @Nullable
    private LLMStreamFinishMetaData finishMetadata;

    public final void add(@NotNull AiaLlmStreamData streamingChunk) {
        Intrinsics.checkNotNullParameter((Object)streamingChunk, (String)"streamingChunk");
        AiaLlmStreamData aiaLlmStreamData = streamingChunk;
        if (aiaLlmStreamData instanceof AiaLlmStreamText) {
            this.text.append(((AiaLlmStreamText)streamingChunk).getContent());
        } else if (aiaLlmStreamData instanceof AiaLlmStreamTokensData) {
            this.inputTokens += ((AiaLlmStreamTokensData)streamingChunk).getInputTokens();
            this.outputTokens += ((AiaLlmStreamTokensData)streamingChunk).getOutputTokens();
        } else if (aiaLlmStreamData instanceof AiaLlmStreamFunctionCall) {
            ((Collection)this.toolCalls).add(streamingChunk);
        } else if (aiaLlmStreamData instanceof GrazieLLMStreamStreamData.Finish) {
            this.finishMetadata = ((GrazieLLMStreamStreamData.Finish)streamingChunk).getFinishMetaData();
        } else if (aiaLlmStreamData instanceof GrazieLLMStreamStreamData.QuotaMetadata) {
            this.grazieCredit = (Credit)this.grazieCredit.plus((Money)((GrazieLLMStreamStreamData.QuotaMetadata)streamingChunk).getQuotaMetaData().getSpent());
        }
    }

    public final void buildAndSetAttributes(@NotNull Span span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        this.setTokenUsageAttributes(span, this.inputTokens, this.outputTokens);
        span.setAttribute("gen_ai.usage.cost", this.grazieCredit.getAmount().asDouble());
        String string = this.text.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.setOutputSpanAttributes(span, string, this.toolCalls);
    }

    private final void setTokenUsageAttributes(Span $this$setTokenUsageAttributes, int inputTokens, int outputTokens) {
        $this$setTokenUsageAttributes.setAttribute("gen_ai.usage.input_tokens", String.valueOf(inputTokens));
        $this$setTokenUsageAttributes.setAttribute("gen_ai.usage.output_tokens", String.valueOf(outputTokens));
        $this$setTokenUsageAttributes.setAttribute("gen_ai.usage.total_tokens", String.valueOf(inputTokens + outputTokens));
    }

    /*
     * WARNING - void declaration
     */
    private final void setOutputSpanAttributes(Span $this$setOutputSpanAttributes, String text, List<? extends AiaLlmStreamFunctionCall> toolCalls) {
        this.setFinishMetadata($this$setOutputSpanAttributes, this.finishMetadata);
        int completionIndex = 0;
        if (((CharSequence)text).length() > 0) {
            $this$setOutputSpanAttributes.setAttribute(new AiaSpanAttributeKey.Completion(completionIndex).getRole(), "assistant");
            $this$setOutputSpanAttributes.setAttribute(new AiaSpanAttributeKey.Completion(completionIndex).getContent(), text);
            ++completionIndex;
        }
        Object name = null;
        name = "";
        String callId = null;
        Object arguments = null;
        arguments = "";
        Integer currentParallelIndex = null;
        currentParallelIndex = -1;
        Iterable $this$forEachIndexed$iv = toolCalls;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void call;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AiaLlmStreamFunctionCall aiaLlmStreamFunctionCall = (AiaLlmStreamFunctionCall)item$iv;
            int idx = n;
            boolean bl = false;
            if (idx > 0 && !Intrinsics.areEqual((Object)call.getParallelToolIndex(), (Object)currentParallelIndex)) {
                this.setToolAttribute($this$setOutputSpanAttributes, completionIndex, (String)name, (String)arguments, callId);
                ++completionIndex;
                name = "";
                arguments = "";
            }
            name = name + call.getName();
            arguments = arguments + call.getArguments();
            if (call.getId() != null) {
                String it;
                boolean bl2 = false;
                callId = it;
            }
            currentParallelIndex = call.getParallelToolIndex();
            if (idx != toolCalls.size() - 1) continue;
            this.setToolAttribute($this$setOutputSpanAttributes, completionIndex, (String)name, (String)arguments, callId);
        }
    }

    private final void setFinishMetadata(Span $this$setFinishMetadata, LLMStreamFinishMetaData finishMetadata) {
        block1: {
            if (finishMetadata == null) {
                return;
            }
            $this$setFinishMetadata.setAttribute(new AiaSpanAttributeKey.Completion(0).getFinishReason(), finishMetadata.getReason().toString());
            Integer n = finishMetadata.getChoiceIndex();
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            $this$setFinishMetadata.setAttribute(new AiaSpanAttributeKey.Completion(0).getChoiceIndex(), String.valueOf(it));
        }
    }

    private final void setToolAttribute(Span $this$setToolAttribute, int index, String name, String arguments, String callId) {
        block0: {
            AiaSpanAttributeKey.Completion keys = new AiaSpanAttributeKey.Completion(index);
            $this$setToolAttribute.setAttribute(keys.getRole(), "tool");
            $this$setToolAttribute.setAttribute(keys.getName(), name);
            $this$setToolAttribute.setAttribute(keys.getArguments(), arguments);
            String string = callId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$setToolAttribute.setAttribute(keys.getCallId(), it);
        }
    }
}

