/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptLibrary;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.core.promptLibrary.AIAssistantPromptLibraryStorage;
import com.intellij.ml.llm.core.promptLibrary.AIAssistantStoredPrompt;
import com.intellij.ml.llm.core.promptLibrary.AIChatLibraryPrompt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0015\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\n\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService;", "", "<init>", "()V", "storage", "Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage;", "getStorage", "()Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantPromptLibraryStorage;", "save", "", "prompt", "Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPrompt;", "updateAll", "", "prompts", "", "getAllPrompts", "createChatPrompt", "stored", "Lcom/intellij/ml/llm/core/promptLibrary/AIAssistantStoredPrompt;", "createStoredPrompt", "getLocalizedName", "", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIChatLibraryPromptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIChatLibraryPromptService.kt\ncom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1563#2:64\n1634#2,3:65\n1068#2:68\n1563#2:69\n1634#2,3:70\n*S KotlinDebug\n*F\n+ 1 AIChatLibraryPromptService.kt\ncom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService\n*L\n19#1:64\n19#1:65,3\n26#1:68\n26#1:69\n26#1:70,3\n*E\n"})
public final class AIChatLibraryPromptService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final AIAssistantPromptLibraryStorage getStorage() {
        return AIAssistantPromptLibraryStorage.Companion.getInstance();
    }

    public final boolean save(@NotNull AIChatLibraryPrompt prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getStorage().save(this.createStoredPrompt(prompt));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAll(@NotNull List<AIChatLibraryPrompt> prompts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(prompts, (String)"prompts");
        Iterable iterable = prompts;
        AIAssistantPromptLibraryStorage aIAssistantPromptLibraryStorage = this.getStorage();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AIChatLibraryPrompt aIChatLibraryPrompt = (AIChatLibraryPrompt)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createStoredPrompt((AIChatLibraryPrompt)p0));
        }
        aIAssistantPromptLibraryStorage.saveAll((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AIChatLibraryPrompt> getAllPrompts() {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedByDescending$iv = this.getStorage().getAll();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AIAssistantStoredPrompt it = (AIAssistantStoredPrompt)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (AIAssistantStoredPrompt)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AIAssistantStoredPrompt aIAssistantStoredPrompt = (AIAssistantStoredPrompt)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createChatPrompt((AIAssistantStoredPrompt)p0));
        }
        return (List)destination$iv$iv;
    }

    private final AIChatLibraryPrompt createChatPrompt(AIAssistantStoredPrompt stored) {
        return new AIChatLibraryPrompt(stored.getId(), this.getLocalizedName(stored), stored.getContent(), stored.getWaitForInput(), stored.getShowInPopup(), stored.getShowInInput(), stored.getHasCustomTitle(), stored.isBuiltIn(), stored.getPriority());
    }

    private final AIAssistantStoredPrompt createStoredPrompt(AIChatLibraryPrompt prompt) {
        return new AIAssistantStoredPrompt(prompt.getId(), prompt.getName(), prompt.getContent(), prompt.getWaitForInput(), prompt.getShowInPopup(), prompt.getShowInInput(), prompt.getHasCustomTitle(), prompt.isBuiltIn(), prompt.getPriority());
    }

    private final String getLocalizedName(AIAssistantStoredPrompt prompt) {
        if (!prompt.isBuiltIn()) {
            return prompt.getName();
        }
        String string = AIAssistantPromptLibraryStorage.Companion.localizeId(prompt.getId());
        if (string == null) {
            string = prompt.getName();
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nAIChatLibraryPromptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIChatLibraryPromptService.kt\ncom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,63:1\n42#2,3:64\n*S KotlinDebug\n*F\n+ 1 AIChatLibraryPromptService.kt\ncom/intellij/ml/llm/core/promptLibrary/AIChatLibraryPromptService$Companion\n*L\n10#1:64,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIChatLibraryPromptService getInstance() {
            boolean $i$f$service = false;
            Class<AIChatLibraryPromptService> serviceClass$iv = AIChatLibraryPromptService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AIChatLibraryPromptService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

