/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0000\u0018\u0000 \u000e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LogFileProvider;", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Ljava/io/File;", "suffix", "", "<init>", "(Ljava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "invoke", "path", "logFilePathProvider", "dir", "Companion", "intellij.ml.llm.core"})
public final class LogFileProvider
implements Function1<Path, File> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String suffix;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");

    public LogFileProvider(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.suffix = suffix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    @NotNull
    public File invoke(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.logFilePathProvider(path);
    }

    private final File logFilePathProvider(Path dir) {
        File file = dir.resolve(com.intellij.ml.llm.core.promptlog.LogFileProvider$Companion.newName$intellij_ml_llm_core$default(Companion, false, this.suffix, 0, 4, null)).toFile();
        int counter = 0;
        while (file.exists()) {
            file = dir.resolve(Companion.newName$intellij_ml_llm_core(true, this.suffix, counter)).toFile();
            ++counter;
        }
        File file2 = file;
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/core/promptlog/LogFileProvider$Companion;", "", "<init>", "()V", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "newName", "", "addCounter", "", "suffix", "counter", "", "newName$intellij_ml_llm_core", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String newName$intellij_ml_llm_core(boolean addCounter, @NotNull String suffix, int counter) {
            String string;
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            String dateTime = dateTimeFormatter.format(LocalDateTime.now());
            if (addCounter) {
                String string2 = "%05d";
                Object[] objectArray = new Object[]{counter};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                String unique = string3;
                string = dateTime + "-" + unique + "-" + suffix;
            } else {
                string = dateTime + "-" + suffix;
            }
            return string;
        }

        public static /* synthetic */ String newName$intellij_ml_llm_core$default(Companion companion, boolean bl, String string, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.newName$intellij_ml_llm_core(bl, string, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

