/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.DataSharingSettingsChangeListener;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.ide.gdpr.trace.TraceConsentManager;
import com.intellij.llmInstaller.UtilsKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.settings.LLMDataSharingConsentState;
import com.intellij.ml.llm.core.settings.LLMDataSharingManagerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u000fH\u0002J-\u0010\u0012\u001a\u00020\u000f2\u001e\b\u0002\u0010\u0013\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0003J\b\u0010\u001d\u001a\u00020\rH\u0002J\b\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u00020\r@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0013\u0010(\u001a\u0004\u0018\u00010&8G\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010\r8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMDataSharingManager;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/core/settings/LLMDataSharingConsentState;", "licensingFacadeFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/ui/LicensingFacade;", "isDataSharingEnabled", "", "setDataSharingPermitted", "", "isPermitted", "loadStateAndSubscribeToUpdates", "scheduleLoadState", "onFinish", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;)V", "loadState", "tryLoadLlmcState", "tryLoadTraceState", "askTraceDataSharingConsentIfNeeded", "project", "Lcom/intellij/openapi/project/Project;", "shouldAskForTraceConsent", "isPersonalCommercialLicense", "shouldShowConsentDialog", "isDataSharingForciblyDisabledForTests", "()Z", "setDataSharingForciblyDisabledForTests", "(Z)V", "updateDataSharingAgreement", "version", "", "text", "consentVersion", "getConsentVersion", "()Ljava/lang/String;", "dataSharingPermission", "getDataSharingPermission", "()Ljava/lang/Boolean;", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMDataSharingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,261:1\n42#2,3:262\n230#3,5:265\n1#4:270\n13#5:271\n*S KotlinDebug\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager\n*L\n78#1:262,3\n85#1:265,5\n47#1:271\n*E\n"})
public final class LLMDataSharingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private MutableStateFlow<LLMDataSharingConsentState> state;
    @NotNull
    private final StateFlow<LicensingFacade> licensingFacadeFlow;
    private boolean isDataSharingForciblyDisabledForTests;
    @NotNull
    private static final Logger LOG;

    public LLMDataSharingManager(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.state = StateFlowKt.MutableStateFlow(null);
        this.licensingFacadeFlow = UtilsKt.licensingFacadeStateIn((CoroutineScope)this.scope);
        this.loadStateAndSubscribeToUpdates();
    }

    public final boolean isDataSharingEnabled() {
        boolean $i$f$service = false;
        Class<ConsentOptionsProvider> serviceClass$iv = ConsentOptionsProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((ConsentOptionsProvider)object).isTraceDataCollectionAllowed() && !ApplicationManager.getApplication().isUnitTestMode() && !this.isDataSharingForciblyDisabledForTests;
    }

    public final void setDataSharingPermitted(boolean isPermitted) {
        LLMDataSharingConsentState lLMDataSharingConsentState;
        LLMDataSharingConsentState nextValue$iv;
        Object prevValue$iv;
        ConsentOptions.Permission permission = isPermitted ? ConsentOptions.Permission.YES : ConsentOptions.Permission.NO;
        MutableStateFlow<LLMDataSharingConsentState> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            LLMDataSharingConsentState it = (LLMDataSharingConsentState)prevValue$iv;
            boolean bl = false;
            lLMDataSharingConsentState = it;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = lLMDataSharingConsentState != null ? LLMDataSharingConsentState.copy$default(lLMDataSharingConsentState, null, false, permission, 1, null) : null)));
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isPermitted, null){
            int label;
            final /* synthetic */ boolean $isPermitted;
            {
                this.$isPermitted = $isPermitted;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LocalConsentOptions.INSTANCE.setTraceDataCollectionComPermission(this.$isPermitted);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void loadStateAndSubscribeToUpdates() {
        ApplicationManager.getApplication().getMessageBus().connect(this.scope).subscribe(DataSharingSettingsChangeListener.TOPIC, (Object)new DataSharingSettingsChangeListener(this){
            final /* synthetic */ LLMDataSharingManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void consentsUpdated() {
                LLMDataSharingManager.access$getLOG$cp().debug("Consents updated, reloading state");
                LLMDataSharingManager.scheduleLoadState$default(this.this$0, null, 1, null);
            }

            public void consentWritten() {
            }
        });
        this.scheduleLoadState((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LLMDataSharingManager this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)LLMDataSharingManager.access$getLicensingFacadeFlow$p(this.this$0)), (Function2)((Function2)new Function2<LicensingFacade, Continuation<? super Unit>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                LicensingFacade licensingFacade = (LicensingFacade)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void licensingFacade2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        void v0 = licensingFacade2;
                                        if ((v0 != null ? v0.metadata : null) == null) return Unit.INSTANCE;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)licensingFacade2);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                            int label;

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        com.intellij.ml.llm.core.settings.LLMDataSharingManager$Companion.askDataSharingConsentIfNeeded$default(LLMDataSharingManager.Companion, null, 1, null);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(LicensingFacade p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void scheduleLoadState(Function1<? super Continuation<? super Unit>, ? extends Object> onFinish) {
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onFinish, null){
            int label;
            final /* synthetic */ LLMDataSharingManager this$0;
            final /* synthetic */ Function1<Continuation<? super Unit>, Object> $onFinish;
            {
                this.this$0 = $receiver;
                this.$onFinish = $onFinish;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LLMDataSharingManager.access$loadState(this.this$0);
                        this.label = 1;
                        Object object2 = this.$onFinish.invoke((Object)((Object)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    static /* synthetic */ void scheduleLoadState$default(LLMDataSharingManager lLMDataSharingManager, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = (Function1)new Function1<Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            };
        }
        lLMDataSharingManager.scheduleLoadState((Function1<? super Continuation<? super Unit>, ? extends Object>)function1);
    }

    private final void loadState() {
        LLMDataSharingConsentState loadedState;
        LLMDataSharingConsentState traceLoadedState = this.tryLoadTraceState();
        LLMDataSharingConsentState lLMDataSharingConsentState = loadedState = traceLoadedState != null && traceLoadedState.getPermission() != ConsentOptions.Permission.UNDEFINED ? traceLoadedState : this.tryLoadLlmcState();
        if (lLMDataSharingConsentState == null) {
            throw new IllegalStateException("Cannot find TRACE data sharing agreement with undefined permission or AI data sharing agreement, which is expected to be bundled");
        }
        this.state.setValue((Object)lLMDataSharingConsentState);
        LOG.debug("New consent state loaded: " + loadedState);
    }

    private final LLMDataSharingConsentState tryLoadLlmcState() {
        Pair pair = ConsentOptions.getInstance().getConsents(ConsentOptions.condAiDataCollectionConsent());
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getConsents(...)");
        Pair pair2 = pair;
        List consents = (List)pair2.component1();
        Boolean isConfirmationNeeded = (Boolean)pair2.component2();
        if (consents.size() != 1) {
            return null;
        }
        Object e = consents.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        Consent consent = (Consent)e;
        Intrinsics.checkNotNull((Object)isConfirmationNeeded);
        boolean bl = isConfirmationNeeded;
        ConsentOptions.Permission permission = ConsentOptions.getInstance().getAiDataCollectionPermission();
        Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"getAiDataCollectionPermission(...)");
        return new LLMDataSharingConsentState(consent, bl, permission);
    }

    private final LLMDataSharingConsentState tryLoadTraceState() {
        Pair pair = LocalConsentOptions.INSTANCE.getLocalConsents(LocalConsentOptions.condTraceDataCollectionComLocalConsent());
        List consents = (List)pair.component1();
        boolean isConfirmationNeeded = (Boolean)pair.component2();
        if (consents.size() != 1) {
            return null;
        }
        return new LLMDataSharingConsentState((Consent)consents.get(0), isConfirmationNeeded, LocalConsentOptions.INSTANCE.getTraceDataCollectionComPermission());
    }

    @RequiresEdt
    private final void askTraceDataSharingConsentIfNeeded(Project project) {
        if (!this.shouldAskForTraceConsent()) {
            return;
        }
        LLMDataSharingConsentState consentState = (LLMDataSharingConsentState)this.state.getValue();
        if (consentState != null && this.shouldShowConsentDialog()) {
            Object[] objectArray = new Object[]{"2025.3.1"};
            MessageDialogBuilder.YesNo messageDialog = MessageDialogBuilder.Companion.yesNo(LLMBundle.message("notification.trace.data.sharing.title", new Object[0]), LLMBundle.message("notification.trace.data.sharing.text", objectArray));
            messageDialog.yesText(LLMBundle.message("notification.trace.data.sharing.yes", new Object[0]));
            this.setDataSharingPermitted(messageDialog.ask(project));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldAskForTraceConsent() {
        if (LLMDataSharingManagerKt.access$isDataSharingProhibitedByProvisioner()) return false;
        if (LLMDataSharingManagerKt.access$isNonJetBrainsIDE()) return false;
        if (!this.isPersonalCommercialLicense()) {
            if (!ApplicationManagerEx.isInIntegrationTest()) return false;
        }
        TraceConsentManager traceConsentManager = TraceConsentManager.Companion.getInstance();
        if (traceConsentManager == null) return false;
        if (!traceConsentManager.canCollectTraceConsent()) return false;
        return true;
    }

    private final boolean isPersonalCommercialLicense() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return false;
        }
        LicensingFacade licensingFacade2 = licensingFacade;
        String string = licensingFacade2.metadata;
        if (string == null) {
            return false;
        }
        String licenseMetadata = string;
        return !LLMDataSharingManagerKt.access$isNonCommercialLicense(licenseMetadata) && !LLMDataSharingManagerKt.access$isOrganizationalLicense(licenseMetadata);
    }

    private final boolean shouldShowConsentDialog() {
        LLMDataSharingConsentState lLMDataSharingConsentState = (LLMDataSharingConsentState)this.state.getValue();
        if (lLMDataSharingConsentState == null) {
            return false;
        }
        LLMDataSharingConsentState consentState = lLMDataSharingConsentState;
        if (ApplicationManager.getApplication().isUnitTestMode() || this.isDataSharingForciblyDisabledForTests) {
            return false;
        }
        Pair pair = LocalConsentOptions.INSTANCE.getLocalConsents(LocalConsentOptions.condTraceDataCollectionComLocalConsent());
        List traceComConsents = (List)pair.component1();
        boolean isConfirmationNeeded = (Boolean)pair.component2();
        if (!isConfirmationNeeded) {
            return false;
        }
        return ConsentOptions.condAiDataCollectionConsent().test(consentState.getConsent()) && consentState.getConsent().isAccepted() && traceComConsents.size() == 1;
    }

    public final boolean isDataSharingForciblyDisabledForTests() {
        return this.isDataSharingForciblyDisabledForTests;
    }

    @TestOnly
    public final void setDataSharingForciblyDisabledForTests(boolean bl) {
        this.isDataSharingForciblyDisabledForTests = bl;
    }

    @TestOnly
    public final void updateDataSharingAgreement(@NotNull String version, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ConsentOptions.getInstance().applyServerUpdates(StringsKt.trimIndent((String)("\n      [\n        {\n          \"consentId\": \"ai.trace.data.collection.and.use.policy\",\n          \"version\": \"" + version + "\",\n          \"text\": \"" + text + "\",\n          \"printableName\": \"Send detailed code-related data\",\n          \"accepted\": \"false\"\n        }\n      ]\n    ")));
    }

    @TestOnly
    @Nullable
    public final String getConsentVersion() {
        LLMDataSharingConsentState lLMDataSharingConsentState = (LLMDataSharingConsentState)this.state.getValue();
        return lLMDataSharingConsentState != null && (lLMDataSharingConsentState = lLMDataSharingConsentState.getConsent()) != null && (lLMDataSharingConsentState = lLMDataSharingConsentState.getVersion()) != null ? lLMDataSharingConsentState.toString() : null;
    }

    @TestOnly
    @Nullable
    public final Boolean getDataSharingPermission() {
        Boolean bl;
        LLMDataSharingConsentState lLMDataSharingConsentState = (LLMDataSharingConsentState)this.state.getValue();
        if (lLMDataSharingConsentState != null && (lLMDataSharingConsentState = lLMDataSharingConsentState.getPermission()) != null) {
            LLMDataSharingConsentState it = lLMDataSharingConsentState;
            boolean bl2 = false;
            bl = it == ConsentOptions.Permission.YES;
        } else {
            bl = null;
        }
        return bl;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ StateFlow access$getLicensingFacadeFlow$p(LLMDataSharingManager $this) {
        return $this.licensingFacadeFlow;
    }

    public static final /* synthetic */ void access$loadState(LLMDataSharingManager $this) {
        $this.loadState();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMDataSharingManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMDataSharingManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isDataSharingEnabled", "", "askDataSharingConsentIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLLMDataSharingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,261:1\n42#2,3:262\n42#2,3:265\n*S KotlinDebug\n*F\n+ 1 LLMDataSharingManager.kt\ncom/intellij/ml/llm/core/settings/LLMDataSharingManager$Companion\n*L\n49#1:262,3\n60#1:265,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDataSharingEnabled() {
            boolean $i$f$service = false;
            Class<LLMDataSharingManager> serviceClass$iv = LLMDataSharingManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((LLMDataSharingManager)object).isDataSharingEnabled();
        }

        @RequiresEdt
        public final void askDataSharingConsentIfNeeded(@Nullable Project project) {
            boolean $i$f$service = false;
            Class<LLMDataSharingManager> serviceClass$iv = LLMDataSharingManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((LLMDataSharingManager)object).askTraceDataSharingConsentIfNeeded(project);
        }

        public static /* synthetic */ void askDataSharingConsentIfNeeded$default(Companion companion, Project project, int n, Object object) {
            if ((n & 1) != 0) {
                project = null;
            }
            companion.askDataSharingConsentIfNeeded(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

