/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.core.AIAssistantAllowedLevelService;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIAssistantKillSwitch;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.settings.LLMProjectConfigurable$createPanel$;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsManager;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreManagerSettings;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreSettingsManager;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreSettingsState;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreUxHelper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMProjectConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMProjectConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMProjectConfigurable.kt\ncom/intellij/ml/llm/core/settings/LLMProjectConfigurable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 4 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 5 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,126:1\n30#2,2:127\n49#3:129\n51#3:133\n46#4:130\n51#4:132\n105#5:131\n*S KotlinDebug\n*F\n+ 1 LLMProjectConfigurable.kt\ncom/intellij/ml/llm/core/settings/LLMProjectConfigurable\n*L\n38#1:127,2\n41#1:129\n41#1:133\n41#1:130\n41#1:132\n41#1:131\n*E\n"})
public final class LLMProjectConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;

    public LLMProjectConfigurable(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(LLMBundle.message("settings.configurable.project.settings.display.name", new Object[0]), "ai.assistant.reference.settings.project.settings", null, 4, null);
        this.project = project;
        this.scope = scope;
    }

    @NotNull
    public DialogPanel createPanel() {
        LLMProjectSettingsManager settings = LLMProjectSettingsManager.Companion.getInstance(this.project);
        AiIgnoreSettingsManager aiIgnoreSettings = AiIgnoreSettingsManager.Companion.getInstance(this.project);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<AIAssistantAllowedLevelService> serviceClass$iv = AIAssistantAllowedLevelService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ComponentPredicate projectFilePredicate = ComponentPredicateKt.predicate(((AIAssistantAllowedLevelService)object).getLevel(), (CoroutineScope)this.scope, LLMProjectConfigurable::createPanel$lambda$0);
        Flow $this$map$iv = (Flow)AiaActivationManager.Companion.getInstance().getActivationState();
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        ComponentPredicate authedPredicate = ComponentPredicateKt.predicate((StateFlow)FlowKt.stateIn((Flow)((Flow)new Flow<Boolean>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof createPanel$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ createPanel$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                it = (AiaActivation)value;
                                $i$a$-map-LLMProjectConfigurable$createPanel$authedPredicate$1 = false;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit((Object)Boxing.boxBoolean((boolean)Outcome.isComplete-impl((Object)it.getOutcome-X8CKn68())), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl38
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl38:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), (CoroutineScope)this.scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)false), (CoroutineScope)this.scope, LLMProjectConfigurable::createPanel$lambda$2);
        return BuilderKt.panel(arg_0 -> LLMProjectConfigurable.createPanel$lambda$3(projectFilePredicate, this, settings, authedPredicate, aiIgnoreSettings, arg_0));
    }

    public void apply() {
        boolean modified = this.isModified();
        super.apply();
        if (modified) {
            LLMProjectSettingsManager.Companion.fireSettingsChanged(this.project);
        }
    }

    private static final boolean createPanel$lambda$0(AIAssistantKillSwitch.Level it) {
        return it == AIAssistantKillSwitch.Level.ProjectFile;
    }

    private static final boolean createPanel$lambda$2(boolean it) {
        return it;
    }

    private static final Unit createPanel$lambda$3(ComponentPredicate $projectFilePredicate, LLMProjectConfigurable this$0, LLMProjectSettingsManager $settings, ComponentPredicate $authedPredicate, AiIgnoreSettingsManager $aiIgnoreSettings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$0($settings, $authedPredicate, $projectFilePredicate, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, LLMProjectConfigurable::createPanel$lambda$3$1, (int)1, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)$projectFilePredicate));
        Panel.row$default((Panel)$this$panel, null, LLMProjectConfigurable::createPanel$lambda$3$2, (int)1, null).visibleIf($projectFilePredicate);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$3($aiIgnoreSettings, arg_0), (int)1, null).visible(AiIgnoreManagerSettings.Companion.getInstance(this$0.project).isPathConfigurable());
        boolean isAiIgnoreEnabledInRegistry = AiIgnoreManagerSettings.Companion.getInstance(this$0.project).isEnabledInRegistry();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$4($aiIgnoreSettings, $authedPredicate, $projectFilePredicate, arg_0), (int)1, null).visible(isAiIgnoreEnabledInRegistry);
        if (isAiIgnoreEnabledInRegistry && !this$0.project.isDefault()) {
            AiIgnoreUxHelper uxHelper = AiIgnoreUxHelper.Companion.getInstance(this$0.project);
            boolean canCreateNewFile = uxHelper.canCreateNewFile();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$5(uxHelper, arg_0), (int)1, null).visible(canCreateNewFile);
            boolean canOpenExistingFile = uxHelper.canOpenExistingFile();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$6(uxHelper, arg_0), (int)1, null).visible(canOpenExistingFile);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$7(this$0, $settings, arg_0), (int)1, null).visible(Registry.Companion.is("llm.self.review.enabled"));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$0(LLMProjectSettingsManager $settings, ComponentPredicate $authedPredicate, ComponentPredicate $projectFilePredicate, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        ButtonKt.bindSelected((Cell)$this$row.checkBox(LLMBundle.message("project.settings.turnedOn", objectArray)), (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((LLMProjectSettingsManager)this.receiver).isTurnedOn();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((LLMProjectSettingsManager)this.receiver).setTurnedOn(p0);
            }
        })).enabledIf(ComponentPredicateKt.and((ComponentPredicate)$authedPredicate, (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)$projectFilePredicate)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AIAssistantUIUtilKt.howCompletelyDisableLink($this$row);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        $this$row.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        Row.text$default((Row)$this$row, (String)LLMBundle.message("project.settings.disabled.ny.noai.file", objectArray), (int)Integer.MAX_VALUE, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$3(AiIgnoreSettingsManager $aiIgnoreSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFileDescriptor(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)Cell.label$default((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, null, LLMProjectConfigurable::createPanel$lambda$3$3$0, (int)2, null), (String)LLMBundle.message("project.settings.path.to.aiignore", new Object[0]), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE), (Function0)((Function0)new Function0<String>((Object)$aiIgnoreSettings){

            public final String invoke() {
                return ((AiIgnoreSettingsManager)this.receiver).getPresentableAIIgnoreURL();
            }
        }), (Function1)((Function1)new Function1<String, Unit>((Object)$aiIgnoreSettings){

            public final void invoke(String p0) {
                ((AiIgnoreSettingsManager)this.receiver).setAIIgnoreURL(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$3$3$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return string;
    }

    private static final Unit createPanel$lambda$3$4(AiIgnoreSettingsManager $aiIgnoreSettings, ComponentPredicate $authedPredicate, ComponentPredicate $projectFilePredicate, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(LLMBundle.message("project.settings.aiignore.turnedOn", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($aiIgnoreSettings.getState()){

            public Object get() {
                return ((AiIgnoreSettingsState)this.receiver).getEnabled();
            }

            public void set(Object value) {
                ((AiIgnoreSettingsState)this.receiver).setEnabled(((Boolean)value).booleanValue());
            }
        })).enabledIf(ComponentPredicateKt.and((ComponentPredicate)$authedPredicate, (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)$projectFilePredicate)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$5(AiIgnoreUxHelper $uxHelper, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(LLMBundle.message("project.settings.aiignore.create", new Object[0]), arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$5$0($uxHelper, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$5$0(AiIgnoreUxHelper $uxHelper, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $uxHelper.createNewFile();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$6(AiIgnoreUxHelper $uxHelper, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(LLMBundle.message("project.settings.aiignore.open", new Object[0]), arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$6$0($uxHelper, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$6$0(AiIgnoreUxHelper $uxHelper, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $uxHelper.openExistingFile();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$7(LLMProjectConfigurable this$0, LLMProjectSettingsManager $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleFile().withTitle(LLMBundle.message("project.settings.project.review.rules.path.dialog.title", new Object[0])).withDescription(LLMBundle.message("project.settings.project.review.rules.path.dialog.description", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withDescription(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)Cell.label$default((Cell)$this$row.textFieldWithBrowseButton(fileChooserDescriptor, this$0.project, arg_0 -> LLMProjectConfigurable.createPanel$lambda$3$7$0(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE), (String)LLMBundle.message("project.settings.project.review.rules.path.field", new Object[0]), null, (int)2, null), (Function0)((Function0)new Function0<String>((Object)$settings){

            public final String invoke() {
                return ((LLMProjectSettingsManager)this.receiver).getProjectReviewRulesFilePath();
            }
        }), (Function1)((Function1)new Function1<String, Unit>((Object)$settings){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LLMProjectSettingsManager)this.receiver).setProjectReviewRulesFilePath(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$3$7$0(LLMProjectConfigurable this$0, VirtualFile it) {
        Object object;
        Path projectRootPath;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path selectedPath = NioPathUtil.toNioPathOrNull((String)string);
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this$0.project);
        Path path = projectRootPath = virtualFile != null ? virtualFile.toNioPath() : null;
        if (projectRootPath != null && selectedPath != null) {
            Path path2 = projectRootPath.relativize(selectedPath);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
            object = ((Object)path2).toString();
        } else {
            object = VirtualFileUtil.toNioPathOrNull((VirtualFile)it);
            if (object == null || (object = object.toString()) == null) {
                String string2 = it.getPresentableUrl();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableUrl(...)");
            }
        }
        return object;
    }
}

