/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.ui.activation.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.activation.data.model.AieProvisionStatus;
import com.intellij.ml.llm.activation.state.manager.AiaActivationManager;
import com.intellij.ml.llm.activation.state.model.AiaActivation;
import com.intellij.ml.llm.activation.state.model.AiaActivationTrackUnknown;
import com.intellij.ml.llm.activation.state.model.IdeLicenseAiAllowancePending;
import com.intellij.ml.llm.activation.state.model.IdeLicenseAiAllowanceStep;
import com.intellij.ml.llm.activation.state.model.Outcome;
import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.settings.LlmSettingsUtils;
import com.intellij.ml.llm.core.statistics.fus.AiaAccountsUsageCollector;
import com.intellij.ml.llm.core.statistics.fus.AiaLlmLoginFlowEventLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.productMode.IdeProductMode;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a!\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u001a%\u0010\u0000\u001a\u00020\u0005*\u00020\u00072\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u001a\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\tH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001c\u0010\u0015\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001c\u0010\u0018\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001c\u0010\u0019\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u001a\u001a\u00020\u0005*\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001cH\u0000\u00a8\u0006\u001e"}, d2={"showOnlyIfByokEnabled", "Lcom/intellij/openapi/ui/DialogPanel;", "init", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lkotlin/ExtensionFunctionType;", "Lcom/intellij/ui/dsl/builder/Row;", "isDisabledByPolicy", "", "activation", "Lcom/intellij/ml/llm/activation/state/model/AiaActivation;", "isCodex", "getActivationState", "Lkotlinx/coroutines/flow/StateFlow;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "createIsDisabledByPolicyPredicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "createIsCodexDisabledByPolicyPredicate", "createIsDisabledPredicate", "byokButton", "project", "Lcom/intellij/openapi/project/Project;", "acpAgentButton", "codexButton", "sectionWithHelpTooltip", "text", "", "tooltip", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\naiaUiElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 aiaUiElements.kt\ncom/intellij/ml/llm/core/ui/activation/util/AiaUiElementsKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n42#2,3:122\n1#3:125\n*S KotlinDebug\n*F\n+ 1 aiaUiElements.kt\ncom/intellij/ml/llm/core/ui/activation/util/AiaUiElementsKt\n*L\n58#1:122,3\n*E\n"})
public final class AiaUiElementsKt {
    @NotNull
    public static final DialogPanel showOnlyIfByokEnabled(@NotNull Function1<? super Panel, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (!Registry.Companion.is("llm.byok.enabled")) {
            return BuilderKt.panel(AiaUiElementsKt::showOnlyIfByokEnabled$lambda$0);
        }
        return BuilderKt.panel(arg_0 -> AiaUiElementsKt.showOnlyIfByokEnabled$lambda$1(init, arg_0));
    }

    public static final void showOnlyIfByokEnabled(@NotNull Row $this$showOnlyIfByokEnabled, @NotNull Function1<? super Row, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)$this$showOnlyIfByokEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        if (!Registry.Companion.is("llm.byok.enabled")) {
            return;
        }
        init.invoke((Object)$this$showOnlyIfByokEnabled);
    }

    private static final boolean isDisabledByPolicy(AiaActivation activation2, boolean isCodex) {
        boolean bl;
        if (LlmSettingsUtils.INSTANCE.isProhibitedByProvisioner(activation2.getJbaiActivation(), (Function1<? super AieProvisionStatus.AieActivated, Boolean>)((Function1)AiaUiElementsKt::isDisabledByPolicy$lambda$0))) {
            bl = isCodex && !Registry.Companion.is("llm.allow.codex.login.aie");
        } else {
            IdeLicenseAiAllowanceStep ideLicenseAiAllowanceStep = activation2.getThirdPartyActivation().getAiAllowanceStep();
            bl = (ideLicenseAiAllowanceStep != null ? (IdeLicenseAiAllowancePending)Outcome.incompleteOrNull-impl((Object)ideLicenseAiAllowanceStep.getOutcome-X8CKn68()) : null) instanceof IdeLicenseAiAllowancePending.IdeLicenseAiProhibited;
        }
        return bl;
    }

    static /* synthetic */ boolean isDisabledByPolicy$default(AiaActivation aiaActivation, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return AiaUiElementsKt.isDisabledByPolicy(aiaActivation, bl);
    }

    private static final StateFlow<AiaActivation> getActivationState(CoroutineScope scope) {
        boolean $i$f$service = false;
        Class<AiaActivationManager> serviceClass$iv = AiaActivationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AiaActivationManager it = (AiaActivationManager)object;
        boolean bl = false;
        return FlowKt.stateIn((Flow)((Flow)it.getActivationState()), (CoroutineScope)scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)it.getActivation());
    }

    @NotNull
    public static final ComponentPredicate createIsDisabledByPolicyPredicate(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ComponentPredicateKt.predicate(AiaUiElementsKt.getActivationState(scope), (CoroutineScope)scope, AiaUiElementsKt::createIsDisabledByPolicyPredicate$lambda$0);
    }

    @NotNull
    public static final ComponentPredicate createIsCodexDisabledByPolicyPredicate(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ComponentPredicateKt.predicate(AiaUiElementsKt.getActivationState(scope), (CoroutineScope)scope, AiaUiElementsKt::createIsCodexDisabledByPolicyPredicate$lambda$0);
    }

    @NotNull
    public static final ComponentPredicate createIsDisabledPredicate(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ComponentPredicateKt.predicate(AiaUiElementsKt.getActivationState(scope), (CoroutineScope)scope, AiaUiElementsKt::createIsDisabledPredicate$lambda$0);
    }

    public static final void byokButton(@NotNull Row $this$byokButton, @NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)$this$byokButton, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        AiaUiElementsKt.showOnlyIfByokEnabled($this$byokButton, (Function1<? super Row, Unit>)((Function1)arg_0 -> AiaUiElementsKt.byokButton$lambda$0(scope, project, arg_0)));
    }

    public static final void acpAgentButton(@NotNull Row $this$acpAgentButton, @NotNull Project project, @NotNull CoroutineScope scope) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$acpAgentButton, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ComponentPredicate isDisabledPredicate = AiaUiElementsKt.createIsDisabledPredicate(scope);
        Cell $this$acpAgentButton_u24lambda_u241 = cell = $this$acpAgentButton.button(LLMBundle.message("panel.acp.agent.button", new Object[0]), arg_0 -> AiaUiElementsKt.acpAgentButton$lambda$0(project, arg_0));
        boolean bl = false;
        ((JButton)$this$acpAgentButton_u24lambda_u241.getComponent()).setIcon(AllIcons.General.Add);
        cell.enabledIf(ComponentPredicateKt.not((ComponentPredicate)isDisabledPredicate));
    }

    public static final void codexButton(@NotNull Row $this$codexButton, @NotNull Project project, @NotNull CoroutineScope scope) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$codexButton, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ComponentPredicate isDisabledByPolicyPredicate = AiaUiElementsKt.createIsCodexDisabledByPolicyPredicate(scope);
        Cell $this$codexButton_u24lambda_u241 = cell = $this$codexButton.button(LLMBundle.message("panel.codex.auth.button", new Object[0]), arg_0 -> AiaUiElementsKt.codexButton$lambda$0(project, arg_0));
        boolean bl = false;
        ((JButton)$this$codexButton_u24lambda_u241.getComponent()).setIcon(MLLlmIcons.Openai);
        cell.enabledIf(ComponentPredicateKt.not((ComponentPredicate)isDisabledByPolicyPredicate)).visible(IdeProductMode.Companion.isMonolith());
    }

    public static final void sectionWithHelpTooltip(@NotNull Row $this$sectionWithHelpTooltip, @Nls @NotNull String text, @Nls @NotNull String tooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$sectionWithHelpTooltip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        ContextHelpLabel contextHelpLabel = ContextHelpLabel.create((String)tooltip);
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"create(...)");
        ContextHelpLabel help = contextHelpLabel;
        Row.comment$default((Row)$this$sectionWithHelpTooltip, (String)text, (int)0, null, (int)6, null).gap(RightGap.SMALL);
        $this$sectionWithHelpTooltip.cell((JComponent)help);
    }

    private static final Unit showOnlyIfByokEnabled$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        return Unit.INSTANCE;
    }

    private static final Unit showOnlyIfByokEnabled$lambda$1(Function1 $init, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $init.invoke((Object)$this$panel);
        return Unit.INSTANCE;
    }

    private static final boolean isDisabledByPolicy$lambda$0(AieProvisionStatus.AieActivated it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isThirdPartyProvidersAllowed();
    }

    private static final boolean createIsDisabledByPolicyPredicate$lambda$0(AiaActivation activation2) {
        Intrinsics.checkNotNullParameter((Object)activation2, (String)"activation");
        return AiaUiElementsKt.isDisabledByPolicy$default(activation2, false, 2, null);
    }

    private static final boolean createIsCodexDisabledByPolicyPredicate$lambda$0(AiaActivation activation2) {
        Intrinsics.checkNotNullParameter((Object)activation2, (String)"activation");
        return AiaUiElementsKt.isDisabledByPolicy(activation2, true);
    }

    private static final boolean createIsDisabledPredicate$lambda$0(AiaActivation activation2) {
        Intrinsics.checkNotNullParameter((Object)activation2, (String)"activation");
        return activation2.getJbaiActivation() instanceof AiaActivationTrackUnknown || AiaUiElementsKt.isDisabledByPolicy$default(activation2, false, 2, null);
    }

    private static final Unit byokButton$lambda$0(CoroutineScope $scope, Project $project, Row $this$showOnlyIfByokEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$showOnlyIfByokEnabled, (String)"$this$showOnlyIfByokEnabled");
        ComponentPredicate isDisabledPredicate = AiaUiElementsKt.createIsDisabledPredicate($scope);
        ComponentPredicate isDisabledByPolicyPredicate = AiaUiElementsKt.createIsDisabledByPolicyPredicate($scope);
        $this$showOnlyIfByokEnabled.panel(arg_0 -> AiaUiElementsKt.byokButton$lambda$0$0(isDisabledByPolicyPredicate, isDisabledPredicate, $project, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$0(ComponentPredicate $isDisabledByPolicyPredicate, ComponentPredicate $isDisabledPredicate, Project $project, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiaUiElementsKt.byokButton$lambda$0$0$0($isDisabledPredicate, $project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, AiaUiElementsKt::byokButton$lambda$0$0$1, (int)1, null).visibleIf($isDisabledByPolicyPredicate);
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$0$0(ComponentPredicate $isDisabledPredicate, Project $project, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$byokButton_u24lambda_u240_u240_u240_u241 = cell = $this$row.button(LLMBundle.message("panel.byok.button", new Object[0]), arg_0 -> AiaUiElementsKt.byokButton$lambda$0$0$0$0($project, arg_0));
        boolean bl = false;
        ((JButton)$this$byokButton_u24lambda_u240_u240_u240_u241.getComponent()).setIcon(MLLlmIcons.ByokIcon);
        cell.enabledIf(ComponentPredicateKt.not((ComponentPredicate)$isDisabledPredicate));
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$0$0$0(Project $project, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AiaLlmLoginFlowEventLogger.logLoginByokClicked();
            AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance($project).getPanel();
            if (aIAContainerPanelFacade == null) break block0;
            aIAContainerPanelFacade.showByokSettings();
        }
        return Unit.INSTANCE;
    }

    private static final Unit byokButton$lambda$0$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        $this$row.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Row.comment$default((Row)$this$row, (String)LLMBundle.message("panel.byok.button.disabled.by.aie", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit acpAgentButton$lambda$0(Project $project, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "ml.llm.AcpAgentsConfigurable", null);
        return Unit.INSTANCE;
    }

    private static final Unit codexButton$lambda$0(Project $project, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AiaLlmLoginFlowEventLogger.INSTANCE.logActivateViaThirdpartyAgent($project, AiaAccountsUsageCollector.ThirdPartyAgentName.CODEX_AGENT);
            AIAContainerPanelFacade aIAContainerPanelFacade = AIAContentFacade.Companion.getInstance($project).getPanel();
            if (aIAContainerPanelFacade == null) break block0;
            aIAContainerPanelFacade.showCodexAuth();
        }
        return Unit.INSTANCE;
    }
}

