/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.grazie;

import ai.grazie.model.cloud.ContentType;
import ai.grazie.model.llm.LLMType;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.model.llm.profile.dto.v8.ChatDefinitionDTO;
import ai.grazie.model.llm.profile.dto.v8.LLMProfileDTO;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileInfo;
import com.intellij.ml.llm.core.providers.AiaLlmProviderType;
import com.intellij.ml.llm.grazie.GrazieLLMProfileID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020\u000fH\u0016J\b\u0010'\u001a\u00020\u000fH\u0016J\t\u0010(\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010*\u001a\u00020\u000f2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\u0015H\u00d6\u0001J\t\u0010.\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/grazie/GrazieLlmProfileInfo;", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileInfo;", "dto", "Lai/grazie/model/llm/profile/dto/v8/LLMProfileDTO;", "<init>", "(Lai/grazie/model/llm/profile/dto/v8/LLMProfileDTO;)V", "id", "Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "getId", "()Lcom/intellij/ml/llm/core/models/api/AiaLlmProfileID;", "modelName", "", "getModelName", "()Ljava/lang/String;", "deprecated", "", "getDeprecated", "()Z", "experimental", "getExperimental", "contextLimit", "", "getContextLimit", "()Ljava/lang/Integer;", "maxOutputTokens", "getMaxOutputTokens", "providerType", "Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;", "getProviderType", "()Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;", "providerModelId", "getProviderModelId", "supportsChat", "supportsResponses", "supportsContentType", "type", "Lai/grazie/model/cloud/ContentType;", "supportsToolCalling", "supportsSystemMessage", "supportsReasoningEffort", "component1", "copy", "equals", "other", "", "hashCode", "toString", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nGrazieLlmProfileInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieLlmProfileInfo.kt\ncom/intellij/ml/llm/grazie/GrazieLlmProfileInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class GrazieLlmProfileInfo
implements AiaLlmProfileInfo {
    @NotNull
    private final LLMProfileDTO dto;

    public GrazieLlmProfileInfo(@NotNull LLMProfileDTO dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        this.dto = dto;
    }

    @Override
    @NotNull
    public AiaLlmProfileID getId() {
        return new GrazieLLMProfileID(this.dto.getId());
    }

    @Override
    @Nullable
    public String getModelName() {
        return this.dto.getModelName();
    }

    @Override
    public boolean getDeprecated() {
        return this.dto.getDeprecated();
    }

    @Override
    public boolean getExperimental() {
        return this.dto.getExperimental();
    }

    @Override
    @Nullable
    public Integer getContextLimit() {
        return this.dto.getContextLimit();
    }

    @Override
    @Nullable
    public Integer getMaxOutputTokens() {
        return this.dto.getMaxOutputTokens();
    }

    @Override
    @NotNull
    public AiaLlmProviderType getProviderType() {
        LLMType llmType;
        LLMType lLMType;
        try {
            LLMType lLMType2;
            String string = this.dto.getProvider();
            if (string != null) {
                String it = string;
                boolean bl = false;
                lLMType2 = LLMType.valueOf((String)it);
            } else {
                lLMType2 = null;
            }
            lLMType = lLMType2;
        }
        catch (Exception exception) {
            lLMType = null;
        }
        LLMType lLMType3 = llmType = lLMType;
        return switch (lLMType3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lLMType3.ordinal()]) {
            case 1 -> AiaLlmProviderType.OpenAI;
            case 2 -> AiaLlmProviderType.Anthropic;
            case 3 -> AiaLlmProviderType.Google;
            case 4 -> AiaLlmProviderType.Grazie;
            case 5 -> AiaLlmProviderType.Alibaba;
            case 6 -> AiaLlmProviderType.Mistral;
            case 7 -> AiaLlmProviderType.HuggingFace;
            case 8 -> AiaLlmProviderType.DeepSeek;
            case 9 -> AiaLlmProviderType.Local;
            case 10 -> AiaLlmProviderType.Xai;
            case -1, 11 -> AiaLlmProviderType.Unknown;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @Nullable
    public String getProviderModelId() {
        return this.dto.getProviderModelID();
    }

    @Override
    public boolean supportsChat() {
        return ArraysKt.contains((Object[])this.dto.getFeatures(), (Object)"Chat");
    }

    @Override
    public boolean supportsResponses() {
        return ArraysKt.contains((Object[])this.dto.getFeatures(), (Object)"Responses");
    }

    @Override
    public boolean supportsContentType(@NotNull ContentType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = this.dto.getChatDefinition();
        return object != null && (object = object.getMultimediaDataDefinition()) != null && (object = object.getSupportedTypes()) != null ? object.contains(type) : false;
    }

    @Override
    public boolean supportsToolCalling() {
        ChatDefinitionDTO chatDefinitionDTO = this.dto.getChatDefinition();
        if (chatDefinitionDTO == null) {
            return false;
        }
        ChatDefinitionDTO chatDefinition = chatDefinitionDTO;
        return ArraysKt.contains((Object[])chatDefinition.getRoles(), (Object)"tool") && ArraysKt.contains((Object[])chatDefinition.getParameters(), (Object)LLMParameters.INSTANCE.getTools());
    }

    @Override
    public boolean supportsSystemMessage() {
        Object[] objectArray = this.dto.getChatDefinition();
        return objectArray != null && (objectArray = objectArray.getRoles()) != null ? ArraysKt.contains((Object[])objectArray, (Object)"system") : false;
    }

    @Override
    public boolean supportsReasoningEffort() {
        Object[] objectArray = this.dto.getChatDefinition();
        return objectArray != null && (objectArray = objectArray.getParameters()) != null ? ArraysKt.contains((Object[])objectArray, (Object)LLMParameters.INSTANCE.getReasoningEffort()) : false;
    }

    private final LLMProfileDTO component1() {
        return this.dto;
    }

    @NotNull
    public final GrazieLlmProfileInfo copy(@NotNull LLMProfileDTO dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        return new GrazieLlmProfileInfo(dto);
    }

    public static /* synthetic */ GrazieLlmProfileInfo copy$default(GrazieLlmProfileInfo grazieLlmProfileInfo, LLMProfileDTO lLMProfileDTO, int n, Object object) {
        if ((n & 1) != 0) {
            lLMProfileDTO = grazieLlmProfileInfo.dto;
        }
        return grazieLlmProfileInfo.copy(lLMProfileDTO);
    }

    @NotNull
    public String toString() {
        return "GrazieLlmProfileInfo(dto=" + this.dto + ")";
    }

    public int hashCode() {
        return this.dto.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GrazieLlmProfileInfo)) {
            return false;
        }
        GrazieLlmProfileInfo grazieLlmProfileInfo = (GrazieLlmProfileInfo)other;
        return Intrinsics.areEqual((Object)this.dto, (Object)grazieLlmProfileInfo.dto);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LLMType.values().length];
            try {
                nArray[LLMType.OpenAI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Anthropic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Google.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Grazie.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Alibaba.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Mistral.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.HuggingFace.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.DeepSeek.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Local.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Xai.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.Unknown.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

