/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0086\u0002J)\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/hub/BigDecimalProperty;", "", "key", "", "<init>", "(Ljava/lang/String;)V", "getValue", "Ljava/math/BigDecimal;", "thisRef", "property", "Lkotlin/reflect/KProperty;", "setValue", "", "value", "intellij.ml.llm.core"})
final class BigDecimalProperty {
    @NotNull
    private final String key;

    public BigDecimalProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @Nullable
    public final BigDecimal getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        String string = PropertiesComponent.getInstance().getValue(this.key);
        if (string == null) {
            return null;
        }
        String text = string;
        try {
            bigDecimal = new BigDecimal(text);
        }
        catch (NumberFormatException e) {
            AIHubNotificationManager.Companion.getLog$intellij_ml_llm_core().warn("Cannot parse " + text + " as BigDecimal, null will be used", (Throwable)e);
            bigDecimal = null;
        }
        return bigDecimal;
    }

    public final void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, @Nullable BigDecimal value) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        BigDecimal bigDecimal = value;
        PropertiesComponent.getInstance().setValue(this.key, bigDecimal != null ? bigDecimal.toString() : null);
    }
}

