/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.searchEverywhere;

import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.LLMCoroutineScope;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.searchEverywhere.AiSeContributorKt;
import com.intellij.ml.llm.searchEverywhere.AiSePatternPrivacyWrapper;
import com.intellij.ml.llm.searchEverywhere.InferenceResult;
import com.intellij.ml.llm.searchEverywhere.InferenceResultRenderer;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.Processor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\r\u0010\u000f\u001a\u00070\b\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/searchEverywhere/AiSeContributor;", "Lcom/intellij/ide/actions/searcheverywhere/WeightedSearchEverywhereContributor;", "Lcom/intellij/ml/llm/searchEverywhere/InferenceResult;", "<init>", "()V", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "getSearchProviderId", "getGroupName", "Lorg/jetbrains/annotations/Nls;", "getSortWeight", "", "showInFindResults", "", "processSelectedItem", "selected", "modifiers", "searchText", "getElementsRenderer", "Ljavax/swing/ListCellRenderer;", "intellij.ml.llm.core"})
final class AiSeContributor
implements WeightedSearchEverywhereContributor<InferenceResult> {
    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<InferenceResult>> consumer) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ProjectManager projectManager = ProjectManager.getInstance();
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
        if (project == null) {
            return;
        }
        Project project2 = project;
        CoroutineScope scope = LLMCoroutineScope.Companion.getScope(project2);
        PSString psPattern = new AiSePatternPrivacyWrapper(pattern).getPattern();
        CoreProgressManager.getInstance().executeProcessUnderProgress(AiSeContributorKt.access$aiInteractionRunnable(project2, scope, consumer, psPattern), progressIndicator);
    }

    @NotNull
    public String getSearchProviderId() {
        return "AiSeContributor";
    }

    @NotNull
    public String getGroupName() {
        return LLMBundle.message("ai.se.contributor.group.name", new Object[0]);
    }

    public int getSortWeight() {
        return 0;
    }

    public boolean showInFindResults() {
        return false;
    }

    public boolean processSelectedItem(@NotNull InferenceResult selected, int modifiers, @NotNull String searchText) {
        Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)searchText, (String)"searchText");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(selected.getOutput()));
        return true;
    }

    @NotNull
    public ListCellRenderer<? super InferenceResult> getElementsRenderer() {
        return new InferenceResultRenderer();
    }
}

