/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client.auth;

import com.agentclientprotocol.model.AuthMethod;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.acp.client.auth.ApiKeyAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.ApiKeyAuthMetadata;
import com.intellij.ml.llm.agents.acp.client.auth.GatewayAuthMetadata;
import com.intellij.ml.llm.agents.acp.client.auth.JbProxyAuthHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\f\u001a\u0004\u0018\u00010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService;", "", "<init>", "()V", "canAutoAuthenticate", "", "authMethod", "Lcom/agentclientprotocol/model/AuthMethod;", "filterVisibleMethods", "", "methods", "isUnsupportedAuthMethod", "findAutoAuthMethod", "isAutoAuthMethod", "isEnvVarAuthMethod", "Companion", "intellij.ml.llm.agents.acp"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAutoAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoAuthService.kt\ncom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n827#2:105\n855#2,2:106\n295#2,2:108\n1#3:110\n*S KotlinDebug\n*F\n+ 1 AutoAuthService.kt\ncom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService\n*L\n49#1:105\n49#1:106,2\n69#1:108,2\n*E\n"})
public final class AutoAuthService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex ENV_VAR_PATTERN = new Regex("[A-Z_]+_API_KEY");

    public final boolean canAutoAuthenticate(@NotNull AuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)authMethod, (String)"authMethod");
        ApiKeyAuthMetadata apiKeyMeta = ApiKeyAuthMetadata.Companion.fromMeta(authMethod.get_meta());
        if (apiKeyMeta != null) {
            return ApiKeyAuthHandler.Companion.canAuthenticate(apiKeyMeta.getProvider());
        }
        GatewayAuthMetadata jbProxyMeta = GatewayAuthMetadata.Companion.fromMeta(authMethod.get_meta());
        if (jbProxyMeta != null) {
            return JbProxyAuthHandler.Companion.canAuthenticate();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AuthMethod> filterVisibleMethods(@NotNull List<? extends AuthMethod> methods) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        Iterable $this$filterNot$iv = methods;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AuthMethod it = (AuthMethod)element$iv$iv;
            boolean bl = false;
            if (this.isUnsupportedAuthMethod(it) || this.isAutoAuthMethod(it) && !this.canAutoAuthenticate(it) || this.isEnvVarAuthMethod(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isUnsupportedAuthMethod(AuthMethod authMethod) {
        return authMethod instanceof AuthMethod.UnknownAuthMethod || authMethod instanceof AuthMethod.EnvVarAuth;
    }

    @Nullable
    public final AuthMethod findAutoAuthMethod(@NotNull List<? extends AuthMethod> methods) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            Iterable $this$firstOrNull$iv = methods;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AuthMethod it = (AuthMethod)element$iv;
                boolean bl = false;
                if (!(this.isAutoAuthMethod(it) && this.canAutoAuthenticate(it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isAutoAuthMethod(AuthMethod authMethod) {
        return ApiKeyAuthMetadata.Companion.fromMeta(authMethod.get_meta()) != null || GatewayAuthMetadata.Companion.fromMeta(authMethod.get_meta()) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEnvVarAuthMethod(AuthMethod authMethod) {
        if (AutoAuthService.Companion.containsEnvVarPattern(authMethod.getName())) return true;
        String string = authMethod.getDescription();
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        boolean bl2 = AutoAuthService.Companion.containsEnvVarPattern(it);
        if (!bl2) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService$Companion;", "", "<init>", "()V", "ENV_VAR_PATTERN", "Lkotlin/text/Regex;", "containsEnvVarPattern", "", "text", "", "getInstance", "Lcom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService;", "intellij.ml.llm.agents.acp"})
    @SourceDebugExtension(value={"SMAP\nAutoAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoAuthService.kt\ncom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,104:1\n42#2,3:105\n*S KotlinDebug\n*F\n+ 1 AutoAuthService.kt\ncom/intellij/ml/llm/agents/acp/client/auth/AutoAuthService$Companion\n*L\n101#1:105,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean containsEnvVarPattern(String text2) {
            return ENV_VAR_PATTERN.containsMatchIn((CharSequence)text2);
        }

        @NotNull
        public final AutoAuthService getInstance() {
            boolean $i$f$service = false;
            Class<AutoAuthService> serviceClass$iv = AutoAuthService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AutoAuthService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

