/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.config;

import com.intellij.ml.llm.agents.acp.config.AcpConfiguration;
import com.intellij.ml.llm.agents.acp.config.AcpConfigurationLoaderKt;
import com.intellij.ml.llm.agents.acp.config.AgentServerConfig;
import com.intellij.ml.llm.agents.acp.config.DefaultMcpSettings;
import com.intellij.ml.llm.agents.acp.registry.AcpJson;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/agents/acp/config/AcpConfigurationLoader;", "", "<init>", "()V", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "getConfigFilePath", "Ljava/nio/file/Path;", "loadFromPath", "Lcom/intellij/ml/llm/agents/acp/config/AcpConfiguration;", "configPath", "save", "", "config", "createDefaultConfig", "validate", "", "", "Lcom/intellij/ml/llm/agents/acp/config/AgentServerConfig;", "expandPath", "path", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpConfigurationLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpConfigurationLoader.kt\ncom/intellij/ml/llm/agents/acp/config/AcpConfigurationLoader\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,117:1\n222#2:118\n*S KotlinDebug\n*F\n+ 1 AcpConfigurationLoader.kt\ncom/intellij/ml/llm/agents/acp/config/AcpConfigurationLoader\n*L\n48#1:118\n*E\n"})
public final class AcpConfigurationLoader {
    @NotNull
    public static final AcpConfigurationLoader INSTANCE = new AcpConfigurationLoader();

    private AcpConfigurationLoader() {
    }

    private final Json getJson() {
        return AcpJson.INSTANCE.getLenient();
    }

    @NotNull
    public final Path getConfigFilePath() {
        String home = System.getProperty("user.home");
        String[] stringArray = new String[]{".jetbrains", "acp.json"};
        Path path = Paths.get(home, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AcpConfiguration loadFromPath(@NotNull Path configPath) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileNotFoundException("ACP configuration file not found at: " + configPath);
        }
        String content2 = PathsKt.readText$default((Path)configPath, null, (int)1, null);
        if (StringsKt.isBlank((CharSequence)content2)) {
            return new AcpConfiguration(null, null, null, 7, null);
        }
        Json json = this.getJson();
        String string$iv = content2;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        AcpConfiguration config = (AcpConfiguration)this_$iv.decodeFromString((DeserializationStrategy)AcpConfiguration.Companion.serializer(), string$iv);
        return config;
    }

    public final void save(@NotNull AcpConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Path configPath = this.getConfigFilePath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            String content2 = this.getJson().encodeToString((SerializationStrategy)AcpConfiguration.Companion.serializer(), (Object)config);
            Files.writeString(configPath, (CharSequence)content2, new OpenOption[0]);
            AcpConfigurationLoaderKt.access$getLogger$p().info("Saved ACP configuration to " + configPath);
        }
        catch (Exception e) {
            AcpConfigurationLoaderKt.access$getLogger$p().error("Failed to save ACP configuration to " + configPath, (Throwable)e);
        }
    }

    public final void createDefaultConfig() {
        AcpConfiguration config = new AcpConfiguration(new DefaultMcpSettings(true, false), MapsKt.emptyMap(), null, 4, null);
        this.save(config);
        AcpConfigurationLoaderKt.access$getLogger$p().info("Created default ACP configuration at " + this.getConfigFilePath());
    }

    @NotNull
    public final List<String> validate(@NotNull AgentServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List errors = new ArrayList();
        if (StringsKt.isBlank((CharSequence)config.getCommand())) {
            errors.add("Command cannot be empty");
        }
        return errors;
    }

    @NotNull
    public final String expandPath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null)) {
            String string2 = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            string = StringsKt.replaceFirst$default((String)path, (String)"~", (String)string2, (boolean)false, (int)4, null);
        } else {
            string = path;
        }
        return string;
    }
}

