/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.diagnostic;

import com.intellij.ml.llm.agents.acp.diagnostic.LineBufferLogger;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/AcpLoggingOutputStream;", "Ljava/io/OutputStream;", "delegate", "<init>", "(Ljava/io/OutputStream;)V", "lineBufferLogger", "Lcom/intellij/ml/llm/agents/acp/diagnostic/LineBufferLogger;", "write", "", "b", "", "", "off", "len", "flush", "close", "intellij.ml.llm.agents.acp"})
public final class AcpLoggingOutputStream
extends OutputStream {
    @NotNull
    private final OutputStream delegate;
    @NotNull
    private final LineBufferLogger lineBufferLogger;

    public AcpLoggingOutputStream(@NotNull OutputStream delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.lineBufferLogger = new LineBufferLogger("OUT: ");
    }

    @Override
    public void write(int b) {
        this.lineBufferLogger.append(b);
        this.delegate.write(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.lineBufferLogger.append(b, off, len);
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() {
        this.lineBufferLogger.flush();
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.lineBufferLogger.flush();
        this.delegate.close();
    }
}

