/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.ml.llm.agents.acp.registry.AcpAgentIdKt;
import com.intellij.ml.llm.agents.acp.registry.AcpCustomAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpPredefinedAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpRegistryAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpRemoteAgentId;
import java.lang.annotation.Annotation;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000 \b2\u00020\u0001:\u0001\bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u0082\u0001\u0004\t\n\u000b\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "", "rawId", "", "getRawId", "()Ljava/lang/String;", "fullId", "getFullId", "Companion", "Lcom/intellij/ml/llm/agents/acp/registry/AcpCustomAgentId;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpPredefinedAgentId;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRegistryAgentId;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRemoteAgentId;", "intellij.ml.llm.agents.acp"})
public sealed interface AcpAgentId
permits AcpCustomAgentId, AcpPredefinedAgentId, AcpRegistryAgentId, AcpRemoteAgentId {
    @NotNull
    public static final Companion Companion = com.intellij.ml.llm.agents.acp.registry.AcpAgentId$Companion.$$INSTANCE;
    @NotNull
    public static final String CUSTOM_PREFIX = "acp.";
    @NotNull
    public static final String REGISTRY_PREFIX = "acp.registry.";
    @NotNull
    public static final String REMOTE_PREFIX = "acp.remote.";

    @NotNull
    public String getRawId();

    @NotNull
    public String getFullId();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId$Companion;", "", "<init>", "()V", "CUSTOM_PREFIX", "", "REGISTRY_PREFIX", "REMOTE_PREFIX", "parse", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "id", "tryToParse", "isAcpAgent", "", "sanitize", "name", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String CUSTOM_PREFIX = "acp.";
        @NotNull
        public static final String REGISTRY_PREFIX = "acp.registry.";
        @NotNull
        public static final String REMOTE_PREFIX = "acp.remote.";

        private Companion() {
        }

        @NotNull
        public final AcpAgentId parse(@NotNull String id) {
            AcpAgentId acpAgentId;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (AcpAgentIdKt.getPREDEFINED_IDS().contains(id)) {
                acpAgentId = new AcpPredefinedAgentId(id);
            } else if (StringsKt.startsWith$default((String)id, (String)"acp.registry.", (boolean)false, (int)2, null)) {
                acpAgentId = new AcpRegistryAgentId(StringsKt.removePrefix((String)id, (CharSequence)"acp.registry."));
            } else if (StringsKt.startsWith$default((String)id, (String)"acp.remote.", (boolean)false, (int)2, null)) {
                acpAgentId = new AcpRemoteAgentId(StringsKt.removePrefix((String)id, (CharSequence)"acp.remote."));
            } else if (StringsKt.startsWith$default((String)id, (String)"acp.", (boolean)false, (int)2, null)) {
                acpAgentId = new AcpCustomAgentId(StringsKt.removePrefix((String)id, (CharSequence)"acp."));
            } else {
                throw new IllegalArgumentException("Invalid ACP agent ID, missing prefix: " + id);
            }
            return acpAgentId;
        }

        @Nullable
        public final AcpAgentId tryToParse(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!this.isAcpAgent(id)) {
                return null;
            }
            return this.parse(id);
        }

        public final boolean isAcpAgent(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return StringsKt.startsWith$default((String)id, (String)"acp.", (boolean)false, (int)2, null) || AcpAgentIdKt.getPREDEFINED_IDS().contains(id);
        }

        @NotNull
        public final String sanitize(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Object object = string;
            Regex regex = new Regex("[^a-z0-9]+");
            String string2 = "-";
            String string3 = regex.replace((CharSequence)object, string2);
            object = new char[1];
            object[0] = 45;
            return StringsKt.trim((String)string3, (char[])object);
        }

        @NotNull
        public final KSerializer<AcpAgentId> serializer() {
            return (KSerializer)new SealedClassSerializer("com.intellij.ml.llm.agents.acp.registry.AcpAgentId", Reflection.getOrCreateKotlinClass(AcpAgentId.class), new KClass[0], new KSerializer[0], new Annotation[0]);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

