/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.ml.llm.agents.ChatAgent;
import com.intellij.ml.llm.agents.acp.config.AcpAgentConfig;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentFactory;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentRegistryKt;
import com.intellij.ml.llm.agents.acp.registry.AgentRegistration;
import com.intellij.ml.llm.agents.acp.registry.DynamicAcpChatAgent;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.ml.llm.agents.acp.registry.RegistryStatistics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020\nH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "localAgents", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "Lcom/intellij/ml/llm/agents/acp/registry/AgentRegistration;", "externalAgents", "registerLocalAgent", "", "agentId", "config", "Lcom/intellij/ml/llm/agents/acp/config/AcpAgentConfig;", "unregisterLocalAgent", "isLocalAgentRegistered", "", "getLocalAgentIds", "", "registerExternalAgent", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentFactory$CreateResult;", "agent", "Lcom/intellij/ml/llm/agents/acp/registry/ExternalAgent;", "unregisterExternalAgent", "agnetId", "isExternalAgentRegistered", "getExternalAgentIds", "unregisterAllExternalAgents", "getStatistics", "Lcom/intellij/ml/llm/agents/acp/registry/RegistryStatistics;", "getRegisteredAgentIds", "registerChatAgentDynamically", "Lcom/intellij/ml/llm/agents/ChatAgent;", "unregisterAllLocalAgents", "dispose", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpAgentRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpAgentRegistry.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1869#2,2:224\n1869#2,2:226\n*S KotlinDebug\n*F\n+ 1 AcpAgentRegistry.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpAgentRegistry\n*L\n149#1:224,2\n193#1:226,2\n*E\n"})
public final class AcpAgentRegistry
implements Disposable {
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, AgentRegistration> localAgents = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, AgentRegistration> externalAgents = new ConcurrentHashMap();

    public final void registerLocalAgent(@NotNull AcpAgentId agentId, @NotNull AcpAgentConfig config) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        AcpAgentRegistryKt.access$getLogger$p().info("Registering local agent: " + config.getName() + " (id: " + agentId + ")");
        String string = config.getName();
        DynamicAcpChatAgent agent2 = new DynamicAcpChatAgent(string, config, agentId, null, null, null, null, null, 248, null);
        AgentRegistration agentRegistration = this.localAgents.put(agentId, new AgentRegistration(agent2, this.registerChatAgentDynamically(agent2)));
        if (agentRegistration != null) {
            AgentRegistration it = agentRegistration;
            boolean bl = false;
            Disposer.dispose((Disposable)it.getDisposable());
        }
        AcpAgentRegistryKt.access$getLogger$p().info("Successfully registered local agent: " + config.getName());
    }

    public final void unregisterLocalAgent(@NotNull AcpAgentId agentId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            AgentRegistration agentRegistration = this.localAgents.remove(agentId);
            if (agentRegistration == null) break block0;
            AgentRegistration registration = agentRegistration;
            boolean bl = false;
            AcpAgentRegistryKt.access$getLogger$p().info("Unregistering local agent: " + registration.getAgent().getName());
            Disposer.dispose((Disposable)registration.getDisposable());
        }
    }

    public final boolean isLocalAgentRegistered(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        return this.localAgents.containsKey(agentId);
    }

    @NotNull
    public final Set<AcpAgentId> getLocalAgentIds() {
        Set set = this.localAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set);
    }

    @NotNull
    public final AcpAgentFactory.CreateResult registerExternalAgent(@NotNull AcpAgentId agentId, @NotNull ExternalAgent agent2) {
        AcpAgentFactory.CreateResult createResult;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)agent2, (String)"agent");
        if (this.localAgents.containsKey(agentId)) {
            return new AcpAgentFactory.CreateResult.Unavailable("Already registered from local config");
        }
        AcpAgentFactory.CreateResult result2 = AcpAgentFactory.INSTANCE.create(agent2);
        if (result2 instanceof AcpAgentFactory.CreateResult.Success) {
            DynamicAcpChatAgent chatAgent = ((AcpAgentFactory.CreateResult.Success)result2).getAgent();
            AgentRegistration agentRegistration = this.externalAgents.put(agentId, new AgentRegistration(chatAgent, this.registerChatAgentDynamically(chatAgent)));
            if (agentRegistration != null) {
                AgentRegistration it = agentRegistration;
                boolean bl = false;
                AcpAgentRegistryKt.access$getLogger$p().debug("Replacing existing external agent: " + it.getAgent().getName());
                Disposer.dispose((Disposable)it.getDisposable());
            }
            AcpAgentRegistryKt.access$getLogger$p().info("Registered external agent: " + chatAgent.getName() + " (id: " + agentId + ")");
            createResult = result2;
        } else if (result2 instanceof AcpAgentFactory.CreateResult.Unavailable) {
            AcpAgentRegistryKt.access$getLogger$p().info("Skipping external agent " + agentId + ": " + ((AcpAgentFactory.CreateResult.Unavailable)result2).getReason());
            createResult = result2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return createResult;
    }

    public final void unregisterExternalAgent(@NotNull AcpAgentId agnetId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)agnetId, (String)"agnetId");
            AgentRegistration agentRegistration = this.externalAgents.remove(agnetId);
            if (agentRegistration == null) break block0;
            AgentRegistration registration = agentRegistration;
            boolean bl = false;
            AcpAgentRegistryKt.access$getLogger$p().info("Unregistering external agent: " + registration.getAgent().getName());
            Disposer.dispose((Disposable)registration.getDisposable());
        }
    }

    public final boolean isExternalAgentRegistered(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        return this.externalAgents.containsKey(agentId);
    }

    @NotNull
    public final Set<AcpAgentId> getExternalAgentIds() {
        Set set = this.externalAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toSet((Iterable)set);
    }

    public final void unregisterAllExternalAgents() {
        AcpAgentRegistryKt.access$getLogger$p().info("Unregistering all external ACP agents (" + this.externalAgents.size() + ")");
        Collection<AgentRegistration> collection = this.externalAgents.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentRegistration registration = (AgentRegistration)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)registration.getDisposable());
        }
        this.externalAgents.clear();
    }

    @NotNull
    public final RegistryStatistics getStatistics() {
        int n = this.localAgents.size() + this.externalAgents.size();
        Set set = this.localAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        List list = CollectionsKt.toList((Iterable)set);
        Set set2 = this.externalAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return new RegistryStatistics(n, list, CollectionsKt.toList((Iterable)set2));
    }

    @NotNull
    public final Set<AcpAgentId> getRegisteredAgentIds() {
        Set set = this.localAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Set set2 = this.externalAgents.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return SetsKt.plus((Set)set, (Iterable)set2);
    }

    private final Disposable registerChatAgentDynamically(ChatAgent agent2) {
        Application app = ApplicationManager.getApplication();
        ExtensionsArea extensionsArea = app.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getExtensionArea(...)");
        ExtensionsArea area = extensionsArea;
        ExtensionPoint ep = area.getExtensionPoint(ChatAgent.Companion.getEP_NAME());
        Disposable disposable = Disposer.newDisposable((String)("acp-agent:" + agent2.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable registration = disposable;
        ep.registerExtension((Object)agent2, registration);
        AcpAgentRegistryKt.access$getLogger$p().debug("Registered ChatAgent dynamically: " + agent2.getId());
        return registration;
    }

    private final void unregisterAllLocalAgents() {
        AcpAgentRegistryKt.access$getLogger$p().info("Unregistering all local ACP agents (" + this.localAgents.size() + ")");
        Collection<AgentRegistration> collection = this.localAgents.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AgentRegistration registration = (AgentRegistration)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)registration.getDisposable());
        }
        this.localAgents.clear();
    }

    public void dispose() {
        this.unregisterAllLocalAgents();
        this.unregisterAllExternalAgents();
    }
}

