/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ml.llm.agents.acp.AcpBundle;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentInstallationState;
import com.intellij.ml.llm.agents.acp.registry.AcpDistributionResolver;
import com.intellij.ml.llm.agents.acp.registry.AcpPaths;
import com.intellij.ml.llm.agents.acp.registry.AcpRuntimeManagerKt;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.ml.llm.agents.acp.registry.Platform;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 :2\u00020\u0001:\u0004:;<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0006J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u0006J$\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010'J$\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u001b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010*J,\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\bH\u0002J$\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u001b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010*J,\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010,J\u0018\u00102\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\bH\u0002J\u001a\u00103\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0016H\u0002J\u0010\u00105\u001a\u00020.2\u0006\u00104\u001a\u00020\u0016H\u0002J\u000e\u00106\u001a\u00020.2\u0006\u00107\u001a\u000208J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aRN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager;", "", "<init>", "()V", "downloadingRuntimes", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeType;", "kotlin.jvm.PlatformType", "", "_downloadingRuntimesFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "downloadingRuntimesFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getDownloadingRuntimesFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "downloadMutexes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlinx/coroutines/sync/Mutex;", "isRuntimeAvailable", "type", "getRuntimePath", "Ljava/nio/file/Path;", "getSystemRuntime", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeInfo;", "getExecutableExtensions", "", "", "getManagedRuntime", "findRuntimeInVersionDir", "versionDir", "findExecutableInBinDir", "dir", "name", "getManagedRuntimeWithEnv", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$ManagedRuntimeInfo;", "ensureRuntime", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeType;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadNode", "version", "(Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "targetPlatform", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reorganizeNodeDirectory", "", "runtimeDir", "isWindows", "downloadUv", "reorganizeUvDirectory", "getVersion", "path", "makeExecutable", "downloadRuntimeForAgentInBackground", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "getAllManagedRuntimes", "Companion", "RuntimeType", "RuntimeInfo", "ManagedRuntimeInfo", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpRuntimeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpRuntimeManager.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,776:1\n42#2,3:777\n42#2,3:780\n42#2,3:794\n42#2,3:797\n42#2,3:800\n116#3,11:783\n1#4:803\n*S KotlinDebug\n*F\n+ 1 AcpRuntimeManager.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager\n*L\n189#1:777,3\n263#1:780,3\n369#1:794,3\n541#1:797,3\n697#1:800,3\n293#1:783,11\n*E\n"})
public final class AcpRuntimeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ConcurrentHashMap.KeySetView<RuntimeType, Boolean> downloadingRuntimes = ConcurrentHashMap.newKeySet();
    @NotNull
    private final MutableStateFlow<Set<RuntimeType>> _downloadingRuntimesFlow = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
    @NotNull
    private final StateFlow<Set<RuntimeType>> downloadingRuntimesFlow = FlowKt.asStateFlow(this._downloadingRuntimesFlow);
    @NotNull
    private final ConcurrentHashMap<RuntimeType, Mutex> downloadMutexes = new ConcurrentHashMap();
    @NotNull
    private static final String DEFAULT_NODE_VERSION = "24.13.0";
    @NotNull
    private static final String DEFAULT_UV_VERSION = "0.5.11";
    @NotNull
    private static final String NODE_DOWNLOAD_BASE = "https://nodejs.org/dist";
    @NotNull
    private static final String UV_DOWNLOAD_BASE = "https://github.com/astral-sh/uv/releases/download";

    @NotNull
    public final StateFlow<Set<RuntimeType>> getDownloadingRuntimesFlow() {
        return this.downloadingRuntimesFlow;
    }

    public final boolean isRuntimeAvailable(@NotNull RuntimeType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return this.getSystemRuntime(type2) != null || this.getManagedRuntime(type2) != null;
    }

    @Nullable
    public final Path getRuntimePath(@NotNull RuntimeType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        RuntimeInfo systemRuntime = this.getSystemRuntime(type2);
        if (systemRuntime != null) {
            return systemRuntime.getPath();
        }
        RuntimeInfo runtimeInfo2 = this.getManagedRuntime(type2);
        return runtimeInfo2 != null ? runtimeInfo2.getPath() : null;
    }

    @Nullable
    public final RuntimeInfo getSystemRuntime(@NotNull RuntimeType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        String string = (String)EnvironmentUtil.getEnvironmentMap().get("PATH");
        if (string == null) {
            return null;
        }
        String pathEnv = string;
        String pathSeparator = File.pathSeparator;
        List<String> executableExtensions = this.getExecutableExtensions();
        CharSequence charSequence = pathEnv;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNull((Object)pathSeparator);
        stringArray[0] = pathSeparator;
        for (String dir : StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            for (String ext : executableExtensions) {
                String[] stringArray2 = new String[]{type2.getCommandName() + ext};
                Path path = Path.of(dir, stringArray2);
                Intrinsics.checkNotNull((Object)path);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || !Files.isExecutable(path)) continue;
                String version = this.getVersion(type2, path);
                return new RuntimeInfo(type2, version, path, false);
            }
        }
        return null;
    }

    private final List<String> getExecutableExtensions() {
        List list;
        if (OS.CURRENT == OS.Windows) {
            Object[] objectArray = new String[]{".exe", ".cmd", ".bat"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)"");
        }
        return list;
    }

    @Nullable
    public final RuntimeInfo getManagedRuntime(@NotNull RuntimeType type2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        boolean $i$f$service = false;
        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path runtimesDir = ((AcpPaths)object).getRuntimesDir();
        RuntimeType baseType = switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> RuntimeType.NODE;
            case 2 -> RuntimeType.UV;
            default -> type2;
        };
        switch (WhenMappings.$EnumSwitchMapping$0[baseType.ordinal()]) {
            case 3: {
                string = DEFAULT_NODE_VERSION;
                break;
            }
            case 4: {
                string = DEFAULT_UV_VERSION;
                break;
            }
            default: {
                return null;
            }
        }
        String defaultVersion = string;
        Path runtimeDir = runtimesDir.resolve(baseType.getCommandName());
        Intrinsics.checkNotNull((Object)runtimeDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(runtimeDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path defaultVersionDir = runtimeDir.resolve(defaultVersion);
        Intrinsics.checkNotNull((Object)defaultVersionDir);
        return this.findRuntimeInVersionDir(defaultVersionDir, type2);
    }

    private final RuntimeInfo findRuntimeInVersionDir(Path versionDir, RuntimeType type2) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(versionDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        String execName = type2.getCommandName();
        Path executable = this.findExecutableInBinDir(versionDir, execName);
        if (executable != null && Files.isExecutable(executable)) {
            return new RuntimeInfo(type2, ((Object)versionDir.getFileName()).toString(), executable, true);
        }
        return null;
    }

    private final Path findExecutableInBinDir(Path dir, String name) {
        Path binDir = dir.resolve("bin");
        Intrinsics.checkNotNull((Object)binDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(binDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        for (String ext : this.getExecutableExtensions()) {
            Path exec2 = binDir.resolve(name + ext);
            Intrinsics.checkNotNull((Object)exec2);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.exists(exec2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !Files.isRegularFile(exec2, new LinkOption[0])) continue;
            return exec2;
        }
        return null;
    }

    @Nullable
    public final ManagedRuntimeInfo getManagedRuntimeWithEnv(@NotNull RuntimeType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        RuntimeInfo runtimeInfo2 = this.getManagedRuntime(type2);
        if (runtimeInfo2 == null) {
            return null;
        }
        RuntimeInfo runtimeInfo3 = runtimeInfo2;
        if (!runtimeInfo3.isManaged()) {
            return null;
        }
        RuntimeType baseType = switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> RuntimeType.NODE;
            case 2 -> RuntimeType.UV;
            default -> type2;
        };
        boolean $i$f$service = false;
        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String string = runtimeInfo3.getVersion();
        if (string == null) {
            return null;
        }
        Path runtimeDir = ((AcpPaths)object).getRuntimesDir().resolve(baseType.getCommandName()).resolve(string);
        Intrinsics.checkNotNull((Object)runtimeDir);
        return new ManagedRuntimeInfo(runtimeInfo3, runtimeDir);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object ensureRuntime(@NotNull RuntimeType type, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super RuntimeInfo> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ Object ensureRuntime$default(AcpRuntimeManager acpRuntimeManager, RuntimeType runtimeType, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return acpRuntimeManager.ensureRuntime(runtimeType, progressIndicator, (Continuation<? super RuntimeInfo>)continuation);
    }

    @Nullable
    public final Object downloadNode(@NotNull String version, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super Path> $completion) {
        return this.downloadNode(version, Platform.INSTANCE.current(), indicator, $completion);
    }

    public static /* synthetic */ Object downloadNode$default(AcpRuntimeManager acpRuntimeManager, String string, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return acpRuntimeManager.downloadNode(string, progressIndicator, (Continuation<? super Path>)continuation);
    }

    @Nullable
    public final Object downloadNode(@NotNull String version, @NotNull String targetPlatform, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super Path> $completion) {
        Pair pair;
        switch (targetPlatform) {
            case "darwin-aarch64": {
                pair = TuplesKt.to((Object)"darwin", (Object)"arm64");
                break;
            }
            case "darwin-x86_64": {
                pair = TuplesKt.to((Object)"darwin", (Object)"x64");
                break;
            }
            case "linux-aarch64": {
                pair = TuplesKt.to((Object)"linux", (Object)"arm64");
                break;
            }
            case "linux-x86_64": {
                pair = TuplesKt.to((Object)"linux", (Object)"x64");
                break;
            }
            case "windows-x86_64": {
                pair = TuplesKt.to((Object)"win", (Object)"x64");
                break;
            }
            case "windows-aarch64": {
                pair = TuplesKt.to((Object)"win", (Object)"arm64");
                break;
            }
            default: {
                AcpRuntimeManagerKt.access$getLogger$p().warn("Unsupported platform for Node.js download: " + targetPlatform);
                return null;
            }
        }
        Pair pair2 = pair;
        String os = (String)pair2.component1();
        String arch = (String)pair2.component2();
        String extension = StringsKt.startsWith$default((String)targetPlatform, (String)"windows", (boolean)false, (int)2, null) ? "zip" : "tar.gz";
        String fileName = "node-v" + version + "-" + os + "-" + arch + "." + extension;
        String url = "https://nodejs.org/dist/v" + version + "/" + fileName;
        boolean $i$f$service = false;
        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path runtimeDir = ((AcpPaths)object).getRuntimeDir("node", version);
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(indicator, version, runtimeDir, fileName, url, extension, targetPlatform, this, null){
            Object L$0;
            int label;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ String $version;
            final /* synthetic */ Path $runtimeDir;
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $url;
            final /* synthetic */ String $extension;
            final /* synthetic */ String $targetPlatform;
            final /* synthetic */ AcpRuntimeManager this$0;
            {
                this.$indicator = $indicator;
                this.$version = $version;
                this.$runtimeDir = $runtimeDir;
                this.$fileName = $fileName;
                this.$url = $url;
                this.$extension = $extension;
                this.$targetPlatform = $targetPlatform;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.$indicator;
                        if (v0 != null) {
                            var3_3 = new Object[]{this.$version};
                            v0.setText(AcpBundle.INSTANCE.message("progress.text.downloading.node", var3_3));
                        }
                        v1 = this.$indicator;
                        if (v1 != null) {
                            v1.setIndeterminate(true);
                        }
                        Files.createDirectories(this.$runtimeDir, new FileAttribute[0]);
                        archivePath = this.$runtimeDir.resolve(this.$fileName);
                        HttpRequests.request((String)this.$url).userAgent("JetBrains-ACP-Agent-Manager/1.0").saveToFile(archivePath, this.$indicator);
                        this.L$0 = archivePath;
                        this.label = 1;
                        v2 = CoroutinesKt.checkCanceled((Continuation)((Continuation)this));
                        ** if (v2 != var9_2) goto lbl23
lbl22:
                        // 1 sources

                        return var9_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 1: {
                        archivePath = (Path)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl30:
                            // 2 sources

                            v3 = this.$indicator;
                            if (v3 != null) {
                                v3.setText(AcpBundle.INSTANCE.message("progress.text.extracting.node", new Object[0]));
                            }
                            if (Intrinsics.areEqual((Object)this.$extension, (Object)"zip")) {
                                new Decompressor.Zip(archivePath).extract(this.$runtimeDir);
                            } else {
                                new Decompressor.Tar(archivePath).extract(this.$runtimeDir);
                            }
                            Files.deleteIfExists(archivePath);
                            isWindowsTarget = StringsKt.startsWith$default((String)this.$targetPlatform, (String)"windows", (boolean)false, (int)2, null);
                            AcpRuntimeManager.access$reorganizeNodeDirectory(this.this$0, this.$runtimeDir, isWindowsTarget != false);
                            Files.createDirectories(this.$runtimeDir.resolve("npm-cache"), new FileAttribute[0]);
                            nodeBin = AcpRuntimeManager.access$findExecutableInBinDir(this.this$0, this.$runtimeDir, "node");
                            if (nodeBin != null) {
                                AcpRuntimeManager.access$makeExecutable(this.this$0, nodeBin);
                                v4 = AcpRuntimeManager.access$findExecutableInBinDir(this.this$0, this.$runtimeDir, "npm");
                                if (v4 != null) {
                                    var5_9 = v4;
                                    var6_10 = this.this$0;
                                    it = var5_9;
                                    $i$a$-let-AcpRuntimeManager$downloadNode$3$1 = false;
                                    AcpRuntimeManager.access$makeExecutable(var6_10, it);
                                }
                                v5 = AcpRuntimeManager.access$findExecutableInBinDir(this.this$0, this.$runtimeDir, "npx");
                                if (v5 != null) {
                                    var5_9 = v5;
                                    var6_10 = this.this$0;
                                    it = var5_9;
                                    $i$a$-let-AcpRuntimeManager$downloadNode$3$2 = false;
                                    AcpRuntimeManager.access$makeExecutable(var6_10, it);
                                }
                                AcpRuntimeManagerKt.access$getLogger$p().info("Installed Node.js v" + this.$version + " to " + this.$runtimeDir);
                                v6 = nodeBin;
                            } else {
                                AcpRuntimeManagerKt.access$getLogger$p().warn("Node executable not found after extraction");
                                v6 = null;
                            }
                            var2_7 = v6;
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            AcpRuntimeManagerKt.access$getLogger$p().warn("Failed to download Node.js v" + this.$version, (Throwable)e);
                            var2_7 = null;
                        }
                        return var2_7;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object downloadNode$default(AcpRuntimeManager acpRuntimeManager, String string, String string2, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return acpRuntimeManager.downloadNode(string, string2, progressIndicator, (Continuation<? super Path>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reorganizeNodeDirectory(Path runtimeDir, boolean isWindows) {
        Iterator iterator;
        try {
            Object stream;
            iterator = Files.list(runtimeDir);
            Throwable throwable = null;
            try {
                stream = (Stream)((Object)iterator);
                boolean bl = false;
                stream = stream.filter(arg_0 -> AcpRuntimeManager.reorganizeNodeDirectory$lambda$0$1(AcpRuntimeManager::reorganizeNodeDirectory$lambda$0$0, arg_0)).filter(arg_0 -> AcpRuntimeManager.reorganizeNodeDirectory$lambda$0$3(AcpRuntimeManager::reorganizeNodeDirectory$lambda$0$2, arg_0)).findFirst().orElse(null);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)((Object)iterator), (Throwable)throwable);
            }
            iterator = stream;
        }
        catch (Exception e) {
            AcpRuntimeManagerKt.access$getLogger$p().debug("Failed to find extracted Node.js directory", (Throwable)e);
            iterator = null;
        }
        AutoCloseable autoCloseable = iterator;
        if (autoCloseable == null) {
            return;
        }
        AutoCloseable extractedDir = autoCloseable;
        try {
            Path binDir = runtimeDir.resolve("bin");
            Files.createDirectories(binDir, new FileAttribute[0]);
            if (isWindows) {
                Object[] e = new String[]{"node.exe", "npm.cmd", "npx.cmd", "npm", "npx"};
                for (Object execName : CollectionsKt.listOf((Object[])e)) {
                    srcExec = extractedDir.resolve((String)execName);
                    Intrinsics.checkNotNull((Object)srcExec);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists((Path)srcExec, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    Files.move((Path)srcExec, binDir.resolve((String)execName), new CopyOption[0]);
                }
                Path nodeModules = extractedDir.resolve("node_modules");
                Intrinsics.checkNotNull((Object)nodeModules);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(nodeModules, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    Files.move(nodeModules, runtimeDir.resolve("node_modules"), new CopyOption[0]);
                }
            } else {
                Path extractedBin = extractedDir.resolve("bin");
                Intrinsics.checkNotNull((Object)extractedBin);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(extractedBin, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    Object execName;
                    execName = Files.list(extractedBin);
                    srcExec = null;
                    try {
                        Stream stream = (Stream)execName;
                        boolean bl = false;
                        stream.forEach(arg_0 -> AcpRuntimeManager.reorganizeNodeDirectory$lambda$1$1(arg_0 -> AcpRuntimeManager.reorganizeNodeDirectory$lambda$1$0(binDir, arg_0), arg_0));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        srcExec = throwable;
                        throw throwable;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)execName, (Throwable)srcExec);
                    }
                }
                Path extractedLib = extractedDir.resolve("lib");
                Intrinsics.checkNotNull((Object)extractedLib);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(extractedLib, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Files.move(extractedLib, runtimeDir.resolve("lib"), new CopyOption[0]);
                }
                Path extractedInclude = extractedDir.resolve("include");
                Intrinsics.checkNotNull((Object)extractedInclude);
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (Files.exists(extractedInclude, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                    Files.move(extractedInclude, runtimeDir.resolve("include"), new CopyOption[0]);
                }
            }
            File file2 = extractedDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file2);
            AcpRuntimeManagerKt.access$getLogger$p().debug("Reorganized Node.js directory structure in " + runtimeDir);
        }
        catch (Exception e) {
            AcpRuntimeManagerKt.access$getLogger$p().warn("Failed to reorganize Node.js directory structure", (Throwable)e);
        }
    }

    @Nullable
    public final Object downloadUv(@NotNull String version, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super Path> $completion) {
        return this.downloadUv(version, Platform.INSTANCE.current(), indicator, $completion);
    }

    public static /* synthetic */ Object downloadUv$default(AcpRuntimeManager acpRuntimeManager, String string, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return acpRuntimeManager.downloadUv(string, progressIndicator, (Continuation<? super Path>)continuation);
    }

    @Nullable
    public final Object downloadUv(@NotNull String version, @NotNull String targetPlatform, @Nullable ProgressIndicator indicator, @NotNull Continuation<? super Path> $completion) {
        String string;
        switch (targetPlatform) {
            case "darwin-aarch64": {
                string = "aarch64-apple-darwin";
                break;
            }
            case "darwin-x86_64": {
                string = "x86_64-apple-darwin";
                break;
            }
            case "linux-aarch64": {
                string = "aarch64-unknown-linux-gnu";
                break;
            }
            case "linux-x86_64": {
                string = "x86_64-unknown-linux-gnu";
                break;
            }
            case "windows-x86_64": {
                string = "x86_64-pc-windows-msvc";
                break;
            }
            case "windows-aarch64": {
                string = "aarch64-pc-windows-msvc";
                break;
            }
            default: {
                AcpRuntimeManagerKt.access$getLogger$p().warn("Unsupported platform for uv download: " + targetPlatform);
                return null;
            }
        }
        String target = string;
        String extension = StringsKt.startsWith$default((String)targetPlatform, (String)"windows", (boolean)false, (int)2, null) ? "zip" : "tar.gz";
        String fileName = "uv-" + target + "." + extension;
        String url = "https://github.com/astral-sh/uv/releases/download/" + version + "/" + fileName;
        boolean $i$f$service = false;
        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path runtimeDir = ((AcpPaths)object).getRuntimeDir("uv", version);
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(indicator, version, runtimeDir, fileName, url, extension, targetPlatform, this, null){
            Object L$0;
            int label;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ String $version;
            final /* synthetic */ Path $runtimeDir;
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $url;
            final /* synthetic */ String $extension;
            final /* synthetic */ String $targetPlatform;
            final /* synthetic */ AcpRuntimeManager this$0;
            {
                this.$indicator = $indicator;
                this.$version = $version;
                this.$runtimeDir = $runtimeDir;
                this.$fileName = $fileName;
                this.$url = $url;
                this.$extension = $extension;
                this.$targetPlatform = $targetPlatform;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.$indicator;
                        if (v0 != null) {
                            var3_3 = new Object[]{this.$version};
                            v0.setText(AcpBundle.INSTANCE.message("progress.text.downloading.uv", var3_3));
                        }
                        v1 = this.$indicator;
                        if (v1 != null) {
                            v1.setIndeterminate(true);
                        }
                        Files.createDirectories(this.$runtimeDir, new FileAttribute[0]);
                        archivePath = this.$runtimeDir.resolve(this.$fileName);
                        HttpRequests.request((String)this.$url).userAgent("JetBrains-ACP-Agent-Manager/1.0").saveToFile(archivePath, this.$indicator);
                        this.L$0 = archivePath;
                        this.label = 1;
                        v2 = CoroutinesKt.checkCanceled((Continuation)((Continuation)this));
                        ** if (v2 != var9_2) goto lbl23
lbl22:
                        // 1 sources

                        return var9_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 1: {
                        archivePath = (Path)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl30:
                            // 2 sources

                            v3 = this.$indicator;
                            if (v3 != null) {
                                v3.setText(AcpBundle.INSTANCE.message("progress.text.extracting.uv", new Object[0]));
                            }
                            if (Intrinsics.areEqual((Object)this.$extension, (Object)"zip")) {
                                new Decompressor.Zip(archivePath).extract(this.$runtimeDir);
                            } else {
                                new Decompressor.Tar(archivePath).extract(this.$runtimeDir);
                            }
                            Files.deleteIfExists(archivePath);
                            isWindowsTarget = StringsKt.startsWith$default((String)this.$targetPlatform, (String)"windows", (boolean)false, (int)2, null);
                            AcpRuntimeManager.access$reorganizeUvDirectory(this.this$0, this.$runtimeDir, isWindowsTarget != false);
                            Files.createDirectories(this.$runtimeDir.resolve("uv-cache"), new FileAttribute[0]);
                            Files.createDirectories(this.$runtimeDir.resolve("uv-tools"), new FileAttribute[0]);
                            uvBin = AcpRuntimeManager.access$findExecutableInBinDir(this.this$0, this.$runtimeDir, "uv");
                            if (uvBin != null) {
                                AcpRuntimeManager.access$makeExecutable(this.this$0, uvBin);
                                v4 = AcpRuntimeManager.access$findExecutableInBinDir(this.this$0, this.$runtimeDir, "uvx");
                                if (v4 != null) {
                                    var5_9 = v4;
                                    var6_10 = this.this$0;
                                    it = var5_9;
                                    $i$a$-let-AcpRuntimeManager$downloadUv$3$1 = false;
                                    AcpRuntimeManager.access$makeExecutable(var6_10, it);
                                }
                                AcpRuntimeManagerKt.access$getLogger$p().info("Installed uv v" + this.$version + " to " + this.$runtimeDir);
                                v5 = uvBin;
                            } else {
                                AcpRuntimeManagerKt.access$getLogger$p().warn("uv executable not found after extraction");
                                v5 = null;
                            }
                            var2_7 = v5;
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            AcpRuntimeManagerKt.access$getLogger$p().warn("Failed to download uv v" + this.$version, (Throwable)e);
                            var2_7 = null;
                        }
                        return var2_7;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object downloadUv$default(AcpRuntimeManager acpRuntimeManager, String string, String string2, ProgressIndicator progressIndicator, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return acpRuntimeManager.downloadUv(string, string2, progressIndicator, (Continuation<? super Path>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reorganizeUvDirectory(Path runtimeDir, boolean isWindows) {
        Object[] stream;
        Object object;
        try {
            object = Files.list(runtimeDir);
            Object object2 = null;
            try {
                stream = (Stream)object;
                boolean bl = false;
                stream = stream.filter(arg_0 -> AcpRuntimeManager.reorganizeUvDirectory$lambda$0$1(AcpRuntimeManager::reorganizeUvDirectory$lambda$0$0, arg_0)).filter(arg_0 -> AcpRuntimeManager.reorganizeUvDirectory$lambda$0$3(AcpRuntimeManager::reorganizeUvDirectory$lambda$0$2, arg_0)).findFirst().orElse(null);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
            }
            object = stream;
        }
        catch (Exception e) {
            AcpRuntimeManagerKt.access$getLogger$p().debug("Failed to find extracted uv directory", (Throwable)e);
            object = null;
        }
        AutoCloseable autoCloseable = object;
        if (autoCloseable == null) {
            return;
        }
        AutoCloseable extractedDir = autoCloseable;
        try {
            Path binDir = runtimeDir.resolve("bin");
            Files.createDirectories(binDir, new FileAttribute[0]);
            List extensions = isWindows ? CollectionsKt.listOf((Object)".exe") : CollectionsKt.listOf((Object)"");
            stream = new String[]{"uv", "uvx"};
            for (String execName : CollectionsKt.listOf((Object[])stream)) {
                for (String ext : extensions) {
                    Path srcExec = extractedDir.resolve(execName + ext);
                    Intrinsics.checkNotNull((Object)srcExec);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(srcExec, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    Files.move(srcExec, binDir.resolve(execName + ext), new CopyOption[0]);
                }
            }
            File file2 = extractedDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file2);
            AcpRuntimeManagerKt.access$getLogger$p().debug("Reorganized uv directory structure in " + runtimeDir);
        }
        catch (Exception e) {
            AcpRuntimeManagerKt.access$getLogger$p().warn("Failed to reorganize uv directory structure", (Throwable)e);
        }
    }

    private final String getVersion(RuntimeType type2, Path path) {
        String string;
        try {
            String string2;
            String[] stringArray = new String[]{((Object)path).toString(), "--version"};
            GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)5000);
            if (output.getExitCode() == 0) {
                String string3 = output.getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStdout(...)");
                string2 = StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (CharSequence)"v");
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    private final void makeExecutable(Path path) {
        if (OS.CURRENT == OS.Windows) {
            return;
        }
        try {
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
            Set permissions = CollectionsKt.toMutableSet((Iterable)set);
            PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};
            permissions.addAll(SetsKt.setOf((Object[])posixFilePermissionArray));
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (Exception e) {
            AcpRuntimeManagerKt.access$getLogger$p().warn("Failed to set executable permissions on " + path, (Throwable)e);
        }
    }

    public final void downloadRuntimeForAgentInBackground(@NotNull AcpAgentId agentId) {
        RuntimeType runtimeType;
        String string;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        boolean $i$f$service = false;
        Class<AcpAgentInstallationState> serviceClass$iv = AcpAgentInstallationState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ExternalAgent installedAgent = ((AcpAgentInstallationState)object).getInstalledAgent(agentId);
        if (installedAgent == null) {
            AcpRuntimeManagerKt.access$getLogger$p().debug("Agent not installed: " + agentId);
            return;
        }
        AcpDistributionResolver.ResolvedDistribution resolved = AcpDistributionResolver.INSTANCE.resolve(installedAgent);
        RuntimeType runtimeType2 = resolved instanceof AcpDistributionResolver.ResolvedDistribution.Package ? (Intrinsics.areEqual((Object)(string = ((AcpDistributionResolver.ResolvedDistribution.Package)resolved).getRunner()), (Object)"npx") ? RuntimeType.NPX : (Intrinsics.areEqual((Object)string, (Object)"uvx") ? RuntimeType.UVX : null)) : (runtimeType = null);
        if (runtimeType == null) {
            AcpRuntimeManagerKt.access$getLogger$p().debug("No runtime needed for agent: " + agentId + " (uses binary distribution)");
            return;
        }
        if (!this.downloadingRuntimes.add(runtimeType)) {
            AcpRuntimeManagerKt.access$getLogger$p().debug("Runtime " + runtimeType.getCommandName() + " download already in progress");
            return;
        }
        String runtimeName = runtimeType == RuntimeType.NPX ? "Node.js" : "uv";
        AcpRuntimeManagerKt.access$getLogger$p().info("Starting background runtime check for " + runtimeName + " (agent: " + agentId + ")");
        Object[] objectArray = new Object[]{runtimeName};
        string = AcpBundle.INSTANCE.message("progress.title.downloading.runtime", objectArray);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, runtimeType, agentId, string){
            final /* synthetic */ AcpRuntimeManager this$0;
            final /* synthetic */ RuntimeType $runtimeType;
            final /* synthetic */ AcpAgentId $agentId;
            {
                this.this$0 = $receiver;
                this.$runtimeType = $runtimeType;
                this.$agentId = $agentId;
                super(null, $super_call_param$1, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    if (this.this$0.getRuntimePath(this.$runtimeType) != null) {
                        AcpRuntimeManagerKt.access$getLogger$p().debug("Runtime " + this.$runtimeType.getCommandName() + " already available for " + this.$agentId);
                        return;
                    }
                    MutableStateFlow mutableStateFlow = AcpRuntimeManager.access$get_downloadingRuntimesFlow$p(this.this$0);
                    ConcurrentHashMap.KeySetView keySetView = AcpRuntimeManager.access$getDownloadingRuntimes$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)keySetView, (String)"access$getDownloadingRuntimes$p(...)");
                    mutableStateFlow.setValue((Object)CollectionsKt.toSet((Iterable)keySetView));
                    RuntimeInfo cfr_ignored_0 = (RuntimeInfo)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RuntimeInfo>, Object>(this.this$0, this.$runtimeType, indicator, null){
                        int label;
                        final /* synthetic */ AcpRuntimeManager this$0;
                        final /* synthetic */ RuntimeType $runtimeType;
                        final /* synthetic */ ProgressIndicator $indicator;
                        {
                            this.this$0 = $receiver;
                            this.$runtimeType = $runtimeType;
                            this.$indicator = $indicator;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.this$0.ensureRuntime(this.$runtimeType, this.$indicator, (Continuation<? super RuntimeInfo>)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super RuntimeInfo> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
                finally {
                    AcpRuntimeManager.access$getDownloadingRuntimes$p(this.this$0).remove((Object)((Object)this.$runtimeType));
                    MutableStateFlow mutableStateFlow = AcpRuntimeManager.access$get_downloadingRuntimesFlow$p(this.this$0);
                    ConcurrentHashMap.KeySetView keySetView = AcpRuntimeManager.access$getDownloadingRuntimes$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)keySetView, (String)"access$getDownloadingRuntimes$p(...)");
                    mutableStateFlow.setValue((Object)CollectionsKt.toSet((Iterable)keySetView));
                }
            }
        });
    }

    @NotNull
    public final List<RuntimeInfo> getAllManagedRuntimes() {
        List result2 = new ArrayList();
        RuntimeType[] runtimeTypeArray = new RuntimeType[]{RuntimeType.NODE, RuntimeType.UV};
        for (RuntimeType type2 : CollectionsKt.listOf((Object[])runtimeTypeArray)) {
            RuntimeInfo it;
            if (this.getManagedRuntime(type2) == null) continue;
            boolean bl = false;
            result2.add(it);
        }
        return result2;
    }

    private static final Mutex ensureRuntime$lambda$1(RuntimeType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    private static final Mutex ensureRuntime$lambda$2(Function1 $tmp0, Object p0) {
        return (Mutex)$tmp0.invoke(p0);
    }

    private static final boolean reorganizeNodeDirectory$lambda$0$0(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean reorganizeNodeDirectory$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reorganizeNodeDirectory$lambda$0$2(Path it) {
        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"node-v", (boolean)false, (int)2, null);
    }

    private static final boolean reorganizeNodeDirectory$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit reorganizeNodeDirectory$lambda$1$0(Path $binDir, Path file2) {
        Files.move(file2, $binDir.resolve(file2.getFileName()), new CopyOption[0]);
        return Unit.INSTANCE;
    }

    private static final void reorganizeNodeDirectory$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean reorganizeUvDirectory$lambda$0$0(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean reorganizeUvDirectory$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reorganizeUvDirectory$lambda$0$2(Path it) {
        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"uv-", (boolean)false, (int)2, null);
    }

    private static final boolean reorganizeUvDirectory$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$reorganizeNodeDirectory(AcpRuntimeManager $this, Path runtimeDir, boolean isWindows) {
        $this.reorganizeNodeDirectory(runtimeDir, isWindows);
    }

    public static final /* synthetic */ Path access$findExecutableInBinDir(AcpRuntimeManager $this, Path dir, String name) {
        return $this.findExecutableInBinDir(dir, name);
    }

    public static final /* synthetic */ void access$makeExecutable(AcpRuntimeManager $this, Path path) {
        $this.makeExecutable(path);
    }

    public static final /* synthetic */ void access$reorganizeUvDirectory(AcpRuntimeManager $this, Path runtimeDir, boolean isWindows) {
        $this.reorganizeUvDirectory(runtimeDir, isWindows);
    }

    public static final /* synthetic */ MutableStateFlow access$get_downloadingRuntimesFlow$p(AcpRuntimeManager $this) {
        return $this._downloadingRuntimesFlow;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getDownloadingRuntimes$p(AcpRuntimeManager $this) {
        return $this.downloadingRuntimes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$Companion;", "", "<init>", "()V", "DEFAULT_NODE_VERSION", "", "DEFAULT_UV_VERSION", "NODE_DOWNLOAD_BASE", "UV_DOWNLOAD_BASE", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$ManagedRuntimeInfo;", "", "runtimeInfo", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeInfo;", "runtimeDir", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeInfo;Ljava/nio/file/Path;)V", "getRuntimeInfo", "()Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeInfo;", "getRuntimeDir", "()Ljava/nio/file/Path;", "getEnvironmentVariables", "", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
    public static final class ManagedRuntimeInfo {
        @NotNull
        private final RuntimeInfo runtimeInfo;
        @NotNull
        private final Path runtimeDir;

        public ManagedRuntimeInfo(@NotNull RuntimeInfo runtimeInfo2, @NotNull Path runtimeDir) {
            Intrinsics.checkNotNullParameter((Object)runtimeInfo2, (String)"runtimeInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeDir, (String)"runtimeDir");
            this.runtimeInfo = runtimeInfo2;
            this.runtimeDir = runtimeDir;
        }

        @NotNull
        public final RuntimeInfo getRuntimeInfo() {
            return this.runtimeInfo;
        }

        @NotNull
        public final Path getRuntimeDir() {
            return this.runtimeDir;
        }

        @NotNull
        public final Map<String, String> getEnvironmentVariables() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.runtimeInfo.getType().ordinal()]) {
                case 1, 2 -> {
                    Pair[] var1_1 = new Pair[]{TuplesKt.to((Object)"NPM_CONFIG_CACHE", (Object)((Object)this.runtimeDir.resolve("npm-cache")).toString()), TuplesKt.to((Object)"NPM_CONFIG_USERCONFIG", (Object)((Object)this.runtimeDir.resolve("npmrc")).toString())};
                    yield MapsKt.mapOf((Pair[])var1_1);
                }
                case 3, 4 -> {
                    Pair[] var1_2 = new Pair[]{TuplesKt.to((Object)"UV_CACHE_DIR", (Object)((Object)this.runtimeDir.resolve("uv-cache")).toString()), TuplesKt.to((Object)"UV_TOOL_DIR", (Object)((Object)this.runtimeDir.resolve("uv-tools")).toString())};
                    yield MapsKt.mapOf((Pair[])var1_2);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final RuntimeInfo component1() {
            return this.runtimeInfo;
        }

        @NotNull
        public final Path component2() {
            return this.runtimeDir;
        }

        @NotNull
        public final ManagedRuntimeInfo copy(@NotNull RuntimeInfo runtimeInfo2, @NotNull Path runtimeDir) {
            Intrinsics.checkNotNullParameter((Object)runtimeInfo2, (String)"runtimeInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeDir, (String)"runtimeDir");
            return new ManagedRuntimeInfo(runtimeInfo2, runtimeDir);
        }

        public static /* synthetic */ ManagedRuntimeInfo copy$default(ManagedRuntimeInfo managedRuntimeInfo, RuntimeInfo runtimeInfo2, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                runtimeInfo2 = managedRuntimeInfo.runtimeInfo;
            }
            if ((n & 2) != 0) {
                path = managedRuntimeInfo.runtimeDir;
            }
            return managedRuntimeInfo.copy(runtimeInfo2, path);
        }

        @NotNull
        public String toString() {
            return "ManagedRuntimeInfo(runtimeInfo=" + this.runtimeInfo + ", runtimeDir=" + this.runtimeDir + ")";
        }

        public int hashCode() {
            int result2 = this.runtimeInfo.hashCode();
            result2 = result2 * 31 + ((Object)this.runtimeDir).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManagedRuntimeInfo)) {
                return false;
            }
            ManagedRuntimeInfo managedRuntimeInfo = (ManagedRuntimeInfo)other;
            if (!Intrinsics.areEqual((Object)this.runtimeInfo, (Object)managedRuntimeInfo.runtimeInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.runtimeDir, (Object)managedRuntimeInfo.runtimeDir);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RuntimeType.values().length];
                try {
                    nArray[RuntimeType.NPX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RuntimeType.NODE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RuntimeType.UV.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RuntimeType.UVX.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeInfo;", "", "type", "Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeType;", "version", "", "path", "Ljava/nio/file/Path;", "isManaged", "", "<init>", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeType;Ljava/lang/String;Ljava/nio/file/Path;Z)V", "getType", "()Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeType;", "getVersion", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
    public static final class RuntimeInfo {
        @NotNull
        private final RuntimeType type;
        @Nullable
        private final String version;
        @NotNull
        private final Path path;
        private final boolean isManaged;

        public RuntimeInfo(@NotNull RuntimeType type2, @Nullable String version, @NotNull Path path, boolean isManaged) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.type = type2;
            this.version = version;
            this.path = path;
            this.isManaged = isManaged;
        }

        @NotNull
        public final RuntimeType getType() {
            return this.type;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean isManaged() {
            return this.isManaged;
        }

        @NotNull
        public final RuntimeType component1() {
            return this.type;
        }

        @Nullable
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final Path component3() {
            return this.path;
        }

        public final boolean component4() {
            return this.isManaged;
        }

        @NotNull
        public final RuntimeInfo copy(@NotNull RuntimeType type2, @Nullable String version, @NotNull Path path, boolean isManaged) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new RuntimeInfo(type2, version, path, isManaged);
        }

        public static /* synthetic */ RuntimeInfo copy$default(RuntimeInfo runtimeInfo2, RuntimeType runtimeType, String string, Path path, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                runtimeType = runtimeInfo2.type;
            }
            if ((n & 2) != 0) {
                string = runtimeInfo2.version;
            }
            if ((n & 4) != 0) {
                path = runtimeInfo2.path;
            }
            if ((n & 8) != 0) {
                bl = runtimeInfo2.isManaged;
            }
            return runtimeInfo2.copy(runtimeType, string, path, bl);
        }

        @NotNull
        public String toString() {
            return "RuntimeInfo(type=" + this.type + ", version=" + this.version + ", path=" + this.path + ", isManaged=" + this.isManaged + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isManaged);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RuntimeInfo)) {
                return false;
            }
            RuntimeInfo runtimeInfo2 = (RuntimeInfo)other;
            if (this.type != runtimeInfo2.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)runtimeInfo2.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)runtimeInfo2.path)) {
                return false;
            }
            return this.isManaged == runtimeInfo2.isManaged;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpRuntimeManager$RuntimeType;", "", "commandName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getCommandName", "()Ljava/lang/String;", "NODE", "NPX", "UV", "UVX", "intellij.ml.llm.agents.acp"})
    public static final class RuntimeType
    extends Enum<RuntimeType> {
        @NotNull
        private final String commandName;
        public static final /* enum */ RuntimeType NODE = new RuntimeType("node");
        public static final /* enum */ RuntimeType NPX = new RuntimeType("npx");
        public static final /* enum */ RuntimeType UV = new RuntimeType("uv");
        public static final /* enum */ RuntimeType UVX = new RuntimeType("uvx");
        private static final /* synthetic */ RuntimeType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RuntimeType(String commandName) {
            this.commandName = commandName;
        }

        @NotNull
        public final String getCommandName() {
            return this.commandName;
        }

        public static RuntimeType[] values() {
            return (RuntimeType[])$VALUES.clone();
        }

        public static RuntimeType valueOf(String value) {
            return Enum.valueOf(RuntimeType.class, value);
        }

        @NotNull
        public static EnumEntries<RuntimeType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = runtimeTypeArray = new RuntimeType[]{RuntimeType.NODE, RuntimeType.NPX, RuntimeType.UV, RuntimeType.UVX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RuntimeType.values().length];
            try {
                nArray[RuntimeType.NPX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeType.UVX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeType.NODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeType.UV.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

