/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.ml.llm.chatInputLanguage.ChatInputLexerAdapter;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTokenType;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.ml.llm.core.chat.ui.AvailableCommandsProvider;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatModeUtil;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputSyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "AgentAwareChatInputLexer", "intellij.ml.llm.chatInputLanguage"})
public final class ChatInputSyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap();
    @NotNull
    private static final ChatInputTokenType KNOWN_COMMAND_TOKEN = new ChatInputTokenType("KNOWN_COMMAND");
    @NotNull
    private static final ChatInputTokenType KNOWN_SKILL_TOKEN = new ChatInputTokenType("KNOWN_SKILL");

    public ChatInputSyntaxHighlighter(@Nullable Project project2) {
        this.project = project2;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return (Lexer)new AgentAwareChatInputLexer(this.project);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        if (tokenType == ChatInputTypes.CODE_LINE || tokenType == ChatInputTypes.PLAINTEXT_WORD) {
            Intrinsics.checkNotNullExpressionValue((Object)TextAttributesKey.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return TextAttributesKey.EMPTY_ARRAY;
        }
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"pack(...)");
        return textAttributesKeyArray;
    }

    static {
        ATTRIBUTES.put(ChatInputTypes.CODE_FENCE_LANGUAGE_ID, DefaultLanguageHighlighterColors.CONSTANT);
        ATTRIBUTES.put(ChatInputTypes.CODE_FENCE_START, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.CODE_FENCE_END, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.REFERENCE_START, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.REFERENCE_TYPE, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.REFERENCE_SEPARATOR, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.REFERENCE_VALUE_DELIMITER, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.REFERENCE_VALUE, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.CODE_SPAN, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(ChatInputTypes.COMMAND, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(KNOWN_COMMAND_TOKEN, DefaultLanguageHighlighterColors.NUMBER);
        ATTRIBUTES.put(KNOWN_SKILL_TOKEN, DefaultLanguageHighlighterColors.NUMBER);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0002J\b\u0010'\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputSyntaxHighlighter$AgentAwareChatInputLexer;", "Lcom/intellij/lexer/LexerBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "delegate", "Lcom/intellij/lexer/Lexer;", "buffer", "", "bufferEnd", "", "previousTokenType", "Lcom/intellij/psi/tree/IElementType;", "cachedTokenType", "commandTokenType", "skillTokenType", "agentCommandNames", "", "", "agentSkillNames", "start", "", "startOffset", "endOffset", "initialState", "getState", "getTokenType", "getTokenStart", "getTokenEnd", "getBufferSequence", "getBufferEnd", "advance", "updateCachedToken", "isAtTextStart", "", "tokenStart", "extractIdentifier", "tokenEnd", "isKnownCommand", "isKnownSkill", "intellij.ml.llm.chatInputLanguage"})
    @SourceDebugExtension(value={"SMAP\nChatInputSyntaxHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputSyntaxHighlighter.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputSyntaxHighlighter$AgentAwareChatInputLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1#2:174\n1563#3:175\n1634#3,3:176\n1563#3:179\n1634#3,3:180\n*S KotlinDebug\n*F\n+ 1 ChatInputSyntaxHighlighter.kt\ncom/intellij/ml/llm/chatInputLanguage/ChatInputSyntaxHighlighter$AgentAwareChatInputLexer\n*L\n72#1:175\n72#1:176,3\n73#1:179\n73#1:180,3\n*E\n"})
    private static final class AgentAwareChatInputLexer
    extends LexerBase {
        @Nullable
        private final Project project;
        @NotNull
        private final Lexer delegate;
        @NotNull
        private CharSequence buffer;
        private int bufferEnd;
        @Nullable
        private IElementType previousTokenType;
        @Nullable
        private IElementType cachedTokenType;
        @Nullable
        private IElementType commandTokenType;
        @Nullable
        private IElementType skillTokenType;
        @NotNull
        private Set<String> agentCommandNames;
        @NotNull
        private Set<String> agentSkillNames;

        public AgentAwareChatInputLexer(@Nullable Project project2) {
            this.project = project2;
            this.delegate = (Lexer)new ChatInputLexerAdapter();
            this.buffer = "";
            this.agentCommandNames = SetsKt.emptySet();
            this.agentSkillNames = SetsKt.emptySet();
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            NewChatMode mode;
            Project it;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
            this.bufferEnd = endOffset;
            this.previousTokenType = null;
            this.commandTokenType = null;
            this.skillTokenType = null;
            Project project2 = this.project;
            if (project2 != null) {
                it = project2;
                boolean bl = false;
                v1 = AIChatModeUtil.INSTANCE.getCurrentChatMode(it);
            } else {
                v1 = mode = null;
            }
            if (mode instanceof NewChatMode.Agent) {
                AvailableCommandsProvider.Skill it2;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = ((NewChatMode.Agent)mode).getAvailableCommandProvider().getAvailableCommands();
                AgentAwareChatInputLexer agentAwareChatInputLexer = this;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    AvailableCommandsProvider.Command command = (AvailableCommandsProvider.Command)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it2.getName().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    collection.add(string);
                }
                agentAwareChatInputLexer.agentCommandNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $this$map$iv = ((NewChatMode.Agent)mode).getAvailableCommandProvider().getAvailableSkills();
                agentAwareChatInputLexer = this;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (AvailableCommandsProvider.Skill)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it2.getName().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    collection.add(string);
                }
                agentAwareChatInputLexer.agentSkillNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            } else {
                this.agentCommandNames = SetsKt.emptySet();
                this.agentSkillNames = SetsKt.emptySet();
            }
            this.delegate.start(buffer, startOffset, endOffset, initialState);
            this.updateCachedToken();
        }

        public int getState() {
            return this.delegate.getState();
        }

        @Nullable
        public IElementType getTokenType() {
            IElementType iElementType = this.cachedTokenType;
            if (iElementType == null) {
                return null;
            }
            IElementType tokenType = iElementType;
            IElementType iElementType2 = tokenType;
            return Intrinsics.areEqual((Object)iElementType2, (Object)ChatInputTypes.COMMAND) ? this.commandTokenType : (Intrinsics.areEqual((Object)iElementType2, (Object)ChatInputTypes.DOLLAR) ? this.skillTokenType : tokenType);
        }

        public int getTokenStart() {
            return this.delegate.getTokenStart();
        }

        public int getTokenEnd() {
            return this.delegate.getTokenEnd();
        }

        @NotNull
        public CharSequence getBufferSequence() {
            return this.buffer;
        }

        public int getBufferEnd() {
            return this.bufferEnd;
        }

        public void advance() {
            if (this.delegate.getTokenType() == null) {
                return;
            }
            this.previousTokenType = this.delegate.getTokenType();
            this.delegate.advance();
            this.updateCachedToken();
        }

        private final void updateCachedToken() {
            this.cachedTokenType = this.delegate.getTokenType();
            if (Intrinsics.areEqual((Object)this.cachedTokenType, (Object)ChatInputTypes.COMMAND)) {
                if (!Intrinsics.areEqual((Object)this.previousTokenType, (Object)ChatInputTypes.COMMAND)) {
                    this.commandTokenType = CollectionsKt.any((Iterable)this.agentCommandNames) ? (this.isAtTextStart(this.delegate.getTokenStart()) && this.isKnownCommand() ? (IElementType)KNOWN_COMMAND_TOKEN : ChatInputTypes.PLAINTEXT_WORD) : (IElementType)KNOWN_COMMAND_TOKEN;
                }
            } else {
                this.commandTokenType = null;
            }
            if (Intrinsics.areEqual((Object)this.cachedTokenType, (Object)ChatInputTypes.DOLLAR)) {
                if (!Intrinsics.areEqual((Object)this.previousTokenType, (Object)ChatInputTypes.DOLLAR)) {
                    this.skillTokenType = CollectionsKt.any((Iterable)this.agentSkillNames) && this.isKnownSkill() ? (IElementType)KNOWN_SKILL_TOKEN : ChatInputTypes.PLAINTEXT_WORD;
                }
            } else {
                this.skillTokenType = null;
            }
        }

        private final boolean isAtTextStart(int tokenStart) {
            if (tokenStart <= 0) {
                return true;
            }
            int limit = RangesKt.coerceAtMost((int)tokenStart, (int)this.buffer.length());
            for (int index = 0; index < limit; ++index) {
                if (CharsKt.isWhitespace((char)this.buffer.charAt(index))) continue;
                return false;
            }
            return true;
        }

        private final String extractIdentifier(int tokenStart, int tokenEnd) {
            int start2;
            int end = tokenEnd;
            for (start2 = tokenStart; start2 > 0 && !CharsKt.isWhitespace((char)this.buffer.charAt(start2 - 1)); --start2) {
            }
            while (end < this.bufferEnd && !CharsKt.isWhitespace((char)this.buffer.charAt(end))) {
                ++end;
            }
            return ((Object)this.buffer.subSequence(start2, end)).toString();
        }

        private final boolean isKnownCommand() {
            char[] cArray = new char[]{'/'};
            String string = StringsKt.trimStart((String)this.extractIdentifier(this.delegate.getTokenStart(), this.delegate.getTokenEnd()), (char[])cArray).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String commandNameUppercase = string;
            if (StringsKt.isBlank((CharSequence)commandNameUppercase)) {
                return false;
            }
            return this.agentCommandNames.contains(commandNameUppercase);
        }

        private final boolean isKnownSkill() {
            char[] cArray = new char[]{'$'};
            String string = StringsKt.trimStart((String)this.extractIdentifier(this.delegate.getTokenStart(), this.delegate.getTokenEnd()), (char[])cArray).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String skillNameUppercase = string;
            if (StringsKt.isBlank((CharSequence)skillNameUppercase)) {
                return false;
            }
            return this.agentSkillNames.contains(skillNameUppercase);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/ChatInputSyntaxHighlighter$Companion;", "", "<init>", "()V", "ATTRIBUTES", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "KNOWN_COMMAND_TOKEN", "Lcom/intellij/ml/llm/chatInputLanguage/psi/ChatInputTokenType;", "KNOWN_SKILL_TOKEN", "intellij.ml.llm.chatInputLanguage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

