/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage.commands;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ml.llm.chatInputLanguage.commands.ChatInputCommandProvider;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.ml.llm.core.chat.ui.AvailableCommandsProvider;
import com.intellij.ml.llm.core.chat.ui.chat.context.AIChatModeUtil;
import com.intellij.ml.llm.core.chat.ui.chat.input.chatModeSelector.NewChatMode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/commands/ChatInputCommandCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "isAtTextStart", "", "ChatInputCommandInsertHandler", "AgentCommandInsertHandler", "intellij.ml.llm.chatInputLanguage"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChatInputCommandCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputCommandCompletionProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/commands/ChatInputCommandCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,73:1\n774#2:74\n865#2,2:75\n1563#2:77\n1634#2,3:78\n1563#2:81\n1634#2,3:82\n1563#2:85\n1634#2,3:86\n1069#3,2:89\n*S KotlinDebug\n*F\n+ 1 ChatInputCommandCompletionProvider.kt\ncom/intellij/ml/llm/chatInputLanguage/commands/ChatInputCommandCompletionProvider\n*L\n20#1:74\n20#1:75,2\n21#1:77\n21#1:78,3\n29#1:81\n29#1:82,3\n35#1:85\n35#1:86,3\n71#1:89,2\n*E\n"})
public final class ChatInputCommandCompletionProvider
extends CompletionProvider<CompletionParameters> {
    /*
     * WARNING - void declaration
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        Collection collection;
        CompletionResultSet completionResultSet;
        Iterable chatCommands;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Project project2 = parameters.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        NewChatMode mode = AIChatModeUtil.INSTANCE.getCurrentChatMode(project3);
        IElementType iElementType = parameters.getPosition().getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (mode instanceof NewChatMode.Chat) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ChatInputCommandProvider it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ChatInputCommandProvider.Companion.getEP().getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ChatInputCommandProvider)element$iv$iv;
                boolean bl = false;
                if (!it.getEnabled()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = chatCommands = (List)destination$iv$iv;
            completionResultSet = result2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                it = (ChatInputCommandProvider)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it.getName()).withTypeText(it.getDescription()).withPresentableText("/" + it.getName()).withInsertHandler((InsertHandler)ChatInputCommandInsertHandler.INSTANCE));
            }
            completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
        }
        if (mode instanceof NewChatMode.Agent) {
            AvailableCommandsProvider.Skill command;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            if (Intrinsics.areEqual((Object)elementType, (Object)ChatInputTypes.COMMAND) && this.isAtTextStart(parameters)) {
                void $this$mapTo$iv$iv;
                chatCommands = ((NewChatMode.Agent)mode).getAvailableCommandProvider().getAvailableCommands();
                completionResultSet = result2;
                boolean $i$f$map = false;
                Iterable $i$f$map2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object item$iv$iv2;
                    item$iv$iv2 = (AvailableCommandsProvider.Command)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LookupElementBuilder.create((String)command.getName()).withBoldness(true).withTypeText(command.getDescription()).withPresentableText("/" + command.getName()).withInsertHandler((InsertHandler)new AgentCommandInsertHandler(command.getHint())));
                }
                completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
            }
            if (Intrinsics.areEqual((Object)elementType, (Object)ChatInputTypes.DOLLAR)) {
                $this$map$iv = ((NewChatMode.Agent)mode).getAvailableCommandProvider().getAvailableSkills();
                completionResultSet = result2;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void skill;
                    command = (AvailableCommandsProvider.Skill)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String skillText = "$" + skill.getName();
                    collection.add(LookupElementBuilder.create((String)skillText).withBoldness(true).withTypeText(skill.getDescription()).withPresentableText(skillText).withInsertHandler((InsertHandler)new AgentCommandInsertHandler(skill.getHint())));
                }
                completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
            }
        }
    }

    private final boolean isAtTextStart(CompletionParameters parameters) {
        boolean bl;
        block2: {
            CharSequence prefix;
            Document document2 = parameters.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            Document document3 = document2;
            int commandStartOffset = parameters.getPosition().getTextRange().getStartOffset();
            if (commandStartOffset <= 0) {
                return true;
            }
            CharSequence $this$all$iv = prefix = document3.getCharsSequence().subSequence(0, commandStartOffset);
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/commands/ChatInputCommandCompletionProvider$AgentCommandInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "hint", "", "<init>", "(Ljava/lang/String;)V", "handleInsert", "", "ctx", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.ml.llm.chatInputLanguage"})
    private static final class AgentCommandInsertHandler
    implements InsertHandler<LookupElement> {
        @Nullable
        private final String hint;

        public AgentCommandInsertHandler(@Nullable String hint) {
            this.hint = hint;
        }

        public void handleInsert(@NotNull InsertionContext ctx, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            ctx.getDocument().insertString(ctx.getTailOffset(), (CharSequence)" ");
            ctx.getEditor().getCaretModel().moveToOffset(ctx.getTailOffset() + 1);
            CharSequence charSequence = this.hint;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                Editor editor2 = ctx.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                int startOffset = editor3.getCaretModel().getOffset();
                ctx.getDocument().insertString(startOffset, (CharSequence)this.hint);
                editor3.getSelectionModel().setSelection(startOffset, startOffset + this.hint.length());
                editor3.getCaretModel().moveToOffset(startOffset + this.hint.length());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/commands/ChatInputCommandCompletionProvider$ChatInputCommandInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.ml.llm.chatInputLanguage"})
    private static final class ChatInputCommandInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final ChatInputCommandInsertHandler INSTANCE = new ChatInputCommandInsertHandler();

        private ChatInputCommandInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            context2.getDocument().insertString(context2.getTailOffset(), (CharSequence)" ");
            context2.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
        }
    }
}

