/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chatInputLanguage.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.ml.llm.chatInputLanguage.ChatInputCodeFenceUtils;
import com.intellij.ml.llm.chatInputLanguage.ChatInputPsiElementFactory;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u00022\u00020\u0003:\u0003\u0012\u0013\u0014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence;", "Lcom/intellij/extapi/psi/ASTWrapperPsiElement;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "Lcom/intellij/psi/impl/source/tree/injected/InjectionBackgroundSuppressor;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "isValidHost", "", "updateText", "text", "", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "getLanguageIdentifier", "Lcom/intellij/psi/PsiElement;", "getContents", "Manipulator", "Companion", "CodeFenceLiteralTextEscaper", "intellij.ml.llm.chatInputLanguage"})
public final class ChatInputCodeFence
extends ASTWrapperPsiElement
implements PsiLanguageInjectionHost,
InjectionBackgroundSuppressor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ChatInputCodeFence(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public boolean isValidHost() {
        return ChatInputCodeFenceUtils.INSTANCE.isAbleToAcceptInjections(this);
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        PsiElement psiElement = ElementManipulators.handleContentChange((PsiElement)((PsiElement)this), (String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleContentChange(...)");
        return (PsiLanguageInjectionHost)psiElement;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new CodeFenceLiteralTextEscaper(this);
    }

    @Nullable
    public final PsiElement getLanguageIdentifier() {
        return this.findChildByType(ChatInputTypes.CODE_FENCE_LANGUAGE_ID);
    }

    @Nullable
    public final PsiElement getContents() {
        return this.findChildByType(ChatInputTypes.CODE_FENCE_CONTENTS_ELEMENT);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence$CodeFenceLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "host", "Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence;", "<init>", "(Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence;)V", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "intellij.ml.llm.chatInputLanguage"})
    private static final class CodeFenceLiteralTextEscaper
    extends LiteralTextEscaper<PsiLanguageInjectionHost> {
        public CodeFenceLiteralTextEscaper(@NotNull ChatInputCodeFence host) {
            Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
            super((PsiLanguageInjectionHost)host);
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost, (String)"null cannot be cast to non-null type com.intellij.ml.llm.chatInputLanguage.psi.impl.ChatInputCodeFence");
            List<PsiElement> list = Companion.obtainFenceContent((ChatInputCodeFence)psiLanguageInjectionHost);
            if (list == null) {
                return true;
            }
            List<PsiElement> elements = list;
            for (PsiElement element2 : elements) {
                TextRange intersected;
                if (rangeInsideHost.intersection(element2.getTextRangeInParent()) == null) continue;
                outChars.append(intersected.substring(this.myHost.getText()));
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost, (String)"null cannot be cast to non-null type com.intellij.ml.llm.chatInputLanguage.psi.impl.ChatInputCodeFence");
            List<PsiElement> list = Companion.obtainFenceContent((ChatInputCodeFence)psiLanguageInjectionHost);
            if (list == null) {
                return -1;
            }
            List<PsiElement> elements = list;
            int cur = 0;
            for (PsiElement element2 : elements) {
                TextRange intersected = rangeInsideHost.intersection(element2.getTextRangeInParent());
                if (intersected == null || intersected.isEmpty()) continue;
                if (cur + intersected.getLength() == offsetInDecoded) {
                    return intersected.getStartOffset() + intersected.getLength();
                }
                if (cur == offsetInDecoded) {
                    return intersected.getStartOffset();
                }
                if (cur < offsetInDecoded && cur + intersected.getLength() > offsetInDecoded) {
                    return intersected.getStartOffset() + (offsetInDecoded - cur);
                }
                cur += intersected.getLength();
            }
            PsiElement last = elements.get(elements.size() - 1);
            TextRange intersected = rangeInsideHost.intersection(last.getTextRangeInParent());
            if (intersected == null || intersected.isEmpty()) {
                return -1;
            }
            int result2 = intersected.getStartOffset() + (offsetInDecoded - (cur - intersected.getLength()));
            return rangeInsideHost.getStartOffset() <= result2 && result2 <= rangeInsideHost.getEndOffset() ? result2 : -1;
        }

        @NotNull
        public TextRange getRelevantTextRange() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost, (String)"null cannot be cast to non-null type com.intellij.ml.llm.chatInputLanguage.psi.impl.ChatInputCodeFence");
            return Companion.obtainRelevantTextRange((ChatInputCodeFence)psiLanguageInjectionHost);
        }

        public boolean isOneLine() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence$Companion;", "", "<init>", "()V", "obtainRelevantTextRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence;", "obtainFenceContent", "", "Lcom/intellij/psi/PsiElement;", "intellij.ml.llm.chatInputLanguage"})
    public static final class Companion {
        private Companion() {
        }

        private final TextRange obtainRelevantTextRange(ChatInputCodeFence element2) {
            List<PsiElement> list = this.obtainFenceContent(element2);
            if (list == null) {
                return new TextRange(0, 0);
            }
            List<PsiElement> elements = list;
            PsiElement first = (PsiElement)CollectionsKt.first(elements);
            PsiElement last = (PsiElement)CollectionsKt.last(elements);
            TextRange textRange = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return textRange;
        }

        @ApiStatus.Experimental
        @Nullable
        public final List<PsiElement> obtainFenceContent(@NotNull ChatInputCodeFence element2) {
            Intrinsics.checkNotNullParameter((Object)((Object)element2), (String)"element");
            return (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element2), () -> Companion.obtainFenceContent$lambda$0(element2));
        }

        private static final CachedValueProvider.Result obtainFenceContent$lambda$0(ChatInputCodeFence $element) {
            Object[] objectArray = new Object[]{$element};
            return CachedValueProvider.Result.create(ChatInputCodeFenceUtils.INSTANCE.getContent($element), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence$Manipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lcom/intellij/ml/llm/chatInputLanguage/psi/impl/ChatInputCodeFence;", "<init>", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "content", "", "intellij.ml.llm.chatInputLanguage"})
    public static final class Manipulator
    extends AbstractElementManipulator<ChatInputCodeFence> {
        @Nullable
        public ChatInputCodeFence handleContentChange(@NotNull ChatInputCodeFence element2, @NotNull TextRange range, @NotNull String content2) throws IncorrectOperationException {
            ChatInputCodeFence chatInputCodeFence;
            Intrinsics.checkNotNullParameter((Object)((Object)element2), (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Project project2 = element2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            PsiElement textElement = ChatInputPsiElementFactory.INSTANCE.createTextElement(project2, content2);
            if (textElement instanceof ChatInputCodeFence) {
                PsiElement psiElement = element2.replace(textElement);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.ml.llm.chatInputLanguage.psi.impl.ChatInputCodeFence");
                chatInputCodeFence = (ChatInputCodeFence)psiElement;
            } else {
                chatInputCodeFence = null;
            }
            return chatInputCodeFence;
        }
    }
}

