/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.codeGeneration.CodeGenerationInteraction;
import com.intellij.ml.llm.codeGeneration.inplace.AICodeGenerationInteractionFactory;
import com.intellij.ml.llm.codeGeneration.inplace.AICodeGenerationInteractionProvider;
import com.intellij.ml.llm.codeGeneration.inplace.CodeGenerationInlineCompletionManager;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupInvocationUtils;
import com.intellij.ml.llm.core.AIAssistantPlugin;
import com.intellij.ml.llm.core.AIFirstUseKt;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.actions.editor.AiaInEditorInterceptor;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.codeFloatingToolbar.CodeFloatingToolbar;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/codeGeneration/actions/AskAiAssistantInEditorAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "isBlockedByAiIgnoreAndNotifyIfNeeded", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class AskAiAssistantInEditorAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    @NotNull
    public static final String ID = "AIAssistant.Editor.AskAiAssistantInEditor";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = (Editor)e.getDataContext().getData(CommonDataKeys.EDITOR);
        if (!Companion.isActionAvailable(editor2)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
            if (editor2 != null && editor2.getSelectionModel().hasSelection()) {
                e.getPresentation().setText(LLMBundle.message((String)"action.AIAssistant.Editor.ModifyCodeInplace.text", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(LLMBundle.message((String)"action.AIAssistant.Editor.GenerateCodeInplace.text", (Object[])new Object[0]));
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        Project project2 = (Project)dataContext3.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Object object = dataContext3.getData(CommonDataKeys.EDITOR);
        EditorEx editorEx = object instanceof EditorEx ? (EditorEx)object : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editor2 = editorEx;
        PsiFile psiFile = (PsiFile)dataContext3.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile sourceFile = psiFile;
        if (this.isBlockedByAiIgnoreAndNotifyIfNeeded(sourceFile)) {
            return;
        }
        if (!AIAssistantUIUtil.INSTANCE.isAssistantActive(project3)) {
            return;
        }
        if (!AIFirstUseKt.prepareAiForUse((Project)project3)) {
            return;
        }
        CodeFloatingToolbar codeFloatingToolbar = CodeFloatingToolbar.Companion.getToolbar((Editor)editor2);
        if (codeFloatingToolbar != null) {
            codeFloatingToolbar.scheduleHide();
        }
        CodeGenerationInlineCompletionManager.INSTANCE.hideInlineInlays((Editor)editor2);
        BuildersKt.launch$default((CoroutineScope)AIAssistantPlugin.INSTANCE.getScope(project3), (CoroutineContext)ClientId.Companion.coroutineContext(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editor2, project3, sourceFile, null){
            int label;
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $sourceFile;
            {
                this.$editor = $editor;
                this.$project = $project;
                this.$sourceFile = $sourceFile;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$editor, this.$project, this.$sourceFile, null){
                            int label;
                            final /* synthetic */ EditorEx $editor;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ PsiFile $sourceFile;
                            {
                                this.$editor = $editor;
                                this.$project = $project;
                                this.$sourceFile = $sourceFile;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        AiaInEditorInterceptor interceptor = AiaInEditorInterceptor.Companion.findAvailableInterceptor((Editor)this.$editor);
                                        if (interceptor != null) {
                                            interceptor.intercept((Editor)this.$editor, this.$project);
                                        } else {
                                            AICodeGenerationPopupInvocationUtils.INSTANCE.showPrompt(this.$editor, this.$sourceFile);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean isBlockedByAiIgnoreAndNotifyIfNeeded(PsiFile file2) {
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, file2)) {
            ApplicationManager.getApplication().invokeLater(() -> AskAiAssistantInEditorAction.isBlockedByAiIgnoreAndNotifyIfNeeded$lambda$0(file2));
            return true;
        }
        return false;
    }

    private static final void isBlockedByAiIgnoreAndNotifyIfNeeded$lambda$0(PsiFile $file) {
        Project project2 = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PrivacyPathCheckerKt.notifyFileIsIgnored(project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/codeGeneration/actions/AskAiAssistantInEditorAction$Companion;", "", "<init>", "()V", "isActionAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasAvailableLlmProfile", "ID", "", "intellij.ml.llm.codeGeneration"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isActionAvailable(@Nullable Editor editor2) {
            if (editor2 == null) {
                return false;
            }
            Project project2 = editor2.getProject();
            if (project2 == null) {
                return false;
            }
            Project project3 = project2;
            if (!AICodeGenerationInteractionProvider.Companion.isInlayPopupAvailable(editor2)) {
                return false;
            }
            if (AICodeGenerationInteractionFactory.INSTANCE.getInteraction(editor2) == CodeGenerationInteraction.NONE) {
                return false;
            }
            return editor2.getDocument().isWritable() && this.hasAvailableLlmProfile() && AIAssistantUIUtil.INSTANCE.isAuthedAndAllowed(project3);
        }

        private final boolean hasAvailableLlmProfile() {
            ChatSourceAction sourceAction = ChatSourceAction.GENERATE_CODE_INPLACE;
            return AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getChatPromptId((ChatSourceAction)sourceAction));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

