/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context;

import com.intellij.ml.llm.context.TimeValue;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/context/TimeBucket;", "", "from", "Lcom/intellij/ml/llm/context/TimeValue;", "to", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "<init>", "(Lcom/intellij/ml/llm/context/TimeValue;Lcom/intellij/ml/llm/context/TimeValue;Ljava/util/concurrent/atomic/AtomicLong;)V", "getFrom", "()Lcom/intellij/ml/llm/context/TimeValue;", "getTo", "getCounter", "", "tryPut", "", "timePoint", "intellij.ml.llm.context"})
@SourceDebugExtension(value={"SMAP\nContextRetrievalStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextRetrievalStatistics.kt\ncom/intellij/ml/llm/context/TimeBucket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,520:1\n1#2:521\n*E\n"})
final class TimeBucket {
    @NotNull
    private final TimeValue from;
    @NotNull
    private final TimeValue to;
    @NotNull
    private AtomicLong counter;

    public TimeBucket(@NotNull TimeValue from, @NotNull TimeValue to, @NotNull AtomicLong counter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        this.from = from;
        this.to = to;
        this.counter = counter;
        boolean bl2 = bl = this.from.getUnit() == this.to.getUnit();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Please, use the same time units for from and to";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ TimeBucket(TimeValue timeValue, TimeValue timeValue2, AtomicLong atomicLong, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            atomicLong = new AtomicLong(0L);
        }
        this(timeValue, timeValue2, atomicLong);
    }

    @NotNull
    public final TimeValue getFrom() {
        return this.from;
    }

    @NotNull
    public final TimeValue getTo() {
        return this.to;
    }

    public final long getCounter() {
        return this.counter.get();
    }

    public final boolean tryPut(@NotNull TimeValue timePoint) {
        Intrinsics.checkNotNullParameter((Object)timePoint, (String)"timePoint");
        long converted = this.from.getUnit().convert(timePoint.getValue(), timePoint.getUnit());
        long l = this.from.getValue();
        boolean bl = converted < this.to.getValue() ? l <= converted : false;
        if (bl) {
            this.counter.incrementAndGet();
            return true;
        }
        return false;
    }
}

