/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.rag;

import com.intellij.dataspell.llm.DataSpellWorkspaceContextLlmFacade;
import com.intellij.dataspell.llm.TableInfo;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentSource;
import com.intellij.ml.llm.ds.DataSpellLLMBundle;
import com.intellij.ml.llm.ds.rag.TableChatAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001e\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u000f\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0019\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u001c\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0014\u0010%\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0016R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/ds/rag/TableContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "tableInfo", "Lcom/intellij/dataspell/llm/TableInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/dataspell/llm/TableInfo;Lcom/intellij/openapi/project/Project;)V", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "hint", "getHint", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "()Ljava/lang/String;", "popupPresentationText", "getPopupPresentationText", "popupHintText", "getPopupHintText", "icon", "Ljavax/swing/Icon;", "getIcon", "createChatAttachment", "Lcom/intellij/ml/llm/ds/rag/TableChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "id", "getId", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "intellij.ml.llm.ds"})
@SourceDebugExtension(value={"SMAP\nDataContextPopupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataContextPopupContributor.kt\ncom/intellij/ml/llm/ds/rag/TableContextAttachment\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,154:1\n50#2:155\n*S KotlinDebug\n*F\n+ 1 DataContextPopupContributor.kt\ncom/intellij/ml/llm/ds/rag/TableContextAttachment\n*L\n132#1:155\n*E\n"})
public final class TableContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final TableInfo tableInfo;
    @NotNull
    private final Project project;
    @NotNull
    private final ObservableProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final PSString text;
    @Nullable
    private final ObservableProperty<Icon> icon;

    public TableContextAttachment(@NotNull TableInfo tableInfo, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)tableInfo, (String)"tableInfo");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.tableInfo = tableInfo;
        this.project = project2;
        this.name = (ObservableProperty)new AtomicProperty((Object)this.tableInfo.getTableName());
        this.hint = (ObservableProperty)new AtomicProperty((Object)StringUtil.shortenTextWithEllipsis((String)this.tableInfo.getTableSchema(), (int)20, (int)0));
        this.text = ConstantsKt.getEMPTY();
        this.icon = (ObservableProperty)new AtomicProperty((Object)this.tableInfo.getDataSourceIcon());
    }

    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getTooltipText() {
        Object[] objectArray = new Object[]{this.tableInfo.getDataSourceName(), this.tableInfo.getTableQualifiedName()};
        return DataSpellLLMBundle.message("llm.context.attachment.table.full.information", objectArray);
    }

    @NotNull
    public String getPopupPresentationText() {
        return this.tableInfo.getTableName();
    }

    @Nullable
    public String getPopupHintText() {
        return this.tableInfo.getDataSourceName() + " (" + this.tableInfo.getTableSchema() + ")";
    }

    @Nullable
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super TableChatAttachment> $completion) {
        String tableMetadata = StringsKt.trimMargin$default((String)("\n      |Table Information:\n      |  - Table Name: " + this.tableInfo.getTableName() + "\n      |  - Table Qualified Name: " + this.tableInfo.getTableQualifiedName() + "\n      |  - Database Type: " + this.tableInfo.getDatabaseType() + "\n      |  - Data Source Connection Name: " + this.tableInfo.getDataSourceName() + "\n      "), null, (int)1, null);
        return new TableChatAttachment(this.tableInfo, ConstantsKt.getPrivacyConst((String)("Table '" + this.tableInfo.getTableName() + "'")), ConstantsKt.getPrivacyConst((String)tableMetadata), ChatAttachment.Kind.Visible, this.project);
    }

    public void performAction(boolean isInMessage) {
        block0: {
            ComponentManager $this$serviceOrNull$iv = (ComponentManager)this.project;
            boolean $i$f$serviceOrNull = false;
            DataSpellWorkspaceContextLlmFacade dataSpellWorkspaceContextLlmFacade = (DataSpellWorkspaceContextLlmFacade)$this$serviceOrNull$iv.getService(DataSpellWorkspaceContextLlmFacade.class);
            if (dataSpellWorkspaceContextLlmFacade == null) break block0;
            dataSpellWorkspaceContextLlmFacade.navigateTo(this.tableInfo.getDataSourceUniqueId(), this.tableInfo.getTableObjectPath());
        }
    }

    @NotNull
    public String getId() {
        return "DataSpellTableData: " + this.tableInfo.getDataSourceName() + " " + this.tableInfo.getTableQualifiedName();
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return (ContextEntitySource)ContextAttachmentSource.User.INSTANCE;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return ContextEntityPrivacy.Unrelated.INSTANCE;
    }
}

