/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.java.generate.test;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/java/generate/test/JvmTestLibrariesUtils;", "", "<init>", "()V", "findAvailableLibraries", "", "Lcom/intellij/ml/llm/java/generate/test/JvmTestLibrariesUtils$TestLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "dirPath", "Ljava/nio/file/Path;", "getKnownLibraries", "module", "Lcom/intellij/openapi/module/Module;", "getAllModuleLibraries", "", "modules", "", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/module/Module;", "TestLibrary", "intellij.ml.llm.java"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJvmTestLibrariesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmTestLibrariesUtils.kt\ncom/intellij/ml/llm/java/generate/test/JvmTestLibrariesUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n10468#2:58\n10890#2,5:59\n774#3:64\n865#3:65\n1761#3,3:66\n866#3:69\n1563#3:70\n1634#3,3:71\n*S KotlinDebug\n*F\n+ 1 JvmTestLibrariesUtils.kt\ncom/intellij/ml/llm/java/generate/test/JvmTestLibrariesUtils\n*L\n40#1:58\n40#1:59,5\n45#1:64\n45#1:65\n46#1:66,3\n45#1:69\n51#1:70\n51#1:71,3\n*E\n"})
public final class JvmTestLibrariesUtils {
    @NotNull
    public static final JvmTestLibrariesUtils INSTANCE = new JvmTestLibrariesUtils();

    private JvmTestLibrariesUtils() {
    }

    @RequiresReadLock
    @NotNull
    public final Set<TestLibrary> findAvailableLibraries(@NotNull Project project2, @NotNull Path dirPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        VirtualFile virtualTestDir = LocalFileSystem.getInstance().findFileByNioFile(dirPath.normalize());
        if (virtualTestDir != null) {
            Module module = ProjectFileIndex.getInstance((Project)project2).getModuleForFile(virtualTestDir);
            if (module != null) {
                Module module2 = module;
                boolean bl = false;
                return INSTANCE.getKnownLibraries(module2);
            }
        }
        return this.getKnownLibraries(project2);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TestLibrary> getKnownLibraries(Project project2) {
        void $this$flatMapTo$iv$iv;
        Module[] $this$flatMap$iv = this.modules(project2);
        boolean $i$f$flatMap = false;
        Module[] moduleArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.getKnownLibraries((Module)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TestLibrary> getKnownLibraries(Module module) {
        void $this$filterTo$iv$iv;
        Set<String> presentedLibraries = this.getAllModuleLibraries(module);
        Iterable $this$filter$iv = (Iterable)TestLibrary.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                TestLibrary knownLibrary = (TestLibrary)((Object)element$iv$iv);
                boolean bl2 = false;
                Iterable $this$any$iv = presentedLibraries;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String lib = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)lib, (CharSequence)knownLibrary.getMatchWord().unwrap(), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAllModuleLibraries(Module module) {
        void $this$mapTo$iv$iv;
        List list = ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().getPathsList().getVirtualFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVirtualFiles(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getNameWithoutExtension());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final Module[] modules(Project $this$modules) {
        return ModuleManager.Companion.getInstance($this$modules).getModules();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/java/generate/test/JvmTestLibrariesUtils$TestLibrary;", "", "libName", "Lcom/intellij/ml/llm/privacy/PSString;", "matchWord", "<init>", "(Ljava/lang/String;ILcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;)V", "getLibName", "()Lcom/intellij/ml/llm/privacy/PSString;", "getMatchWord", "JUNIT_5", "JUNIT_4", "TEST_NG", "SPEK", "MOCKITO", "KOTLIN_TEST", "SPRING_TEST", "intellij.ml.llm.java"})
    public static final class TestLibrary
    extends Enum<TestLibrary> {
        @NotNull
        private final PSString libName;
        @NotNull
        private final PSString matchWord;
        public static final /* enum */ TestLibrary JUNIT_5 = new TestLibrary(ConstantsKt.getPrivacyConst((String)"JUnit5"), ConstantsKt.getPrivacyConst((String)"junit-jupiter"));
        public static final /* enum */ TestLibrary JUNIT_4 = new TestLibrary(ConstantsKt.getPrivacyConst((String)"JUnit4"), ConstantsKt.getPrivacyConst((String)"junit-4"));
        public static final /* enum */ TestLibrary TEST_NG = new TestLibrary(ConstantsKt.getPrivacyConst((String)"TestNG"), ConstantsKt.getPrivacyConst((String)"testng"));
        public static final /* enum */ TestLibrary SPEK = new TestLibrary(ConstantsKt.getPrivacyConst((String)"Spek"), ConstantsKt.getPrivacyConst((String)"spek-runner"));
        public static final /* enum */ TestLibrary MOCKITO = new TestLibrary(ConstantsKt.getPrivacyConst((String)"Mockito"), ConstantsKt.getPrivacyConst((String)"mockito"));
        public static final /* enum */ TestLibrary KOTLIN_TEST = new TestLibrary(ConstantsKt.getPrivacyConst((String)"Kotlin-test"), ConstantsKt.getPrivacyConst((String)"kotlin-test"));
        public static final /* enum */ TestLibrary SPRING_TEST = new TestLibrary(ConstantsKt.getPrivacyConst((String)"Spring-test"), ConstantsKt.getPrivacyConst((String)"spring-test"));
        private static final /* synthetic */ TestLibrary[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TestLibrary(PSString libName, PSString matchWord) {
            this.libName = libName;
            this.matchWord = matchWord;
        }

        @NotNull
        public final PSString getLibName() {
            return this.libName;
        }

        @NotNull
        public final PSString getMatchWord() {
            return this.matchWord;
        }

        public static TestLibrary[] values() {
            return (TestLibrary[])$VALUES.clone();
        }

        public static TestLibrary valueOf(String value) {
            return Enum.valueOf(TestLibrary.class, value);
        }

        @NotNull
        public static EnumEntries<TestLibrary> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = testLibraryArray = new TestLibrary[]{TestLibrary.JUNIT_5, TestLibrary.JUNIT_4, TestLibrary.TEST_NG, TestLibrary.SPEK, TestLibrary.MOCKITO, TestLibrary.KOTLIN_TEST, TestLibrary.SPRING_TEST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

